/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.subaquatic.mod.client.item.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import git.jbredwards.subaquatic.mod.common.capability.IBoatType;
import git.jbredwards.subaquatic.mod.common.capability.util.BoatType;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.BakedItemModel;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ItemTextureQuadConverter;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public final class ModelContainerBoat
implements IModel {
    @Nonnull
    public static final ModelContainerBoat DEFAULT = new ModelContainerBoat(TextureMap.field_174945_f);
    static final float NORTH_Z = 0.46871874f;
    static final float SOUTH_Z = 0.53128123f;
    @Nonnull
    final ResourceLocation overlayTexture;

    public ModelContainerBoat(@Nonnull ResourceLocation overlayTextureIn) {
        this.overlayTexture = overlayTextureIn;
    }

    @Nonnull
    public Collection<ResourceLocation> getTextures() {
        return Collections.singletonList(this.overlayTexture);
    }

    @Nonnull
    public IBakedModel bake(@Nonnull IModelState state, @Nonnull VertexFormat format, @Nonnull Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        TRSRTransformation transform = state.apply(Optional.empty()).orElse(TRSRTransformation.identity());
        TextureAtlasSprite overlay = bakedTextureGetter.apply(this.overlayTexture);
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll((Iterable)ItemTextureQuadConverter.convertTexture((VertexFormat)format, (TRSRTransformation)transform, (TextureAtlasSprite)overlay, (TextureAtlasSprite)overlay, (float)0.46871874f, (EnumFacing)EnumFacing.NORTH, (int)-1, (int)1));
        builder.addAll((Iterable)ItemTextureQuadConverter.convertTexture((VertexFormat)format, (TRSRTransformation)transform, (TextureAtlasSprite)overlay, (TextureAtlasSprite)overlay, (float)0.53128123f, (EnumFacing)EnumFacing.SOUTH, (int)-1, (int)1));
        return new BakedModelCache((ImmutableList<BakedQuad>)builder.build(), overlay, transform, (ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation>)PerspectiveMapWrapper.getTransforms((IModelState)state));
    }

    @Nonnull
    public IModel process(@Nonnull ImmutableMap<String, String> customData) {
        JsonElement overlay;
        JsonElement overlay2;
        Calendar calendar;
        if (customData.containsKey((Object)"holidayTexture") && (calendar = Calendar.getInstance()).get(2) + 1 == 12 && calendar.get(5) >= 24 && calendar.get(5) <= 26 && (overlay2 = new JsonParser().parse((String)customData.get((Object)"holidayTexture"))).isJsonPrimitive() && overlay2.getAsJsonPrimitive().isString()) {
            return new ModelContainerBoat(new ResourceLocation(overlay2.getAsString()));
        }
        if (customData.containsKey((Object)"overlayTexture") && (overlay = new JsonParser().parse((String)customData.get((Object)"overlayTexture"))).isJsonPrimitive() && overlay.getAsJsonPrimitive().isString()) {
            return new ModelContainerBoat(new ResourceLocation(overlay.getAsString()));
        }
        return this;
    }

    public static enum Loader implements ICustomModelLoader
    {
        INSTANCE;


        public void func_110549_a(@Nonnull IResourceManager resourceManager) {
        }

        public boolean accepts(@Nonnull ResourceLocation modelLocation) {
            return modelLocation.func_110624_b().equals("subaquatic") && modelLocation.func_110623_a().endsWith("builtin/boat");
        }

        @Nonnull
        public IModel loadModel(@Nonnull ResourceLocation modelLocation) {
            return DEFAULT;
        }
    }

    static final class BakedModelCache
    extends BakedItemModel {
        @Nonnull
        final Map<BoatType, IBakedModel> cache = new HashMap<BoatType, IBakedModel>();
        @Nonnull
        final TRSRTransformation transform;

        public BakedModelCache(@Nonnull ImmutableList<BakedQuad> overlayQuads, @Nonnull TextureAtlasSprite overlayIn, @Nonnull TRSRTransformation transformIn, @Nonnull ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transformsIn) {
            super(overlayQuads, overlayIn, transformsIn, ItemOverrideList.field_188022_a, transformIn.isIdentity());
            this.transform = transformIn;
        }

        @Nonnull
        public ItemOverrideList func_188617_f() {
            return new ItemOverrideList(Collections.emptyList()){

                @Nonnull
                public IBakedModel handleItemState(@Nonnull IBakedModel originalModel, @Nonnull ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
                    IBoatType cap = IBoatType.get((ICapabilityProvider)stack);
                    if (cap != null) {
                        return cache.computeIfAbsent(cap.getType(), type -> {
                            IBakedModel boatModel = Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178089_a(new ItemStack(type.boat, 1, type.boatMeta));
                            ImmutableList.Builder builder = ImmutableList.builder();
                            builder.addAll((Iterable)boatModel.func_188616_a(null, null, 0L));
                            builder.addAll((Iterable)quads);
                            return new BakedItemModel(builder.build(), boatModel.func_177554_e(), transforms, boatModel.func_188617_f(), transform.isIdentity());
                        });
                    }
                    throw new IllegalStateException("Tried to apply subaquatic:builtin/boat model to non boat container item: " + stack.func_77973_b().delegate.name());
                }
            };
        }
    }
}

