/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.subaquatic.mod.client.particle.factory;

import git.jbredwards.subaquatic.mod.client.particle.factory.IParticleColorGetter;
import git.jbredwards.subaquatic.mod.client.particle.factory.IParticleConstructor;
import java.awt.Color;
import java.util.Objects;
import java.util.function.ToIntBiFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.Particle;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ParticleFactoryColorize
implements IParticleConstructor {
    @Nonnull
    public final IParticleColorGetter colorSupplier;
    @Nonnull
    public final IParticleFactory particleFactory;

    public ParticleFactoryColorize(@Nonnull IParticleFactory factoryIn, @Nonnull ToIntBiFunction<World, BlockPos> colorIn) {
        this(factoryIn, (World world, double x, double y, double z) -> new Color(colorIn.applyAsInt(world, new BlockPos(x, y, z))));
    }

    public ParticleFactoryColorize(@Nonnull IParticleFactory factoryIn, @Nonnull IParticleColorGetter colorIn) {
        this.colorSupplier = colorIn;
        this.particleFactory = factoryIn;
    }

    @Override
    @Nonnull
    public Particle generate(@Nonnull World world, double x, double y, double z, double speedX, double speedY, double speedZ, int ... args) {
        return Objects.requireNonNull(this.func_178902_a(-1, world, x, y, z, speedX, speedY, speedZ, args));
    }

    @Override
    @Nullable
    public Particle func_178902_a(int particleID, @Nonnull World worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, int ... args) {
        Particle particle = this.particleFactory.func_178902_a(particleID, worldIn, x, y, z, xSpeed, ySpeed, zSpeed, args);
        if (particle != null) {
            float[] rgb = this.colorSupplier.get(worldIn, x, y, z).getRGBColorComponents(null);
            particle.func_70538_b(rgb[0], rgb[1], rgb[2]);
        }
        return particle;
    }
}

