/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.subaquatic.mod.client.texture;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class MaskTextureAtlasSprite
extends TextureAtlasSprite {
    @Nonnull
    protected final ResourceLocation baseLocation;
    @Nonnull
    protected final ResourceLocation maskLocation;

    public MaskTextureAtlasSprite(@Nonnull ResourceLocation baseLocationIn, @Nonnull ResourceLocation maskLocationIn) {
        super(maskLocationIn + "_base");
        this.baseLocation = baseLocationIn;
        this.maskLocation = maskLocationIn;
    }

    public boolean hasCustomLoader(@Nonnull IResourceManager manager, @Nonnull ResourceLocation location) {
        return true;
    }

    public boolean load(@Nonnull IResourceManager manager, @Nonnull ResourceLocation location, @Nonnull Function<ResourceLocation, TextureAtlasSprite> textureGetter) {
        TextureAtlasSprite base = textureGetter.apply(this.baseLocation);
        TextureAtlasSprite mask = textureGetter.apply(this.maskLocation);
        this.field_130223_c = base.func_94211_a();
        this.field_130224_d = base.func_94216_b();
        int[][] pixels = new int[Minecraft.func_71410_x().field_71474_y.field_151442_I + 1][];
        pixels[0] = new int[this.field_130223_c * this.field_130224_d];
        if (mask.func_94211_a() == this.field_130223_c && mask.func_94216_b() == this.field_130224_d) {
            int[][] basePixels = base.func_147965_a(0);
            int[][] maskPixels = mask.func_147965_a(0);
            for (int i = 0; i < this.field_130223_c * this.field_130224_d; ++i) {
                pixels[0][i] = maskPixels[0][i] >>> 24 == 255 ? 0 : basePixels[0][i];
            }
        }
        this.func_130103_l();
        this.field_110976_a.add(pixels);
        return false;
    }

    @Nonnull
    public Collection<ResourceLocation> getDependencies() {
        return ImmutableList.of((Object)this.baseLocation, (Object)this.maskLocation);
    }
}

