/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.subaquatic.mod.common;

import git.jbredwards.subaquatic.api.event.OnGetEntityFromFishingEvent;
import git.jbredwards.subaquatic.mod.Subaquatic;
import git.jbredwards.subaquatic.mod.common.capability.IBoatType;
import git.jbredwards.subaquatic.mod.common.capability.ICompactFishing;
import git.jbredwards.subaquatic.mod.common.config.SubaquaticConfigHandler;
import git.jbredwards.subaquatic.mod.common.entity.living.EntityCod;
import git.jbredwards.subaquatic.mod.common.entity.living.EntityFish;
import git.jbredwards.subaquatic.mod.common.entity.living.EntityPufferfish;
import git.jbredwards.subaquatic.mod.common.entity.living.EntitySalmon;
import git.jbredwards.subaquatic.mod.common.entity.living.EntityTropicalFish;
import git.jbredwards.subaquatic.mod.common.init.SubaquaticItems;
import git.jbredwards.subaquatic.mod.common.init.SubaquaticSounds;
import git.jbredwards.subaquatic.mod.common.message.SMessageBoatType;
import java.util.Iterator;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.player.ItemFishedEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

@Mod.EventBusSubscriber(modid="subaquatic")
public final class EventHandler {
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    static void improveVanillaBlocks(@Nonnull RegistryEvent.Register<Block> event) {
        Blocks.field_150338_P.func_149663_c("subaquatic.brown_mushroom");
        Blocks.field_150420_aW.func_149663_c(Blocks.field_150338_P.field_149770_b);
        Blocks.field_150423_aK.func_149663_c("subaquatic.carved_pumpkin");
        Blocks.field_150337_Q.func_149663_c("subaquatic.red_mushroom");
        Blocks.field_150419_aX.func_149663_c(Blocks.field_150337_Q.field_149770_b);
        Blocks.field_150358_i.func_149713_g(2);
        Blocks.field_150355_j.func_149713_g(2);
        Blocks.field_150392_bi.func_149672_a(SubaquaticSounds.WET_GRASS);
    }

    @SubscribeEvent
    static void modifyLootTables(@Nonnull LootTableLoadEvent event) throws NullPointerException {
        if ("minecraft:gameplay/fishing/fish".equals(event.getName().toString())) {
            event.getTable().getPool("main").addEntry((LootEntry)new LootEntryItem((Item)SubaquaticItems.COD, 30, 1, new LootFunction[0], new LootCondition[0], "subaquatic:cod"));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    static void realisticFishing(@Nonnull ItemFishedEvent event) {
        if (SubaquaticConfigHandler.Server.Item.realisticFishing) {
            ICompactFishing cap = ICompactFishing.get((ICapabilityProvider)event.getHookEntity());
            int compactFishingLvl = cap != null ? cap.getLevel() : 0;
            int rodDamage = 0;
            Iterator it = event.getDrops().iterator();
            while (it.hasNext()) {
                OnGetEntityFromFishingEvent entityEvent = new OnGetEntityFromFishingEvent((ItemStack)it.next(), event.getHookEntity(), event.getRodDamage(), compactFishingLvl);
                if (MinecraftForge.EVENT_BUS.post((Event)entityEvent)) {
                    it.remove();
                    event.setCanceled(true);
                }
                rodDamage += entityEvent.rodDamage;
            }
            if (rodDamage != 0) {
                event.damageRodBy(rodDamage);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    static void realisticFishingResult(@Nonnull OnGetEntityFromFishingEvent event) {
        if (event.itemToFish.func_77973_b() == SubaquaticItems.COD) {
            event.spawnEntityOrTryCompact((Entity)new EntityCod(event.getWorld()));
        } else if (event.itemToFish.func_77973_b() == Items.field_151115_aP) {
            switch (event.itemToFish.func_77960_j()) {
                case 0: {
                    event.spawnEntityOrTryCompact((Entity)new EntityFish(event.getWorld()));
                    break;
                }
                case 1: {
                    event.spawnEntityOrTryCompact((Entity)new EntitySalmon(event.getWorld()));
                    break;
                }
                case 2: {
                    event.spawnEntityOrTryCompact((Entity)new EntityTropicalFish(event.getWorld()));
                    break;
                }
                default: {
                    event.spawnEntityOrTryCompact((Entity)new EntityPufferfish(event.getWorld()));
                }
            }
        }
    }

    @SubscribeEvent
    static void syncBoatContainers(@Nonnull PlayerEvent.StartTracking event) {
        IBoatType cap;
        if (event.getEntityPlayer() instanceof EntityPlayerMP && (cap = IBoatType.get((ICapabilityProvider)event.getTarget())) != null) {
            Subaquatic.WRAPPER.sendTo((IMessage)new SMessageBoatType(cap.getType(), event.getTarget()), (EntityPlayerMP)event.getEntityPlayer());
        }
    }
}

