/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.subaquatic.mod.common.block;

import git.jbredwards.subaquatic.mod.common.config.SubaquaticConfigHandler;
import git.jbredwards.subaquatic.mod.common.init.SubaquaticSounds;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;

public abstract class AbstractBlockCoral
extends Block
implements IGrowable {
    @Nonnull
    public static final PropertyBool ALIVE = PropertyBool.func_177716_a((String)"alive");
    @Nonnull
    public final Fluid neededFluid;

    public AbstractBlockCoral(@Nonnull Fluid neededFluidIn, @Nonnull Material materialIn) {
        this(neededFluidIn, materialIn, materialIn.func_151565_r());
    }

    public AbstractBlockCoral(@Nonnull Fluid neededFluidIn, @Nonnull Material materialIn, @Nonnull MapColor mapColorIn) {
        super(materialIn, mapColorIn);
        this.neededFluid = neededFluidIn;
        this.func_149675_a(true);
    }

    @Nonnull
    protected abstract BlockStateContainer func_180661_e();

    @Nonnull
    public abstract IBlockState func_176203_a(int var1);

    public abstract int func_176201_c(@Nonnull IBlockState var1);

    public int func_149745_a(@Nonnull Random random) {
        return SubaquaticConfigHandler.Server.Block.coralNeedsSilkTouch ? 0 : 1;
    }

    public int func_180651_a(@Nonnull IBlockState state) {
        return !SubaquaticConfigHandler.Server.Block.coralNeedsSilkTouch && (Boolean)state.func_177229_b((IProperty)ALIVE) != false ? 0 : 1;
    }

    protected boolean func_149700_E() {
        return true;
    }

    @Nonnull
    protected ItemStack func_180643_i(@Nonnull IBlockState state) {
        return new ItemStack((Block)this, 1, (Boolean)state.func_177229_b((IProperty)ALIVE) != false ? 0 : 1);
    }

    @Nonnull
    public ItemStack func_185473_a(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        return this.func_180643_i(state);
    }

    @Nonnull
    public SoundType getSoundType(@Nonnull IBlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nullable Entity entity) {
        return (Boolean)state.func_177229_b((IProperty)ALIVE) != false ? SubaquaticSounds.CORAL : SoundType.field_185851_d;
    }

    @Nonnull
    public MapColor func_180659_g(@Nonnull IBlockState state, @Nonnull IBlockAccess worldIn, @Nonnull BlockPos pos) {
        return (Boolean)state.func_177229_b((IProperty)ALIVE) != false ? this.field_181083_K : MapColor.field_151665_m;
    }

    @Nonnull
    public Material func_149688_o(@Nonnull IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)ALIVE) != false ? this.field_149764_J : Material.field_151576_e;
    }

    @Nonnull
    public EnumPushReaction func_149656_h(@Nonnull IBlockState state) {
        return EnumPushReaction.NORMAL;
    }

    public void func_180650_b(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull Random rand) {
        if (((Boolean)state.func_177229_b((IProperty)ALIVE)).booleanValue() && !this.hasNeededFluid(worldIn, pos, state)) {
            worldIn.func_175656_a(pos, state.func_177226_a((IProperty)ALIVE, (Comparable)Boolean.valueOf(false)));
        }
    }

    public boolean func_176473_a(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state, boolean isClient) {
        return (SubaquaticConfigHandler.Common.Block.deadCoralBonemeal || (Boolean)state.func_177229_b((IProperty)ALIVE) != false) && this.hasNeededFluid(worldIn, pos, state);
    }

    public boolean func_180670_a(@Nonnull World worldIn, @Nonnull Random rand, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        return true;
    }

    public void func_176474_b(@Nonnull World worldIn, @Nonnull Random rand, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        if (((Boolean)state.func_177229_b((IProperty)ALIVE)).booleanValue()) {
            this.onGrowSpread(worldIn, rand, pos, state);
        } else if (SubaquaticConfigHandler.Common.Block.deadCoralBonemeal) {
            worldIn.func_175656_a(pos, state.func_177226_a((IProperty)ALIVE, (Comparable)Boolean.valueOf(true)));
        }
    }

    public abstract boolean hasNeededFluid(@Nonnull World var1, @Nonnull BlockPos var2, @Nonnull IBlockState var3);

    protected void onGrowSpread(@Nonnull World world, @Nonnull Random rand, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
    }
}

