/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.subaquatic.mod.common.block;

import git.jbredwards.fluidlogged_api.api.block.IFluidloggable;
import git.jbredwards.fluidlogged_api.api.util.FluidState;
import git.jbredwards.fluidlogged_api.api.util.FluidloggedUtils;
import git.jbredwards.subaquatic.api.block.IOxygenSupplier;
import git.jbredwards.subaquatic.mod.client.item.ICustomModel;
import git.jbredwards.subaquatic.mod.client.particle.ParticleBubbleColumnDown;
import git.jbredwards.subaquatic.mod.client.particle.ParticleBubbleColumnUp;
import git.jbredwards.subaquatic.mod.common.capability.IBubbleColumn;
import git.jbredwards.subaquatic.mod.common.config.SubaquaticConfigHandler;
import git.jbredwards.subaquatic.mod.common.init.SubaquaticBlocks;
import git.jbredwards.subaquatic.mod.common.init.SubaquaticSounds;
import java.util.Collections;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber(modid="subaquatic")
public class BlockBubbleColumn
extends Block
implements IFluidloggable,
ICustomModel,
IOxygenSupplier {
    public final boolean isDown;

    public BlockBubbleColumn(@Nonnull Material materialIn, boolean isDownIn) {
        this(materialIn, materialIn.func_151565_r(), isDownIn);
    }

    public BlockBubbleColumn(@Nonnull Material materialIn, @Nonnull MapColor mapColorIn, boolean isDownIn) {
        super(materialIn, mapColorIn);
        this.isDown = isDownIn;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        ModelLoader.setCustomStateMapper((Block)this, block -> Collections.emptyMap());
    }

    @Nonnull
    public EnumBlockRenderType func_149645_b(@Nonnull IBlockState state) {
        return EnumBlockRenderType.INVISIBLE;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(@Nonnull IBlockState blockState, @Nonnull IBlockAccess worldIn, @Nonnull BlockPos pos) {
        return field_185506_k;
    }

    @Nonnull
    public Item func_180660_a(@Nonnull IBlockState state, @Nonnull Random rand, int fortune) {
        return Items.field_190931_a;
    }

    public int func_149745_a(@Nonnull Random random) {
        return 0;
    }

    public boolean func_149662_c(@Nonnull IBlockState state) {
        return false;
    }

    public boolean func_149686_d(@Nonnull IBlockState state) {
        return false;
    }

    public boolean func_176209_a(@Nonnull IBlockState state, boolean hitIfLiquid) {
        return hitIfLiquid;
    }

    public boolean isFluidValid(@Nonnull IBlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull Fluid fluid) {
        return fluid.canBePlacedInWorld() && fluid.getBlock().func_176223_P().func_185904_a() == Material.field_151586_h;
    }

    @Nonnull
    public EnumActionResult onFluidDrain(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState here, int blockFlags) {
        world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), blockFlags);
        return EnumActionResult.SUCCESS;
    }

    @Nonnull
    public BlockFaceShape func_193383_a(@Nonnull IBlockAccess worldIn, @Nonnull IBlockState state, @Nonnull BlockPos pos, @Nonnull EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public int func_149738_a(@Nonnull World worldIn) {
        return 5;
    }

    public void func_176213_c(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        worldIn.func_175684_a(pos, (Block)this, this.func_149738_a(worldIn));
    }

    public void func_189540_a(@Nonnull IBlockState state, @Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull Block blockIn, @Nonnull BlockPos fromPos) {
        if (fromPos.equals((Object)pos.func_177984_a()) || fromPos.equals((Object)pos.func_177977_b())) {
            worldIn.func_175684_a(pos, (Block)this, this.func_149738_a(worldIn));
        }
    }

    public void func_180650_b(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull Random rand) {
        IBlockState soil = worldIn.func_180495_p(pos.func_177977_b());
        if (soil.func_177230_c() == this || this.isValidSoil(soil)) {
            this.trySpreadTo(worldIn, pos.func_177984_a());
        } else {
            worldIn.func_175698_g(pos);
        }
    }

    public boolean isValidSoil(@Nonnull IBlockState soil) {
        return this.isDown ? SubaquaticConfigHandler.BUBBLE_COLUMN_SOIL_DOWN.contains(soil) : SubaquaticConfigHandler.BUBBLE_COLUMN_SOIL_UP.contains(soil);
    }

    public void trySpreadTo(@Nonnull World worldIn, @Nonnull BlockPos pos) {
        FluidState aboveFluid;
        IBlockState above = worldIn.func_180495_p(pos);
        if (above.func_177230_c() != this && above.func_177230_c().func_176200_f((IBlockAccess)worldIn, pos) && !(aboveFluid = FluidloggedUtils.getFluidState((IBlockAccess)worldIn, (BlockPos)pos, (IBlockState)above)).isEmpty() && this.isFluidValid(this.func_176223_P(), worldIn, pos, aboveFluid.getFluid()) && FluidloggedUtils.isFluidloggableFluid((IBlockState)aboveFluid.getState(), (World)worldIn, (BlockPos)pos)) {
            worldIn.func_180501_a(pos, this.func_176223_P(), 2);
        }
    }

    public void func_180634_a(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull Entity entityIn) {
        IBubbleColumn cap = IBubbleColumn.get((ICapabilityProvider)entityIn);
        if (cap != null) {
            IBlockState above = worldIn.func_180495_p(pos.func_177984_a());
            if (above.func_177230_c().isAir(above, (IBlockAccess)worldIn, pos.func_177984_a())) {
                cap.onCollideTop(entityIn, this);
                if (worldIn instanceof WorldServer) {
                    ((WorldServer)worldIn).func_175739_a(EnumParticleTypes.WATER_SPLASH, (double)pos.func_177958_n() + 0.5, (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p() + 0.5, 2, 0.25, 0.0, 0.25, 1.0, new int[0]);
                    ((WorldServer)worldIn).func_175739_a(EnumParticleTypes.WATER_BUBBLE, (double)pos.func_177958_n() + 0.5, (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p() + 0.5, 2, 0.25, 0.0, 0.25, 0.2, new int[0]);
                }
            } else {
                cap.onCollide(entityIn, this);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(@Nonnull IBlockState stateIn, @Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull Random rand) {
        this.spawnParticles(worldIn, pos, rand);
        if (rand.nextInt(200) == 0) {
            worldIn.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, this.getAmbientSound(), SoundCategory.BLOCKS, 0.2f + rand.nextFloat() * 0.2f, 0.9f + rand.nextFloat() * 0.15f, false);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void spawnParticles(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull Random rand) {
        ParticleManager manager = Minecraft.func_71410_x().field_71452_i;
        if (this.isDown) {
            manager.func_78873_a(ParticleBubbleColumnDown.FACTORY.generate(worldIn, (double)pos.func_177958_n() + 0.5, (double)((float)pos.func_177956_o() + rand.nextFloat()) - 0.125, (double)pos.func_177952_p() + 0.5, 12.0, -0.03333333333333333, 0.4, rand.nextInt(360)));
        } else {
            manager.func_78873_a(ParticleBubbleColumnUp.FACTORY.generate(worldIn, (double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, 0.0, 0.4, 0.0, new int[0]));
            manager.func_78873_a(ParticleBubbleColumnUp.FACTORY.generate(worldIn, (float)pos.func_177958_n() + rand.nextFloat(), (float)pos.func_177956_o() + rand.nextFloat(), (float)pos.func_177952_p() + rand.nextFloat(), 0.0, 0.4, 0.0, new int[0]));
        }
    }

    @Nonnull
    public SoundEvent getAmbientSound() {
        return this.isDown ? SubaquaticSounds.BUBBLE_COLUMN_DOWN_AMBIENT : SubaquaticSounds.BUBBLE_COLUMN_UP_AMBIENT;
    }

    @Nonnull
    public SoundEvent getInsideSound() {
        return this.isDown ? SubaquaticSounds.BUBBLE_COLUMN_DOWN_INSIDE : SubaquaticSounds.BUBBLE_COLUMN_UP_INSIDE;
    }

    @SubscribeEvent
    static void generateBubbleColumns(@Nonnull BlockEvent.NeighborNotifyEvent event) {
        if (!event.getWorld().field_72995_K) {
            if (event.getNotifiedSides().contains(EnumFacing.UP)) {
                if (SubaquaticBlocks.BUBBLE_COLUMN_UP.isValidSoil(event.getState())) {
                    SubaquaticBlocks.BUBBLE_COLUMN_UP.trySpreadTo(event.getWorld(), event.getPos().func_177984_a());
                } else if (SubaquaticBlocks.BUBBLE_COLUMN_DOWN.isValidSoil(event.getState())) {
                    SubaquaticBlocks.BUBBLE_COLUMN_DOWN.trySpreadTo(event.getWorld(), event.getPos().func_177984_a());
                }
            }
            if ((event.getState().func_177230_c() instanceof BlockBubbleColumn || FluidloggedUtils.isFluid((IBlockState)event.getState())) && event.getNotifiedSides().contains(EnumFacing.DOWN)) {
                IBlockState state = event.getWorld().func_180495_p(event.getPos().func_177977_b());
                if (SubaquaticBlocks.BUBBLE_COLUMN_UP.isValidSoil(state)) {
                    SubaquaticBlocks.BUBBLE_COLUMN_UP.trySpreadTo(event.getWorld(), event.getPos());
                } else if (SubaquaticBlocks.BUBBLE_COLUMN_DOWN.isValidSoil(state)) {
                    SubaquaticBlocks.BUBBLE_COLUMN_DOWN.trySpreadTo(event.getWorld(), event.getPos());
                }
            }
        }
    }
}

