/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.subaquatic.mod.common.block;

import git.jbredwards.fluidlogged_api.api.util.FluidState;
import git.jbredwards.fluidlogged_api.api.util.FluidloggedUtils;
import git.jbredwards.subaquatic.mod.common.block.BlockCoralFin;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;

public class BlockCoralFan
extends BlockCoralFin {
    @Nonnull
    public static final PropertyDirection SIDE = PropertyDirection.func_177712_a((String)"side", side -> side != EnumFacing.DOWN);
    @Nonnull
    protected static final AxisAlignedBB[] AABB = new AxisAlignedBB[]{null, new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 0.25, 0.875), new AxisAlignedBB(0.125, 0.4375, 0.5, 0.875, 0.5625, 1.0), new AxisAlignedBB(0.125, 0.4375, 0.0, 0.875, 0.5625, 0.5), new AxisAlignedBB(0.5, 0.4375, 0.125, 1.0, 0.5625, 0.875), new AxisAlignedBB(0.0, 0.4375, 0.125, 0.5, 0.5625, 0.875)};

    public BlockCoralFan(@Nonnull Fluid neededFluidIn, @Nonnull Material materialIn) {
        super(neededFluidIn, materialIn);
    }

    public BlockCoralFan(@Nonnull Fluid neededFluidIn, @Nonnull Material materialIn, @Nonnull MapColor mapColorIn) {
        super(neededFluidIn, materialIn, mapColorIn);
    }

    @Override
    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{ALIVE, SIDE});
    }

    @Override
    public int func_176201_c(@Nonnull IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)SIDE)).func_176745_a() << 1 | ((Boolean)state.func_177229_b((IProperty)ALIVE) != false ? 0 : 1);
    }

    @Override
    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)SIDE, (Comparable)EnumFacing.func_82600_a((int)(meta >> 1))).func_177226_a((IProperty)ALIVE, (Comparable)Boolean.valueOf((meta & 1) == 0));
    }

    @Override
    @Nonnull
    public AxisAlignedBB func_185496_a(@Nonnull IBlockState state, @Nonnull IBlockAccess source, @Nonnull BlockPos pos) {
        return AABB[((EnumFacing)state.func_177229_b((IProperty)SIDE)).func_176745_a()];
    }

    @Nonnull
    public IBlockState func_180642_a(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ, int meta, @Nonnull EntityLivingBase placer) {
        IBlockState state = this.func_176223_P().func_177226_a((IProperty)ALIVE, (Comparable)Boolean.valueOf((meta & 1) == 0));
        if (this.func_176198_a(worldIn, pos, facing)) {
            return state.func_177226_a((IProperty)SIDE, (Comparable)facing);
        }
        for (EnumFacing side : EnumFacing.values()) {
            if (side == EnumFacing.DOWN || !this.func_176198_a(worldIn, pos, side)) continue;
            return state.func_177226_a((IProperty)SIDE, (Comparable)side);
        }
        throw new IllegalStateException("Could not place coral fan on illegal side");
    }

    @Override
    public boolean func_176196_c(@Nonnull World worldIn, @Nonnull BlockPos pos) {
        for (EnumFacing side : EnumFacing.values()) {
            if (side == EnumFacing.DOWN || !this.canPlaceOnSide(worldIn, pos, side)) continue;
            return true;
        }
        return false;
    }

    public boolean func_176198_a(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull EnumFacing side) {
        return side == EnumFacing.DOWN ? this.func_176196_c(worldIn, pos) : this.canPlaceOnSide(worldIn, pos, side);
    }

    protected boolean canPlaceOnSide(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull EnumFacing side) {
        return worldIn.isSideSolid(pos.func_177972_a(side.func_176734_d()), side);
    }

    @Override
    public void func_189540_a(@Nonnull IBlockState state, @Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull Block blockIn, @Nonnull BlockPos fromPos) {
        if (!this.func_176198_a(worldIn, pos, (EnumFacing)state.func_177229_b((IProperty)SIDE))) {
            worldIn.func_175655_b(pos, true);
        }
    }

    @Override
    public boolean hasNeededFluid(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        return FluidloggedUtils.isCompatibleFluid((Fluid)this.neededFluid, (Fluid)FluidState.get((IBlockAccess)world, (BlockPos)pos).getFluid()) || FluidloggedUtils.isCompatibleFluid((Fluid)this.neededFluid, (Fluid)FluidState.get((IBlockAccess)world, (BlockPos)pos.func_177972_a((EnumFacing)state.func_177229_b((IProperty)SIDE))).getFluid());
    }
}

