/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.subaquatic.mod.common.block;

import com.google.common.collect.ImmutableList;
import git.jbredwards.fluidlogged_api.api.block.IFluidloggable;
import git.jbredwards.subaquatic.mod.common.init.SubaquaticItems;
import git.jbredwards.subaquatic.mod.common.item.util.IBlockCluster;
import git.jbredwards.subaquatic.mod.common.tileentity.TileEntityGlowLichen;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

public class BlockGlowLichen
extends Block
implements IBlockCluster,
IFluidloggable,
IGrowable,
IShearable,
ITileEntityProvider {
    @Nonnull
    public static final PropertyBool DOWN = PropertyBool.func_177716_a((String)"down");
    @Nonnull
    public static final PropertyBool UP = PropertyBool.func_177716_a((String)"up");
    @Nonnull
    public static final PropertyBool NORTH = PropertyBool.func_177716_a((String)"north");
    @Nonnull
    public static final PropertyBool SOUTH = PropertyBool.func_177716_a((String)"south");
    @Nonnull
    public static final PropertyBool WEST = PropertyBool.func_177716_a((String)"west");
    @Nonnull
    public static final PropertyBool EAST = PropertyBool.func_177716_a((String)"east");
    @Nonnull
    public static final List<Pair<AxisAlignedBB, EnumFacing>> BOXES = ImmutableList.of((Object)Pair.of((Object)new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.0625, 1.0), (Object)EnumFacing.DOWN), (Object)Pair.of((Object)new AxisAlignedBB(0.0, 0.9375, 0.0, 1.0, 1.0, 1.0), (Object)EnumFacing.UP), (Object)Pair.of((Object)new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.0625), (Object)EnumFacing.NORTH), (Object)Pair.of((Object)new AxisAlignedBB(0.0, 0.0, 0.9375, 1.0, 1.0, 1.0), (Object)EnumFacing.SOUTH), (Object)Pair.of((Object)new AxisAlignedBB(0.0, 0.0, 0.0, 0.0625, 1.0, 1.0), (Object)EnumFacing.WEST), (Object)Pair.of((Object)new AxisAlignedBB(0.9375, 0.0, 0.0, 1.0, 1.0, 1.0), (Object)EnumFacing.EAST));

    public BlockGlowLichen(@Nonnull Material materialIn) {
        this(materialIn, materialIn.func_151565_r());
    }

    public BlockGlowLichen(@Nonnull Material materialIn, @Nonnull MapColor mapColorIn) {
        super(materialIn, mapColorIn);
        this.func_149675_a(true);
    }

    @Nonnull
    public TileEntity func_149915_a(@Nonnull World worldIn, int meta) {
        return new TileEntityGlowLichen();
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{DOWN, UP, NORTH, SOUTH, WEST, EAST});
    }

    public int func_176201_c(@Nonnull IBlockState state) {
        return 0;
    }

    public boolean func_149686_d(@Nonnull IBlockState state) {
        return false;
    }

    public boolean func_149662_c(@Nonnull IBlockState state) {
        return false;
    }

    public boolean isSideSolid(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EnumFacing side) {
        return false;
    }

    @Nonnull
    public BlockFaceShape func_193383_a(@Nonnull IBlockAccess worldIn, @Nonnull IBlockState state, @Nonnull BlockPos pos, @Nonnull EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @Nonnull
    public IBlockState func_176221_a(@Nonnull IBlockState state, @Nonnull IBlockAccess worldIn, @Nonnull BlockPos pos) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileEntityGlowLichen) {
            TileEntityGlowLichen glowLichen = (TileEntityGlowLichen)tile;
            state = state.func_177226_a((IProperty)DOWN, (Comparable)Boolean.valueOf(glowLichen.isAttachedTo(EnumFacing.DOWN)));
            state = state.func_177226_a((IProperty)UP, (Comparable)Boolean.valueOf(glowLichen.isAttachedTo(EnumFacing.UP)));
            state = state.func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(glowLichen.isAttachedTo(EnumFacing.NORTH)));
            state = state.func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(glowLichen.isAttachedTo(EnumFacing.SOUTH)));
            state = state.func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(glowLichen.isAttachedTo(EnumFacing.WEST)));
            state = state.func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(glowLichen.isAttachedTo(EnumFacing.EAST)));
        }
        return state;
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(@Nonnull IBlockState state, @Nonnull IBlockAccess source, @Nonnull BlockPos pos) {
        TileEntity tile = source.func_175625_s(pos);
        if (tile instanceof TileEntityGlowLichen) {
            AxisAlignedBB bb = null;
            for (Pair<AxisAlignedBB, EnumFacing> entry : BOXES) {
                if (!((TileEntityGlowLichen)tile).isAttachedTo((EnumFacing)entry.getValue())) continue;
                bb = bb != null ? bb.func_111270_a((AxisAlignedBB)entry.getKey()) : (AxisAlignedBB)entry.getKey();
            }
            if (bb != null) {
                return bb;
            }
        }
        return field_185505_j;
    }

    @Nullable
    public RayTraceResult func_180636_a(@Nonnull IBlockState blockState, @Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull Vec3d start, @Nonnull Vec3d end) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileEntityGlowLichen) {
            List list = BOXES.stream().filter(entry -> ((TileEntityGlowLichen)tile).isAttachedTo((EnumFacing)entry.getValue())).map(entry -> this.func_185503_a(pos, start, end, (AxisAlignedBB)entry.getKey())).filter(Objects::nonNull).collect(Collectors.toList());
            if (list.isEmpty()) {
                return null;
            }
            RayTraceResult furthest = null;
            double dist = -1.0;
            for (RayTraceResult trace : list) {
                double newDist = trace.field_72307_f.func_72436_e(end);
                if (!(newDist > dist)) continue;
                furthest = trace;
                dist = newDist;
            }
            return furthest;
        }
        return this.func_185503_a(pos, start, end, field_185505_j);
    }

    @Nullable
    public AxisAlignedBB func_180646_a(@Nonnull IBlockState blockState, @Nonnull IBlockAccess worldIn, @Nonnull BlockPos pos) {
        return field_185506_k;
    }

    public boolean func_176198_a(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull EnumFacing side) {
        return this.func_176196_c(worldIn, pos) && worldIn.func_180495_p(pos.func_177972_a(side.func_176734_d())).isSideSolid((IBlockAccess)worldIn, pos, side);
    }

    public void func_180645_a(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull Random random) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileEntityGlowLichen) {
            for (EnumFacing side : EnumFacing.field_82609_l) {
                if (this.checkAndDropBlock((TileEntityGlowLichen)tile, worldIn, pos, side)) break;
            }
        }
    }

    public void func_189540_a(@Nonnull IBlockState state, @Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull Block blockIn, @Nonnull BlockPos fromPos) {
        TileEntity tile;
        if (!pos.equals((Object)fromPos) && (tile = worldIn.func_175625_s(pos)) instanceof TileEntityGlowLichen) {
            BlockPos diff = pos.func_177973_b((Vec3i)fromPos);
            this.checkAndDropBlock((TileEntityGlowLichen)tile, worldIn, pos, EnumFacing.func_176737_a((float)diff.func_177958_n(), (float)diff.func_177956_o(), (float)diff.func_177952_p()));
        }
    }

    public boolean checkAndDropBlock(@Nonnull TileEntityGlowLichen tile, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull EnumFacing side) {
        if (tile.isAttachedTo(side.func_176734_d()) && !this.func_176198_a(world, pos, side)) {
            tile.setAttachedTo(side.func_176734_d(), false);
            if (tile.attachedSideData == 0) {
                return world.func_175698_g(pos);
            }
            world.func_184138_a(pos, this.func_176223_P(), this.func_176223_P(), 2);
        }
        return false;
    }

    @Override
    public boolean canClusterWith(@Nonnull ItemStack stack, @Nonnull EntityPlayer player, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull EnumFacing side, @Nonnull IBlockState oldState) {
        TileEntity tile = world.func_175625_s(pos);
        return tile instanceof TileEntityGlowLichen && !((TileEntityGlowLichen)tile).isAttachedTo(side.func_176734_d());
    }

    @Override
    public boolean clusterWith(@Nonnull ItemBlock itemBlock, @Nonnull ItemStack stack, @Nonnull EntityPlayer player, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull EnumFacing side, float hitX, float hitY, float hitZ, @Nonnull IBlockState oldState) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityGlowLichen) {
            ((TileEntityGlowLichen)tile).setAttachedTo(side.func_176734_d(), true);
            world.func_184138_a(pos, this.func_176223_P(), this.func_176223_P(), 2);
            if (player instanceof EntityPlayerMP) {
                CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)player, pos, stack);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean createInitialCluster(@Nonnull ItemBlock itemBlock, @Nonnull ItemStack stack, @Nonnull EntityPlayer player, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull EnumFacing side, float hitX, float hitY, float hitZ, @Nonnull IBlockState oldState) {
        world.func_180501_a(pos, this.func_176223_P(), 11);
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityGlowLichen) {
            ((TileEntityGlowLichen)tile).attachedSideData = 0;
            ((TileEntityGlowLichen)tile).setAttachedTo(side.func_176734_d(), true);
            world.func_184138_a(pos, this.func_176223_P(), this.func_176223_P(), 2);
            if (player instanceof EntityPlayerMP) {
                CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)player, pos, stack);
            }
            return true;
        }
        return false;
    }

    public int func_149745_a(@Nonnull Random random) {
        return 0;
    }

    public boolean isShearable(@Nonnull ItemStack item, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        return true;
    }

    @Nonnull
    public List<ItemStack> onSheared(@Nonnull ItemStack item, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, int fortune) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityGlowLichen) {
            for (EnumFacing side : EnumFacing.field_82609_l) {
                if (!((TileEntityGlowLichen)tile).isAttachedTo(side)) continue;
                items.add(new ItemStack((Item)SubaquaticItems.GLOW_LICHEN));
            }
        }
        return items;
    }

    public boolean func_176473_a(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state, boolean isClient) {
        return true;
    }

    public boolean func_180670_a(@Nonnull World worldIn, @Nonnull Random rand, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        return true;
    }

    public void func_176474_b(@Nonnull World worldIn, @Nonnull Random rand, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        if (!worldIn.field_72995_K) {
            EntityItem item = new EntityItem(worldIn, (double)pos.func_177958_n() + (double)worldIn.field_73012_v.nextFloat() * 0.5 + 0.25, (double)pos.func_177956_o() + (double)worldIn.field_73012_v.nextFloat() * 0.5 + 0.25, (double)pos.func_177952_p() + (double)worldIn.field_73012_v.nextFloat() * 0.5 + 0.25, new ItemStack((Item)SubaquaticItems.GLOW_LICHEN));
            item.func_174869_p();
            worldIn.func_72838_d((Entity)item);
        }
    }
}

