/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.subaquatic.mod.common.block;

import git.jbredwards.fluidlogged_api.api.block.IFluidloggable;
import git.jbredwards.subaquatic.mod.common.init.SubaquaticItems;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockHangingRoots
extends Block
implements IFluidloggable,
IShearable {
    @Nonnull
    public static final PropertyDirection SIDE = PropertyDirection.func_177714_a((String)"side");
    @Nonnull
    protected static final AxisAlignedBB[] AABB = new AxisAlignedBB[]{new AxisAlignedBB(0.125, 0.625, 0.125, 0.875, 1.0, 0.875), new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 0.25, 0.875), new AxisAlignedBB(0.125, 0.0, 0.875, 0.875, 0.625, 1.0), new AxisAlignedBB(0.125, 0.0, 0.0, 0.875, 0.625, 0.125), new AxisAlignedBB(0.875, 0.0, 0.125, 1.0, 0.625, 0.875), new AxisAlignedBB(0.0, 0.0, 0.125, 0.125, 0.625, 0.875)};

    public BlockHangingRoots(@Nonnull Material materialIn) {
        this(materialIn, materialIn.func_151565_r());
    }

    public BlockHangingRoots(@Nonnull Material materialIn, @Nonnull MapColor mapColorIn) {
        super(materialIn, mapColorIn);
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)SIDE, (Comparable)EnumFacing.DOWN));
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{SIDE});
    }

    public int func_176201_c(@Nonnull IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)SIDE)).func_176745_a();
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)SIDE, (Comparable)EnumFacing.func_82600_a((int)meta));
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(@Nonnull IBlockState state, @Nonnull IBlockAccess source, @Nonnull BlockPos pos) {
        return AABB[((EnumFacing)state.func_177229_b((IProperty)SIDE)).func_176745_a()].func_191194_a(state.func_191059_e(source, pos));
    }

    @Nullable
    public AxisAlignedBB func_180646_a(@Nonnull IBlockState blockState, @Nonnull IBlockAccess worldIn, @Nonnull BlockPos pos) {
        return field_185506_k;
    }

    @Nonnull
    public IBlockState func_180642_a(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ, int meta, @Nonnull EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)SIDE, (Comparable)facing);
    }

    public boolean func_176198_a(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull EnumFacing side) {
        return worldIn.func_180495_p(pos.func_177972_a(side.func_176734_d())).isSideSolid((IBlockAccess)worldIn, pos, side);
    }

    public void func_189540_a(@Nonnull IBlockState state, @Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull Block blockIn, @Nonnull BlockPos fromPos) {
        if (!this.func_176198_a(worldIn, pos, (EnumFacing)state.func_177229_b((IProperty)SIDE))) {
            worldIn.func_175655_b(pos, false);
        }
    }

    public boolean func_149662_c(@Nonnull IBlockState state) {
        return false;
    }

    public boolean func_149686_d(@Nonnull IBlockState state) {
        return false;
    }

    public boolean isSideSolid(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EnumFacing side) {
        return false;
    }

    public BlockFaceShape func_193383_a(@Nonnull IBlockAccess worldIn, @Nonnull IBlockState state, @Nonnull BlockPos pos, @Nonnull EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    @Nullable
    public PathNodeType getAiPathNodeType(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        return PathNodeType.OPEN;
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @Nonnull
    public Vec3d func_190949_e(@Nonnull IBlockState state, @Nonnull IBlockAccess worldIn, @Nonnull BlockPos pos) {
        long coordRand = MathHelper.func_180187_c((int)pos.func_177958_n(), (int)pos.func_177956_o(), (int)pos.func_177952_p());
        switch (((EnumFacing)state.func_177229_b((IProperty)SIDE)).func_176740_k()) {
            case X: {
                return new Vec3d(0.0, (double)((float)(coordRand >> 20 & 0xFL) / 15.0f) * 0.25, ((double)((float)(coordRand >> 24 & 0xFL) / 15.0f) - 0.5) * 0.25);
            }
            case Z: {
                return new Vec3d(((double)((float)(coordRand >> 16 & 0xFL) / 15.0f) - 0.5) * 0.25, (double)((float)(coordRand >> 20 & 0xFL) / 15.0f) * 0.25, 0.0);
            }
        }
        return new Vec3d(((double)((float)(coordRand >> 16 & 0xFL) / 15.0f) - 0.5) * 0.25, 0.0, ((double)((float)(coordRand >> 24 & 0xFL) / 15.0f) - 0.5) * 0.25);
    }

    public int func_149745_a(@Nonnull Random random) {
        return 0;
    }

    public boolean isShearable(@Nonnull ItemStack item, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        return true;
    }

    @Nonnull
    public List<ItemStack> onSheared(@Nonnull ItemStack item, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, int fortune) {
        return Collections.singletonList(new ItemStack((Item)SubaquaticItems.HANGING_ROOTS));
    }
}

