/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.subaquatic.mod.common.block;

import git.jbredwards.fluidlogged_api.api.block.BlockWaterloggedPlant;
import git.jbredwards.fluidlogged_api.api.util.FluidloggedUtils;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;

public class BlockKelp
extends BlockWaterloggedPlant
implements IGrowable {
    @Nonnull
    public static final PropertyInteger AGE = PropertyInteger.func_177719_a((String)"age", (int)0, (int)15);
    @Nonnull
    public static final PropertyBool TOP = PropertyBool.func_177716_a((String)"top");
    @Nonnull
    protected static final AxisAlignedBB KELP_TOP_BB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.625, 1.0);

    public BlockKelp(@Nonnull Material materialIn) {
        this(materialIn, materialIn.func_151565_r());
    }

    public BlockKelp(@Nonnull Material materialIn, @Nonnull MapColor mapColorIn) {
        super(materialIn, mapColorIn);
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)TOP, (Comparable)Boolean.valueOf(false)));
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AGE, TOP});
    }

    public int func_176201_c(@Nonnull IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)AGE);
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(meta & 0xF));
    }

    @Nonnull
    public IBlockState func_180642_a(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ, int meta, @Nonnull EntityLivingBase placer) {
        IBlockState down = worldIn.func_180495_p(pos.func_177977_b());
        return this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)(BlockKelp.func_149680_a((Block)down.func_177230_c(), (Block)this) ? (Integer)down.func_177229_b((IProperty)AGE) : Integer.valueOf(worldIn.field_73012_v.nextInt(4))));
    }

    @Nonnull
    public IBlockState func_176221_a(@Nonnull IBlockState state, @Nonnull IBlockAccess worldIn, @Nonnull BlockPos pos) {
        return state.func_177226_a((IProperty)TOP, (Comparable)Boolean.valueOf(this.isKelpTop(worldIn, pos)));
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(@Nonnull IBlockState state, @Nonnull IBlockAccess source, @Nonnull BlockPos pos) {
        return (this.isKelpTop(source, pos) ? KELP_TOP_BB : field_185505_j).func_191194_a(state.func_191059_e(source, pos));
    }

    public void func_180650_b(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull Random rand) {
        Fluid upFluid;
        int age = (Integer)state.func_177229_b((IProperty)AGE);
        if (age < 15 && (upFluid = FluidloggedUtils.getFluidFromState((IBlockState)worldIn.func_180495_p(pos.func_177984_a()))) != null && this.isFluidValid(state, worldIn, pos.func_177984_a(), upFluid) && rand.nextDouble() < 0.14) {
            worldIn.func_175656_a(pos.func_177984_a(), state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(age + 1)));
        }
    }

    protected void func_176475_e(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        if (!this.func_180671_f(worldIn, pos, state)) {
            worldIn.func_175655_b(pos, true);
        }
    }

    protected boolean func_185514_i(@Nonnull IBlockState state) {
        if (BlockKelp.func_149680_a((Block)state.func_177230_c(), (Block)Blocks.field_189877_df)) {
            return false;
        }
        return BlockKelp.func_149680_a((Block)state.func_177230_c(), (Block)this) || state.func_185896_q();
    }

    public boolean isKelpTop(@Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        return !BlockKelp.func_149680_a((Block)world.func_180495_p(pos.func_177984_a()).func_177230_c(), (Block)this);
    }

    @Nullable
    public BlockPos getTop(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState kelp, @Nonnull IBlockState here) {
        while (BlockKelp.func_149680_a((Block)here.func_177230_c(), (Block)this)) {
            pos = pos.func_177984_a();
            here = world.func_180495_p(pos);
        }
        Fluid fluid = FluidloggedUtils.getFluidFromState((IBlockState)here);
        return fluid != null && this.isFluidValid(kelp, world, pos, fluid) ? pos : null;
    }

    @Nonnull
    public Block.EnumOffsetType func_176218_Q() {
        return Block.EnumOffsetType.XZ;
    }

    public boolean func_176473_a(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state, boolean isClient) {
        return this.getTop(worldIn, pos, state, state) != null;
    }

    public boolean func_180670_a(@Nonnull World worldIn, @Nonnull Random rand, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        return true;
    }

    public void func_176474_b(@Nonnull World worldIn, @Nonnull Random rand, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        BlockPos posToPlant = this.getTop(worldIn, pos, state, state);
        if (posToPlant != null) {
            worldIn.func_175656_a(posToPlant, state.func_177226_a((IProperty)AGE, worldIn.func_180495_p(posToPlant.func_177977_b()).func_177229_b((IProperty)AGE)));
        }
    }
}

