/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.subaquatic.mod.common.block;

import git.jbredwards.fluidlogged_api.api.block.IFluidloggable;
import git.jbredwards.subaquatic.mod.common.block.state.Rotation45;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockNautilusShell
extends Block
implements IFluidloggable {
    @Nonnull
    public static final PropertyEnum<Rotation45> ROTATION = PropertyEnum.func_177709_a((String)"rotation", Rotation45.class);
    @Nonnull
    public static final AxisAlignedBB AABB = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.09375, 0.9375);

    public BlockNautilusShell(@Nonnull Material materialIn) {
        this(materialIn, materialIn.func_151565_r());
    }

    public BlockNautilusShell(@Nonnull Material materialIn, @Nonnull MapColor mapColorIn) {
        super(materialIn, mapColorIn);
        this.field_149783_u = true;
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer.Builder((Block)this).add(new IProperty[]{ROTATION}).build();
    }

    public int func_176201_c(@Nonnull IBlockState state) {
        return ((Rotation45)((Object)state.func_177229_b(ROTATION))).ordinal();
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(ROTATION, (Comparable)((Object)Rotation45.values()[meta % Rotation45.values().length]));
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(@Nonnull IBlockState state, @Nonnull IBlockAccess source, @Nonnull BlockPos pos) {
        return AABB;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(@Nonnull IBlockState blockState, @Nonnull IBlockAccess worldIn, @Nonnull BlockPos pos) {
        return field_185506_k;
    }

    @Nonnull
    public IBlockState func_185499_a(@Nonnull IBlockState state, @Nonnull Rotation rot) {
        return state.func_177226_a(ROTATION, (Comparable)((Object)((Rotation45)((Object)state.func_177229_b(ROTATION))).rotate(rot)));
    }

    @Nonnull
    public IBlockState func_185471_a(@Nonnull IBlockState state, @Nonnull Mirror mirrorIn) {
        return state.func_177226_a(ROTATION, (Comparable)((Object)((Rotation45)((Object)state.func_177229_b(ROTATION))).mirror(mirrorIn)));
    }

    public boolean func_149686_d(@Nonnull IBlockState state) {
        return false;
    }

    public boolean func_149662_c(@Nonnull IBlockState state) {
        return false;
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @Nonnull
    public BlockFaceShape func_193383_a(@Nonnull IBlockAccess worldIn, @Nonnull IBlockState state, @Nonnull BlockPos pos, @Nonnull EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public void func_189540_a(@Nonnull IBlockState state, @Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull Block blockIn, @Nonnull BlockPos fromPos) {
        if (!this.func_176196_c(worldIn, pos)) {
            worldIn.func_184133_a(null, pos, SoundEvents.field_187629_cO, SoundCategory.BLOCKS, 1.0f, 1.0f);
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
        }
    }

    public boolean func_176196_c(@Nonnull World worldIn, @Nonnull BlockPos pos) {
        return worldIn.func_180495_p(pos.func_177977_b()).func_193401_d((IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP) == BlockFaceShape.SOLID;
    }

    @Nonnull
    public IBlockState func_180642_a(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ, int meta, @Nonnull EntityLivingBase placer) {
        if (placer.func_70093_af()) {
            return this.func_176223_P().func_177226_a(ROTATION, (Comparable)((Object)Rotation45.fromRotation(placer.field_70759_as + 180.0f)));
        }
        return this.func_176223_P().func_177226_a(ROTATION, (Comparable)((Object)Rotation45.fromRotation(placer.field_70759_as)));
    }
}

