/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.subaquatic.mod.common.block;

import git.jbredwards.fluidlogged_api.api.util.FluidloggedUtils;
import git.jbredwards.subaquatic.mod.common.config.SubaquaticConfigHandler;
import git.jbredwards.subaquatic.mod.common.init.SubaquaticBlocks;
import git.jbredwards.subaquatic.mod.common.init.SubaquaticItems;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.event.entity.player.UseHoeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="subaquatic")
public class BlockRootedDirt
extends Block
implements IGrowable {
    public BlockRootedDirt(@Nonnull Material materialIn) {
        this(materialIn, materialIn.func_151565_r());
    }

    public BlockRootedDirt(@Nonnull Material materialIn, @Nonnull MapColor mapColorIn) {
        super(materialIn, mapColorIn);
    }

    public boolean canSustainPlant(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EnumFacing direction, @Nonnull IPlantable plantable) {
        switch (plantable.getPlantType(world, pos.func_177972_a(direction))) {
            case Plains: {
                return true;
            }
            case Beach: {
                return FluidloggedUtils.getFluidOrReal((IBlockAccess)world, (BlockPos)pos.func_177974_f()).func_185904_a() == Material.field_151586_h || FluidloggedUtils.getFluidOrReal((IBlockAccess)world, (BlockPos)pos.func_177976_e()).func_185904_a() == Material.field_151586_h || FluidloggedUtils.getFluidOrReal((IBlockAccess)world, (BlockPos)pos.func_177978_c()).func_185904_a() == Material.field_151586_h || FluidloggedUtils.getFluidOrReal((IBlockAccess)world, (BlockPos)pos.func_177968_d()).func_185904_a() == Material.field_151586_h;
            }
        }
        return false;
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    static void onTillRootedDirt(@Nonnull UseHoeEvent event) {
        BlockPos pos;
        World world;
        IBlockState state;
        if (event.getResult() == Event.Result.DEFAULT && (state = (world = event.getWorld()).func_180495_p(pos = event.getPos())).func_177230_c() instanceof BlockRootedDirt && world.func_175623_d(pos.func_177984_a())) {
            world.func_184133_a(event.getEntityPlayer(), pos, SoundEvents.field_187693_cj, SoundCategory.BLOCKS, 1.0f, 1.0f);
            if (!world.field_72995_K) {
                world.func_180501_a(pos, Blocks.field_150458_ak.func_176223_P(), 11);
                if (SubaquaticConfigHandler.Server.Block.tillRootedDirtGivesRoot && world.func_82736_K().func_82766_b("doTileDrops")) {
                    EntityItem entityItem = new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.75, (double)pos.func_177952_p() + 0.5, new ItemStack((Item)SubaquaticItems.HANGING_ROOTS));
                    entityItem.func_174869_p();
                    world.func_72838_d((Entity)entityItem);
                }
            }
            event.setResult(Event.Result.ALLOW);
        }
    }

    public boolean func_176473_a(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state, boolean isClient) {
        return worldIn.func_175623_d(pos.func_177977_b());
    }

    public boolean func_180670_a(@Nonnull World worldIn, @Nonnull Random rand, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        return true;
    }

    public void func_176474_b(@Nonnull World worldIn, @Nonnull Random rand, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        worldIn.func_175656_a(pos.func_177977_b(), SubaquaticBlocks.HANGING_ROOTS.func_176223_P());
    }
}

