/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.subaquatic.mod.common.block;

import git.jbredwards.fluidlogged_api.api.block.IFluidloggable;
import git.jbredwards.fluidlogged_api.api.util.FluidState;
import git.jbredwards.fluidlogged_api.api.util.FluidloggedUtils;
import git.jbredwards.subaquatic.mod.common.block.BlockCoral;
import git.jbredwards.subaquatic.mod.common.item.util.IBlockCluster;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;

public class BlockSeaPickle
extends BlockBush
implements IGrowable,
IFluidloggable,
IBlockCluster {
    @Nonnull
    public static final PropertyInteger PICKLES = PropertyInteger.func_177719_a((String)"pickles", (int)0, (int)3);
    @Nonnull
    public static final PropertyBool GLOWING = PropertyBool.func_177716_a((String)"glowing");
    @Nonnull
    protected static AxisAlignedBB[] aabb = new AxisAlignedBB[]{new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 0.375, 0.625), new AxisAlignedBB(0.1875, 0.0, 0.1875, 0.75, 0.375, 0.75), new AxisAlignedBB(0.125, 0.0, 0.125, 0.75, 0.375, 0.8125), new AxisAlignedBB(0.125, 0.0, 0.125, 0.8125, 0.4375, 0.875)};

    public BlockSeaPickle(@Nonnull Material materialIn) {
        this(materialIn, materialIn.func_151565_r());
    }

    public BlockSeaPickle(@Nonnull Material materialIn, @Nonnull MapColor mapColorIn) {
        super(materialIn, mapColorIn);
        this.func_149675_a(false);
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)PICKLES, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)GLOWING, (Comparable)Boolean.valueOf(false)));
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{PICKLES, GLOWING});
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)GLOWING, (Comparable)Boolean.valueOf(meta >> 2 > 0)).func_177226_a((IProperty)PICKLES, (Comparable)Integer.valueOf(meta & 3));
    }

    @Override
    public boolean canClusterWith(@Nonnull ItemStack stack, @Nonnull EntityPlayer player, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull EnumFacing side, @Nonnull IBlockState oldState) {
        return (Integer)oldState.func_177229_b((IProperty)PICKLES) < 3;
    }

    @Override
    public boolean clusterWith(@Nonnull ItemBlock itemBlock, @Nonnull ItemStack stack, @Nonnull EntityPlayer player, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull EnumFacing side, float hitX, float hitY, float hitZ, @Nonnull IBlockState oldState) {
        return itemBlock.placeBlockAt(stack, player, world, pos, side, hitX, hitY, hitZ, oldState.func_177226_a((IProperty)PICKLES, (Comparable)Integer.valueOf((Integer)oldState.func_177229_b((IProperty)PICKLES) + 1)));
    }

    @Override
    public boolean createInitialCluster(@Nonnull ItemBlock itemBlock, @Nonnull ItemStack stack, @Nonnull EntityPlayer player, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull EnumFacing side, float hitX, float hitY, float hitZ, @Nonnull IBlockState oldState) {
        return itemBlock.placeBlockAt(stack, player, world, pos, side, hitX, hitY, hitZ, this.func_176223_P());
    }

    public int func_176201_c(@Nonnull IBlockState state) {
        return ((Boolean)state.func_177229_b((IProperty)GLOWING) != false ? 4 : 0) | (Integer)state.func_177229_b((IProperty)PICKLES);
    }

    public int func_149750_m(@Nonnull IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)GLOWING) != false ? 6 + 3 * (Integer)state.func_177229_b((IProperty)PICKLES) : 0;
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(@Nonnull IBlockState state, @Nonnull IBlockAccess source, @Nonnull BlockPos pos) {
        return aabb[(Integer)state.func_177229_b((IProperty)PICKLES)];
    }

    @Nonnull
    public AxisAlignedBB func_180646_a(@Nonnull IBlockState blockState, @Nonnull IBlockAccess worldIn, @Nonnull BlockPos pos) {
        return blockState.func_185900_c(worldIn, pos);
    }

    public boolean func_185514_i(@Nonnull IBlockState state) {
        return !BlockSeaPickle.func_149680_a((Block)state.func_177230_c(), (Block)Blocks.field_189877_df) && state.func_185896_q();
    }

    public boolean func_176196_c(@Nonnull World worldIn, @Nonnull BlockPos pos) {
        IBlockState state = worldIn.func_180495_p(pos);
        if (!BlockSeaPickle.func_149680_a((Block)state.func_177230_c(), (Block)this) && !state.func_177230_c().func_176200_f((IBlockAccess)worldIn, pos)) {
            return false;
        }
        if (!this.func_185514_i(worldIn.func_180495_p(pos.func_177977_b()))) {
            return false;
        }
        FluidState fluidState = FluidloggedUtils.getFluidState((IBlockAccess)worldIn, (BlockPos)pos);
        return fluidState.isEmpty() || this.isFluidValid(this.func_176223_P(), worldIn, pos, fluidState.getFluid());
    }

    @Nonnull
    public EnumActionResult onFluidFill(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState here, @Nonnull FluidState newFluid, int blockFlags) {
        if (!this.isFluidValid(here, world, pos, newFluid.getFluid())) {
            this.func_176226_b(world, pos, here, 0);
            world.func_180501_a(pos, newFluid.getState(), blockFlags);
            return EnumActionResult.SUCCESS;
        }
        if (!((Boolean)here.func_177229_b((IProperty)GLOWING)).booleanValue()) {
            world.func_180501_a(pos, here.func_177226_a((IProperty)GLOWING, (Comparable)Boolean.valueOf(true)), blockFlags);
        }
        return EnumActionResult.PASS;
    }

    @Nonnull
    public EnumActionResult onFluidDrain(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState here, int blockFlags) {
        if (((Boolean)here.func_177229_b((IProperty)GLOWING)).booleanValue()) {
            world.func_180501_a(pos, here.func_177226_a((IProperty)GLOWING, (Comparable)Boolean.valueOf(false)), blockFlags);
        }
        return EnumActionResult.PASS;
    }

    public boolean isFluidValid(@Nonnull IBlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull Fluid fluid) {
        return fluid.canBePlacedInWorld() && fluid.getBlock().func_176223_P().func_185904_a() == Material.field_151586_h;
    }

    public boolean canRenderInLayer(@Nonnull IBlockState state, @Nonnull BlockRenderLayer layer) {
        return layer == BlockRenderLayer.SOLID || layer == BlockRenderLayer.CUTOUT && (Boolean)state.func_177229_b((IProperty)GLOWING) != false;
    }

    public int quantityDropped(@Nonnull IBlockState state, int fortune, @Nonnull Random random) {
        return (Integer)state.func_177229_b((IProperty)PICKLES) + 1;
    }

    public boolean func_180670_a(@Nonnull World worldIn, @Nonnull Random rand, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        return true;
    }

    public boolean func_176473_a(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state, boolean isClient) {
        if (((Boolean)state.func_177229_b((IProperty)GLOWING)).booleanValue()) {
            IBlockState down = worldIn.func_180495_p(pos.func_177977_b());
            return down.func_177230_c() instanceof BlockCoral && (Boolean)down.func_177229_b((IProperty)BlockCoral.ALIVE) != false;
        }
        return false;
    }

    public void func_176474_b(@Nonnull World worldIn, @Nonnull Random rand, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        if (worldIn.func_175697_a(pos, 1)) {
            for (int x = -1; x <= 1; ++x) {
                for (int y = -1; y <= 1; ++y) {
                    for (int z = -1; z <= 1; ++z) {
                        IBlockState soil;
                        BlockPos offset = pos.func_177982_a(x, y, z);
                        if (offset.equals((Object)pos) || rand.nextInt(6) != 0 || worldIn.func_180495_p(offset).func_185904_a() != Material.field_151586_h || !((soil = worldIn.func_180495_p(offset.func_177977_b())).func_177230_c() instanceof BlockCoral) || !((Boolean)soil.func_177229_b((IProperty)BlockCoral.ALIVE)).booleanValue()) continue;
                        worldIn.func_175656_a(offset, this.func_176223_P().func_177226_a((IProperty)GLOWING, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)PICKLES, (Comparable)Integer.valueOf(rand.nextInt(4))));
                    }
                }
            }
        }
        worldIn.func_180501_a(pos, state.func_177226_a((IProperty)PICKLES, (Comparable)Integer.valueOf(3)), 2);
    }
}

