/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.subaquatic.mod.common.block;

import git.jbredwards.fluidlogged_api.api.block.BlockWaterloggedPlant;
import git.jbredwards.fluidlogged_api.api.util.FluidloggedUtils;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.fluids.Fluid;

public class BlockSeagrass
extends BlockWaterloggedPlant
implements IShearable,
IGrowable {
    @Nonnull
    protected static final AxisAlignedBB SINGLE_BB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.75, 1.0);
    @Nonnull
    protected static final AxisAlignedBB TOP_BB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.875, 1.0);
    @Nonnull
    public static final PropertyEnum<Type> TYPE = PropertyEnum.func_177709_a((String)"type", Type.class);
    @Nonnull
    public final ThreadLocal<Boolean> isPlacing = ThreadLocal.withInitial(() -> false);

    public BlockSeagrass(@Nonnull Material materialIn) {
        super(materialIn);
    }

    public BlockSeagrass(@Nonnull Material materialIn, @Nonnull MapColor mapColorIn) {
        super(materialIn, mapColorIn);
        this.func_149675_a(false);
        this.func_180632_j(this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)Type.SINGLE)));
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE});
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)Type.values()[meta % Type.values().length]));
    }

    public int func_176201_c(@Nonnull IBlockState state) {
        return ((Type)((Object)state.func_177229_b(TYPE))).ordinal();
    }

    @Nonnull
    public IBlockState func_180642_a(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ, int meta, @Nonnull EntityLivingBase placer) {
        return BlockSeagrass.func_149680_a((Block)worldIn.func_180495_p(pos.func_177977_b()).func_177230_c(), (Block)this) ? this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)Type.TOP)) : this.func_176223_P();
    }

    public void func_176213_c(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        IBlockState down;
        if (state.func_177229_b(TYPE) == Type.TOP && BlockSeagrass.func_149680_a((Block)(down = worldIn.func_180495_p(pos.func_177977_b())).func_177230_c(), (Block)this) && down.func_177229_b(TYPE) != Type.BOTTOM) {
            worldIn.func_180501_a(pos.func_177977_b(), down.func_177226_a(TYPE, (Comparable)((Object)Type.BOTTOM)), 2);
        }
    }

    protected void func_176475_e(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        if (!this.func_180671_f(worldIn, pos, state)) {
            worldIn.func_175655_b(pos, false);
            return;
        }
        Type type = (Type)((Object)state.func_177229_b(TYPE));
        if (type == Type.BOTTOM) {
            IBlockState up = worldIn.func_180495_p(pos.func_177984_a());
            if (!BlockSeagrass.func_149680_a((Block)up.func_177230_c(), (Block)this)) {
                worldIn.func_175655_b(pos, false);
            } else if (up.func_177229_b(TYPE) != Type.TOP) {
                worldIn.func_180501_a(pos, up.func_177226_a(TYPE, (Comparable)((Object)Type.TOP)), 2);
            }
        } else if (type == Type.TOP) {
            IBlockState down = worldIn.func_180495_p(pos.func_177977_b());
            if (!BlockSeagrass.func_149680_a((Block)down.func_177230_c(), (Block)this)) {
                worldIn.func_175655_b(pos, false);
            } else if (down.func_177229_b(TYPE) != Type.BOTTOM) {
                worldIn.func_180501_a(pos, down.func_177226_a(TYPE, (Comparable)((Object)Type.BOTTOM)), 2);
            }
        }
    }

    protected boolean func_185514_i(@Nonnull IBlockState state) {
        if (BlockSeagrass.func_149680_a((Block)state.func_177230_c(), (Block)Blocks.field_189877_df)) {
            return false;
        }
        if (BlockSeagrass.func_149680_a((Block)state.func_177230_c(), (Block)this)) {
            return state.func_177229_b(TYPE) != Type.TOP;
        }
        return state.func_185896_q();
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(@Nonnull IBlockState state, @Nonnull IBlockAccess source, @Nonnull BlockPos pos) {
        switch ((Type)((Object)state.func_177229_b(TYPE))) {
            case SINGLE: {
                return SINGLE_BB;
            }
            case TOP: {
                return TOP_BB;
            }
        }
        return field_185505_j;
    }

    public boolean isShearable(@Nonnull ItemStack shears, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        return true;
    }

    @Nonnull
    public List<ItemStack> onSheared(@Nonnull ItemStack shears, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, int fortune) {
        return Collections.singletonList(new ItemStack((Block)this));
    }

    public boolean func_176200_f(@Nonnull IBlockAccess worldIn, @Nonnull BlockPos pos) {
        return this.isPlacing.get() == false;
    }

    public int func_149745_a(@Nonnull Random random) {
        return 0;
    }

    public boolean func_180670_a(@Nonnull World worldIn, @Nonnull Random rand, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        return true;
    }

    public boolean func_176473_a(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state, boolean isClient) {
        if (state.func_177229_b(TYPE) != Type.SINGLE) {
            return false;
        }
        Fluid upFluid = FluidloggedUtils.getFluidFromState((IBlockState)worldIn.func_180495_p(pos.func_177984_a()));
        return upFluid != null && this.isFluidValid(state, worldIn, pos.func_177984_a(), upFluid);
    }

    public void func_176474_b(@Nonnull World worldIn, @Nonnull Random rand, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        worldIn.func_175656_a(pos.func_177984_a(), state.func_177226_a(TYPE, (Comparable)((Object)Type.TOP)));
    }

    public static enum Type implements IStringSerializable
    {
        SINGLE("single"),
        TOP("top"),
        BOTTOM("bottom");

        @Nonnull
        final String name;

        private Type(String nameIn) {
            this.name = nameIn;
        }

        @Nonnull
        public String func_176610_l() {
            return this.name;
        }
    }
}

