/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.subaquatic.mod.common.capability;

import git.jbredwards.fluidlogged_api.api.capability.CapabilityProvider;
import git.jbredwards.subaquatic.mod.common.capability.util.BoatType;
import git.jbredwards.subaquatic.mod.common.config.SubaquaticBoatTypesConfig;
import git.jbredwards.subaquatic.mod.common.entity.item.AbstractBoatContainer;
import git.jbredwards.subaquatic.mod.common.item.ItemBoatContainer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public interface IBoatType {
    @CapabilityInject(value=IBoatType.class)
    @Nonnull
    public static final Capability<IBoatType> CAPABILITY = null;
    @Nonnull
    public static final ResourceLocation CAPABILITY_ID = new ResourceLocation("subaquatic", "boat_type");

    @Nonnull
    public BoatType getType();

    public void setType(@Nonnull BoatType var1);

    @Nullable
    public static IBoatType get(@Nullable ICapabilityProvider p) {
        return p != null && p.hasCapability(CAPABILITY, null) ? (IBoatType)p.getCapability(CAPABILITY, null) : null;
    }

    @SubscribeEvent
    public static void attachEntity(@Nonnull AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof AbstractBoatContainer) {
            event.addCapability(CAPABILITY_ID, (ICapabilityProvider)new CapabilityProvider(CAPABILITY));
        }
    }

    @SubscribeEvent
    public static void attachItem(@Nonnull AttachCapabilitiesEvent<ItemStack> event) {
        if (((ItemStack)event.getObject()).func_77973_b() instanceof ItemBoatContainer) {
            event.addCapability(CAPABILITY_ID, (ICapabilityProvider)new CapabilityProvider(CAPABILITY));
        }
    }

    public static enum Storage implements Capability.IStorage<IBoatType>
    {
        INSTANCE;


        @Nonnull
        public NBTBase writeNBT(@Nonnull Capability<IBoatType> capability, @Nonnull IBoatType instance, @Nullable EnumFacing side) {
            return instance.getType().serializeNBT();
        }

        public void readNBT(@Nonnull Capability<IBoatType> capability, @Nonnull IBoatType instance, @Nullable EnumFacing side, @Nullable NBTBase nbt) {
            BoatType type;
            if (nbt instanceof NBTTagCompound && (type = SubaquaticBoatTypesConfig.getTypeFrom((NBTTagCompound)nbt)) != null) {
                instance.setType(type);
            }
        }
    }

    public static class Impl
    implements IBoatType {
        @Nonnull
        protected BoatType type = BoatType.DEFAULT;

        @Override
        @Nonnull
        public BoatType getType() {
            return this.type;
        }

        @Override
        public void setType(@Nonnull BoatType typeIn) {
            this.type = typeIn;
        }
    }
}

