/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.subaquatic.mod.common.capability;

import com.google.common.collect.ImmutableMap;
import git.jbredwards.fluidlogged_api.api.capability.CapabilityProvider;
import git.jbredwards.subaquatic.mod.asm.plugin.vanilla.entity.PluginEntityBoat;
import git.jbredwards.subaquatic.mod.common.block.BlockBubbleColumn;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

public interface IBubbleColumn
extends INBTSerializable<NBTBase> {
    @CapabilityInject(value=IBubbleColumn.class)
    @Nonnull
    public static final Capability<IBubbleColumn> CAPABILITY = null;
    @Nonnull
    public static final ResourceLocation CAPABILITY_ID = new ResourceLocation("subaquatic", "bubble_column");
    @Nonnull
    public static final Map<Class<?>, Supplier<IBubbleColumn>> BUBBLE_COLUMN_FACTORY = new HashMap((Map<Class<?>, Supplier<IBubbleColumn>>)ImmutableMap.of(Entity.class, Impl::new, EntityBoat.class, Boat::new, EntityPlayer.class, Player::new, FakePlayer.class, () -> null));

    public void onCollide(@Nonnull Entity var1, @Nonnull BlockBubbleColumn var2);

    public void onCollideTop(@Nonnull Entity var1, @Nonnull BlockBubbleColumn var2);

    @Nullable
    public static IBubbleColumn get(@Nullable ICapabilityProvider provider) {
        return provider.hasCapability(CAPABILITY, null) ? (IBubbleColumn)provider.getCapability(CAPABILITY, null) : null;
    }

    @SubscribeEvent
    public static void attach(@Nonnull AttachCapabilitiesEvent<Entity> event) {
        IBubbleColumn handler = IBubbleColumn.getHandlerForClass(((Entity)event.getObject()).getClass()).get();
        if (handler != null) {
            event.addCapability(CAPABILITY_ID, (ICapabilityProvider)new CapabilityProvider(CAPABILITY, (Object)handler));
        }
    }

    public static Supplier<IBubbleColumn> getHandlerForClass(@Nonnull Class<?> clazzIn) {
        if (clazzIn == Object.class) {
            throw new IllegalArgumentException("Class has no bubble column handler, this should never happen!");
        }
        return BUBBLE_COLUMN_FACTORY.computeIfAbsent(clazzIn, clazz -> IBubbleColumn.getHandlerForClass(clazz.getSuperclass()));
    }

    public static enum Storage implements Capability.IStorage<IBubbleColumn>
    {
        INSTANCE;


        @Nonnull
        public NBTBase writeNBT(@Nonnull Capability<IBubbleColumn> capability, @Nonnull IBubbleColumn instance, @Nullable EnumFacing side) {
            return instance.serializeNBT();
        }

        public void readNBT(@Nonnull Capability<IBubbleColumn> capability, @Nonnull IBubbleColumn instance, @Nullable EnumFacing side, @Nonnull NBTBase nbt) {
            instance.deserializeNBT(nbt);
        }
    }

    @Mod.EventBusSubscriber(modid="subaquatic", value={Side.CLIENT})
    public static class Player
    extends Impl {
        protected boolean wasInBubbleColumn;

        public void updateWasInBubbleColumn(@Nonnull EntityPlayer player) {
            BlockBubbleColumn column = this.getFirstBubbleColumnWithin(player.field_70170_p, player.func_174813_aQ());
            if (column != null) {
                if (!(this.wasInBubbleColumn || player.field_70148_d || player.func_175149_v())) {
                    player.field_70170_p.func_184134_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, column.getInsideSound(), player.func_184176_by(), 1.0f, 1.0f, false);
                }
                this.wasInBubbleColumn = true;
            } else {
                this.wasInBubbleColumn = false;
            }
        }

        @Nullable
        protected BlockBubbleColumn getFirstBubbleColumnWithin(@Nonnull World world, @Nonnull AxisAlignedBB bb) {
            int maxZ;
            int maxY;
            int maxX;
            int minZ;
            int minY;
            int minX = MathHelper.func_76128_c((double)bb.field_72340_a);
            if (world.func_175663_a(minX, minY = MathHelper.func_76128_c((double)bb.field_72338_b), minZ = MathHelper.func_76128_c((double)bb.field_72339_c), maxX = MathHelper.func_76143_f((double)bb.field_72336_d) - 1, maxY = MathHelper.func_76143_f((double)bb.field_72337_e) - 1, maxZ = MathHelper.func_76143_f((double)bb.field_72334_f) - 1, true)) {
                for (BlockPos pos : BlockPos.func_191531_b((int)minX, (int)minY, (int)minZ, (int)maxX, (int)maxY, (int)maxZ)) {
                    Block block = world.func_180495_p(pos).func_177230_c();
                    if (!(block instanceof BlockBubbleColumn)) continue;
                    return (BlockBubbleColumn)block;
                }
            }
            return null;
        }

        @SubscribeEvent
        static void onPlayerUpdate(@Nonnull TickEvent.PlayerTickEvent event) {
            IBubbleColumn cap;
            if (event.phase == TickEvent.Phase.START && (cap = IBubbleColumn.get((ICapabilityProvider)event.player)) instanceof Player) {
                ((Player)cap).updateWasInBubbleColumn(event.player);
            }
        }
    }

    @Mod.EventBusSubscriber(modid="subaquatic")
    public static class Boat
    extends Impl {
        protected boolean isRocking;
        protected boolean isDown;
        protected float rockingIntensity;
        protected float rockingAnglePrev;
        protected float rockingAngle;

        public int getRockingTicks(@Nonnull Entity entity) {
            return (Integer)entity.func_184212_Q().func_187225_a(PluginEntityBoat.Hooks.ROCKING_TICKS);
        }

        public void setRockingTicks(@Nonnull Entity entity, int rockingTicks) {
            entity.func_184212_Q().func_187227_b(PluginEntityBoat.Hooks.ROCKING_TICKS, (Object)rockingTicks);
        }

        public float getRenderRockingAngle(float partialTicks) {
            return this.rockingAnglePrev + (this.rockingAngle - this.rockingAnglePrev) * partialTicks;
        }

        @Override
        public void onCollideTop(@Nonnull Entity entity, @Nonnull BlockBubbleColumn column) {
            if (!entity.field_70170_p.field_72995_K) {
                this.isRocking = true;
                this.isDown = column.isDown;
                if (this.getRockingTicks(entity) == 0) {
                    this.setRockingTicks(entity, 60);
                }
            }
            entity.field_70170_p.func_175688_a(EnumParticleTypes.WATER_SPLASH, entity.field_70165_t + Math.random(), entity.field_70163_u + 0.7, entity.field_70161_v + Math.random(), 0.0, 0.0, 0.0, new int[0]);
            if (entity.field_70170_p.field_73012_v.nextInt(20) == 0) {
                entity.field_70170_p.func_184134_a(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, entity.func_184181_aa(), entity.func_184176_by(), 1.0f, 0.8f + 0.4f * entity.field_70170_p.field_73012_v.nextFloat(), false);
            }
        }

        public void updateRocking(@Nonnull EntityBoat boat) {
            if (boat.field_70170_p.field_72995_K) {
                int rockingTicks = this.getRockingTicks((Entity)boat);
                this.rockingIntensity = rockingTicks > 0 ? (float)((double)this.rockingIntensity + 0.005) : (float)((double)this.rockingIntensity - 0.1);
                this.rockingIntensity = MathHelper.func_76131_a((float)this.rockingIntensity, (float)0.0f, (float)1.0f);
                this.rockingAnglePrev = this.rockingAngle;
                this.rockingAngle = 10.0f * (float)Math.sin(0.5 * (double)boat.field_70170_p.func_82737_E()) * this.rockingIntensity;
            } else if (this.isRocking) {
                int rockingTicks = this.getRockingTicks((Entity)boat);
                if (rockingTicks > 0) {
                    this.setRockingTicks((Entity)boat, --rockingTicks);
                    if (rockingTicks == 0) {
                        this.setRockingTicks((Entity)boat, 0);
                        if (this.isDown) {
                            boat.field_70181_x -= 0.7;
                            boat.func_184226_ay();
                        }
                    }
                }
                this.isRocking = false;
            } else {
                this.setRockingTicks((Entity)boat, 0);
            }
        }

        @SubscribeEvent
        static void registerRockingTicks(@Nonnull EntityEvent.EntityConstructing event) {
            if (event.getEntity() instanceof EntityBoat) {
                event.getEntity().func_184212_Q().func_187214_a(PluginEntityBoat.Hooks.ROCKING_TICKS, (Object)0);
            }
        }
    }

    public static class Impl
    implements IBubbleColumn {
        @Override
        public void onCollide(@Nonnull Entity entity, @Nonnull BlockBubbleColumn column) {
            if (entity.func_96092_aw()) {
                entity.field_70181_x = column.isDown ? Math.max(-0.3, entity.field_70181_x - 0.03) : Math.min(0.7, entity.field_70181_x + 0.06);
            }
        }

        @Override
        public void onCollideTop(@Nonnull Entity entity, @Nonnull BlockBubbleColumn column) {
            if (entity.func_96092_aw()) {
                entity.field_70181_x = column.isDown ? Math.max(-0.9, entity.field_70181_x - 0.03) : Math.min(1.8, entity.field_70181_x + 0.1);
            }
        }

        @Nonnull
        public NBTBase serializeNBT() {
            return new NBTTagByte(0);
        }

        public void deserializeNBT(@Nonnull NBTBase nbt) {
        }
    }
}

