/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.subaquatic.mod.common.capability;

import git.jbredwards.fluidlogged_api.api.capability.CapabilityProvider;
import git.jbredwards.subaquatic.mod.common.config.SubaquaticConfigHandler;
import git.jbredwards.subaquatic.mod.common.entity.util.fish_bucket.AbstractEntityBucketHandler;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.UniversalBucket;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public interface IEntityBucket {
    @CapabilityInject(value=IEntityBucket.class)
    @Nonnull
    public static final Capability<IEntityBucket> CAPABILITY = null;
    @Nonnull
    public static final ResourceLocation CAPABILITY_ID = new ResourceLocation("subaquatic", "fish_bucket");
    @Nonnull
    public static final List<Item> validBuckets = new LinkedList<Item>();

    @Nullable
    public AbstractEntityBucketHandler getHandler();

    public void setHandler(@Nullable AbstractEntityBucketHandler var1);

    public static boolean canItemHoldCapability(@Nonnull Item item) {
        return item == Items.field_151131_as || item instanceof UniversalBucket;
    }

    public static boolean canStackHoldEntity(@Nonnull ItemStack stack) {
        if (!IEntityBucket.canItemHoldCapability(stack.func_77973_b())) {
            return false;
        }
        IFluidHandlerItem handler = FluidUtil.getFluidHandler((ItemStack)stack);
        if (handler == null || handler.getTankProperties().length != 1) {
            return false;
        }
        FluidStack fluid = handler.drain(1000, false);
        return fluid != null && fluid.amount >= 1000 && IEntityBucket.isFluidValid(fluid.getFluid());
    }

    public static boolean isFluidValid(@Nullable Fluid fluid) {
        return fluid != null && fluid.canBePlacedInWorld() && fluid.getBlock().func_176223_P().func_185904_a() == Material.field_151586_h && !SubaquaticConfigHandler.FISH_BUCKET_FLUID_BLACKLIST.contains(fluid);
    }

    @Nullable
    public static IEntityBucket get(@Nullable ICapabilityProvider provider) {
        return provider != null && provider.hasCapability(CAPABILITY, null) ? (IEntityBucket)provider.getCapability(CAPABILITY, null) : null;
    }

    @SubscribeEvent
    public static void attachCapability(@Nonnull AttachCapabilitiesEvent<ItemStack> event) {
        if (IEntityBucket.canItemHoldCapability(((ItemStack)event.getObject()).func_77973_b())) {
            event.addCapability(CAPABILITY_ID, (ICapabilityProvider)new CapabilityProvider(CAPABILITY));
        }
    }

    public static List<Item> getValidBuckets() {
        if (validBuckets.isEmpty()) {
            ForgeRegistries.ITEMS.forEach(item -> {
                if (IEntityBucket.canItemHoldCapability(item)) {
                    validBuckets.add((Item)item);
                }
            });
        }
        return validBuckets;
    }

    public static enum Storage implements Capability.IStorage<IEntityBucket>
    {
        INSTANCE;


        @Nonnull
        public NBTBase writeNBT(@Nonnull Capability<IEntityBucket> capability, @Nonnull IEntityBucket instance, @Nullable EnumFacing side) {
            return instance.getHandler() != null ? instance.getHandler().serializeNBT() : new NBTTagByte(0);
        }

        public void readNBT(@Nonnull Capability<IEntityBucket> capability, @Nonnull IEntityBucket instance, @Nullable EnumFacing side, @Nullable NBTBase nbt) {
            if (nbt instanceof NBTTagCompound) {
                instance.setHandler(AbstractEntityBucketHandler.createFromNBT((NBTTagCompound)nbt));
            }
        }
    }

    public static class Impl
    implements IEntityBucket {
        @Nullable
        protected AbstractEntityBucketHandler handler;

        @Override
        @Nullable
        public AbstractEntityBucketHandler getHandler() {
            return this.handler;
        }

        @Override
        public void setHandler(@Nullable AbstractEntityBucketHandler handlerIn) {
            this.handler = handlerIn;
        }
    }
}

