/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.subaquatic.mod.common.compat.inspirations;

import git.jbredwards.subaquatic.mod.common.compat.inspirations.InspirationsModelCauldron;
import git.jbredwards.subaquatic.mod.common.config.SubaquaticWaterColorConfig;
import java.awt.Color;
import javax.annotation.Nonnull;
import knightminer.inspirations.common.Config;
import knightminer.inspirations.library.Util;
import knightminer.inspirations.recipes.InspirationsRecipes;
import knightminer.inspirations.recipes.RecipesClientProxy;
import knightminer.inspirations.recipes.tileentity.TileCauldron;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeColorHelper;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

public final class InspirationsHandler {
    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.LOW)
    static void overrideCauldronWrapper(@Nonnull ModelRegistryEvent event) {
        if (InspirationsRecipes.cauldron != null) {
            ModelLoaderRegistry.registerLoader((ICustomModelLoader)InspirationsModelCauldron.Loader.INSTANCE);
            ModelLoader.setCustomStateMapper((Block)InspirationsRecipes.cauldron, (IStateMapper)new RecipesClientProxy.CauldronStateMapper(Util.getResource((String)"cauldron_multilayer")));
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.LOW)
    static void ensureOldPotionFluidTexture(@Nonnull TextureStitchEvent.Pre event) {
        if (event.getMap() == Minecraft.func_71410_x().func_147117_R()) {
            event.getMap().func_174942_a(Util.getResource((String)"blocks/fluid_potion"));
        }
    }

    public static boolean doesCauldronHaveMaterial(@Nonnull Material material, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        if (!Config.enableExtendedCauldron) {
            return material == Material.field_151586_h;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileCauldron) {
            TileCauldron cauldron = (TileCauldron)tile;
            if (cauldron.isWater() || cauldron.getState().getColor() != -1 || cauldron.getState().getPotion() != null) {
                return material == Material.field_151586_h;
            }
            Fluid fluid = cauldron.getState().getFluid();
            return fluid != null && fluid.canBePlacedInWorld() && material == fluid.getBlock().func_176223_P().func_185904_a();
        }
        return false;
    }

    public static int getCauldronColor(@Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        TileCauldron cauldron;
        TileEntity tile;
        if (Config.enableExtendedCauldron && (tile = world.func_175625_s(pos)) instanceof TileCauldron && !(cauldron = (TileCauldron)tile).isWater()) {
            return cauldron.getColor();
        }
        return BiomeColorHelper.func_180288_c((IBlockAccess)world, (BlockPos)pos);
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public static Color getParticleColorAt(@Nonnull World world, double x, double y, double z) {
        TileCauldron cauldron;
        Pair<BlockPos, TileEntity> here;
        if (Config.enableExtendedCauldron && (here = SubaquaticWaterColorConfig.findClosestAround(World::func_175625_s, tile -> tile instanceof TileCauldron, world, x, y, z)) != null && !(cauldron = (TileCauldron)here.getRight()).isWater()) {
            return new Color(cauldron.getColor());
        }
        return SubaquaticWaterColorConfig.getParticleColorAt(world, x, y, z);
    }
}

