/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.subaquatic.mod.common.compat.inspirations;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import knightminer.inspirations.library.util.TextureBlockUtil;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BakedQuadRetextured;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.BakedModelWrapper;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public final class InspirationsModelCauldron
implements IModel {
    @Nonnull
    public static final InspirationsModelCauldron MODEL = new InspirationsModelCauldron((ResourceLocation)ModelBakery.field_177604_a, TextureMap.field_174945_f);
    @Nonnull
    final ResourceLocation modelLocation;
    @Nonnull
    final ResourceLocation modelTexture;

    private InspirationsModelCauldron(@Nonnull ResourceLocation modelLocationIn, @Nonnull ResourceLocation modelTextureIn) {
        this.modelLocation = modelLocationIn;
        this.modelTexture = modelTextureIn;
    }

    @Nonnull
    public Collection<ResourceLocation> getTextures() {
        return ImmutableList.of((Object)this.modelTexture);
    }

    @Nonnull
    public IBakedModel bake(@Nonnull IModelState state, @Nonnull VertexFormat format, @Nonnull Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        return new BakedModel(ModelLoaderRegistry.getModelOrLogError((ResourceLocation)this.modelLocation, (String)("Couldn't load InspirationsModelCauldron dependency: " + this.modelLocation)).bake(state, format, bakedTextureGetter), bakedTextureGetter.apply(this.modelTexture), bakedTextureGetter);
    }

    @Nonnull
    public IModel process(@Nonnull ImmutableMap<String, String> customData) {
        JsonElement overlayTexture;
        JsonElement overlayModel;
        if (customData.containsKey((Object)"model") && (overlayModel = new JsonParser().parse((String)customData.get((Object)"model"))).isJsonPrimitive() && overlayModel.getAsJsonPrimitive().isString() && (overlayTexture = new JsonParser().parse((String)customData.get((Object)"texture"))).isJsonPrimitive() && overlayTexture.getAsJsonPrimitive().isString()) {
            return new InspirationsModelCauldron(new ResourceLocation(overlayModel.getAsString()), new ResourceLocation(overlayTexture.getAsString()));
        }
        return MODEL;
    }

    public static enum Loader implements ICustomModelLoader
    {
        INSTANCE;


        public void func_110549_a(@Nonnull IResourceManager resourceManager) {
        }

        public boolean accepts(@Nonnull ResourceLocation modelLocation) {
            return modelLocation.func_110624_b().equals("inspirations") && modelLocation.func_110623_a().endsWith("builtin/cauldron_wrapper");
        }

        @Nonnull
        public IModel loadModel(@Nonnull ResourceLocation modelLocation) {
            return MODEL;
        }
    }

    private static final class BakedModel
    extends BakedModelWrapper<IBakedModel> {
        @Nonnull
        final TextureAtlasSprite modelTexture;
        @Nonnull
        final Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter;

        public BakedModel(@Nonnull IBakedModel originalModelIn, @Nonnull TextureAtlasSprite modelTextureIn, @Nonnull Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetterIn) {
            super(originalModelIn);
            this.modelTexture = modelTextureIn;
            this.bakedTextureGetter = bakedTextureGetterIn;
        }

        @Nonnull
        public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
            if (state instanceof IExtendedBlockState) {
                String textureStr = (String)((IExtendedBlockState)state).getValue((IUnlistedProperty)TextureBlockUtil.TEXTURE_PROP);
                TextureAtlasSprite texture = textureStr == null ? this.modelTexture : this.bakedTextureGetter.apply(new ResourceLocation(textureStr));
                ImmutableList.Builder quads = ImmutableList.builder();
                super.func_188616_a(state, side, rand).forEach(quad -> quads.add((Object)new BakedQuadRetextured(quad, texture)));
                return quads.build();
            }
            return super.func_188616_a(state, side, rand);
        }
    }
}

