/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.subaquatic.mod.common.config;

import com.google.common.io.Files;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import git.jbredwards.subaquatic.mod.common.capability.util.BoatType;
import git.jbredwards.subaquatic.mod.common.config.util.ConfigUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.FMLCommonHandler;

public final class SubaquaticBoatTypesConfig {
    @Nonnull
    public static final List<BoatType> BOAT_TYPES = new LinkedList<BoatType>();
    @Nonnull
    public static final Int2ObjectMap<BoatType> BOAT_TYPES_LOOKUP = new Int2ObjectOpenHashMap();
    @Nonnull
    public static final String defaultConfigValues = "{\n    //vanilla\n    \"minecraft:boat\":{\n        \"texture\":\"entity/boat/boat_oak\"\n    },\n    \"minecraft:spruce_boat\":{\n        \"texture\":\"entity/boat/boat_spruce\"\n    },\n    \"minecraft:birch_boat\":{\n        \"texture\":\"entity/boat/boat_birch\"\n    },\n    \"minecraft:jungle_boat\":{\n        \"texture\":\"entity/boat/boat_jungle\"\n    },\n    \"minecraft:acacia_boat\":{\n        \"texture\":\"entity/boat/boat_acacia\"\n    },\n    \"minecraft:dark_oak_boat\":{\n        \"texture\":\"entity/boat/boat_darkoak\"\n    }\n}";

    public static void buildBoatTypes() throws IOException {
        block2: {
            File file = new File("config/subaquatic", "boat_types.jsonc");
            try {
                SubaquaticBoatTypesConfig.parseBoatTypes(new FileReader(file));
            }
            catch (FileNotFoundException e) {
                SubaquaticBoatTypesConfig.parseBoatTypes(new StringReader(defaultConfigValues));
                Files.createParentDirs((File)file);
                if (!file.createNewFile()) break block2;
                FileWriter writer = new FileWriter(file);
                writer.write(defaultConfigValues);
                writer.close();
            }
        }
        ConfigUtils.parseFromMods("subaquatic/boat_types.jsonc", SubaquaticBoatTypesConfig::parseBoatTypes);
    }

    static void parseBoatTypes(@Nonnull Reader reader) {
        JsonObject configFile = new JsonParser().parse(reader).getAsJsonObject();
        configFile.entrySet().forEach(element -> {
            Item item;
            if (((JsonElement)element.getValue()).isJsonObject() && (item = Item.func_111206_d((String)((String)element.getKey()))) != null) {
                int meta;
                JsonObject configElement = ((JsonElement)element.getValue()).getAsJsonObject();
                int n = meta = configElement.has("meta") ? Math.max(configElement.get("meta").getAsInt(), 0) : 0;
                if (SubaquaticBoatTypesConfig.getTypeFrom(item, meta) == null) {
                    BoatType type = new BoatType(item, meta);
                    if (FMLCommonHandler.instance().getSide().isClient() && configElement.has("texture")) {
                        ResourceLocation texture = new ResourceLocation(configElement.get("texture").getAsString());
                        type.entityTexture = new ResourceLocation(texture.func_110624_b(), String.format("textures/%s.png", texture.func_110623_a()));
                    }
                    BOAT_TYPES.add(type);
                    BOAT_TYPES_LOOKUP.put(SubaquaticBoatTypesConfig.getIndex(item, meta), (Object)type);
                }
            }
        });
    }

    @Nullable
    public static BoatType getTypeFrom(@Nonnull Item item, int meta) {
        return (BoatType)BOAT_TYPES_LOOKUP.get(SubaquaticBoatTypesConfig.getIndex(item, meta));
    }

    @Nullable
    public static BoatType getTypeFrom(@Nonnull NBTTagCompound nbt) {
        Item item = Item.func_111206_d((String)nbt.func_74779_i("item"));
        return item != null ? SubaquaticBoatTypesConfig.getTypeFrom(item, nbt.func_74762_e("meta")) : null;
    }

    public static int getIndex(@Nonnull Item item, int meta) {
        return Item.func_150891_b((Item)item) << 16 | meta;
    }
}

