/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.subaquatic.mod.common.config;

import com.google.common.io.Files;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import git.jbredwards.fluidlogged_api.api.util.FluidState;
import git.jbredwards.fluidlogged_api.api.util.FluidloggedUtils;
import git.jbredwards.subaquatic.api.biome.IWaterColorProvider;
import git.jbredwards.subaquatic.mod.common.config.util.ConfigUtils;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.awt.Color;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeColorHelper;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.tuple.Pair;

public final class SubaquaticWaterColorConfig {
    @Nonnull
    static final Object2IntMap<Biome> FOG_COLORS = new Object2IntOpenHashMap();
    @Nonnull
    static final Object2IntMap<Biome> SURFACE_COLORS = new Object2IntOpenHashMap();
    @Nonnull
    static final Lock colorLock = new ReentrantLock();
    @Nonnull
    public static final Map<Fluid, Color> FLUID_PIXEL_BASE_COLORS = new HashMap<Fluid, Color>();
    static final int DEFAULT_WATER_COLOR = 4159204;
    static final int DEFAULT_WATER_COLOR_112 = 0xFFFFFF;
    static final int PERCEIVED_WATER_COLOR_112 = 2833396;
    @Nonnull
    public static final String defaultConfigValues = "{\n    //Frozen River\n    \"minecraft:frozen_river\":{\n        \"Surface\":\"0x185390\",\n        \"Fog\":\"0x185390\"\n    },\n    //Warm Ocean\n    \"subaquatic:warm_ocean\":{\n        \"Surface\":\"0x43D5EE\",\n        \"Fog\":\"0x43D5EE\"\n    },\n    //Deep Warm Ocean\n    \"subaquatic:deep_warm_ocean\":{\n        \"Surface\":\"0x43D5EE\",\n        \"Fog\":\"0x43D5EE\"\n    },\n    //Lukewarm Ocean\n    \"subaquatic:lukewarm_ocean\":{\n        \"Surface\":\"0x45ADF2\",\n        \"Fog\":\"0x45ADF2\"\n    },\n    //Deep Lukewarm Ocean\n    \"subaquatic:deep_lukewarm_ocean\":{\n        \"Surface\":\"0x45ADF2\",\n        \"Fog\":\"0x45ADF2\"\n    },\n    //Cold Ocean\n    \"subaquatic:cold_ocean\":{\n        \"Surface\":\"0x6092f2\",\n        \"Fog\":\"0x6092f2\"\n    },\n    //Deep Cold Ocean\n    \"subaquatic:deep_cold_ocean\":{\n        \"Surface\":\"0x6092f2\",\n        \"Fog\":\"0x6092f2\"\n    },\n    //Frozen Ocean\n    \"minecraft:frozen_ocean\":{\n        \"Surface\":\"0x77a9ff\",\n        \"Fog\":\"0x77a9ff\"\n    },\n    //Deep Frozen Ocean\n    \"subaquatic:deep_frozen_ocean\":{\n        \"Surface\":\"0x77a9ff\",\n        \"Fog\":\"0x77a9ff\"\n    }\n}";

    public static void buildWaterColors() throws IOException {
        block2: {
            ConfigUtils.parseFromMods("subaquatic/water_colors.jsonc", SubaquaticWaterColorConfig::parseWaterColors);
            File file = new File("config/subaquatic", "water_colors.jsonc");
            try {
                SubaquaticWaterColorConfig.parseWaterColors(new FileReader(file));
            }
            catch (FileNotFoundException e) {
                SubaquaticWaterColorConfig.parseWaterColors(new StringReader(defaultConfigValues));
                Files.createParentDirs((File)file);
                if (!file.createNewFile()) break block2;
                FileWriter writer = new FileWriter(file);
                writer.write(defaultConfigValues);
                writer.close();
            }
        }
    }

    static void parseWaterColors(@Nonnull Reader reader) {
        JsonObject waterColorsFile = new JsonParser().parse(reader).getAsJsonObject();
        waterColorsFile.entrySet().forEach(element -> {
            Biome biome;
            if (((JsonElement)element.getValue()).isJsonObject() && (biome = (Biome)Biome.field_185377_q.func_82594_a((Object)new ResourceLocation((String)element.getKey()))) != null) {
                JsonPrimitive surfaceColor;
                JsonPrimitive fogColor = ((JsonElement)element.getValue()).getAsJsonObject().getAsJsonPrimitive("Fog");
                if (fogColor != null) {
                    if (fogColor.isString()) {
                        FOG_COLORS.put((Object)biome, (Object)Integer.decode(fogColor.getAsString()));
                    } else if (fogColor.isNumber()) {
                        FOG_COLORS.put((Object)biome, fogColor.getAsInt());
                    }
                }
                if ((surfaceColor = ((JsonElement)element.getValue()).getAsJsonObject().getAsJsonPrimitive("Surface")) != null) {
                    if (surfaceColor.isString()) {
                        SURFACE_COLORS.put((Object)biome, (Object)Integer.decode(surfaceColor.getAsString()));
                    } else if (surfaceColor.isNumber()) {
                        SURFACE_COLORS.put((Object)biome, surfaceColor.getAsInt());
                    }
                }
            }
        });
    }

    public static float[] getFogColorAt(@Nonnull IBlockAccess worldIn, @Nonnull BlockPos posIn) {
        return new Color(BiomeColorHelper.func_180285_a((IBlockAccess)worldIn, (BlockPos)posIn, (biomeIn, pos) -> SubaquaticWaterColorConfig.computeIfAbsentSafe(FOG_COLORS, biomeIn, biome -> biome instanceof IWaterColorProvider ? ((IWaterColorProvider)biome).getWaterFogColor() : biome.getWaterColorMultiplier()))).getColorComponents(new float[3]);
    }

    public static int getSurfaceColor(@Nonnull Biome biomeIn, int originalColor) {
        return SubaquaticWaterColorConfig.computeIfAbsentSafe(SURFACE_COLORS, biomeIn, biome -> {
            if (biome instanceof IWaterColorProvider) {
                return ((IWaterColorProvider)biome).getWaterSurfaceColor();
            }
            if (originalColor == 14745518) {
                return 6388580;
            }
            if (originalColor != 0xFFFFFF) {
                return SubaquaticWaterColorConfig.emulateLegacyColor(originalColor);
            }
            if (!ForgeRegistries.BIOMES.containsValue((IForgeRegistryEntry)biome)) {
                return 4159204;
            }
            Set biomeTags = BiomeDictionary.getTypes((Biome)biome);
            if (biomeTags.contains(BiomeDictionary.Type.NETHER)) {
                return 9460055;
            }
            if (biomeTags.contains(BiomeDictionary.Type.END)) {
                return 6443678;
            }
            if (biomeTags.contains(BiomeDictionary.Type.MESA)) {
                return 5144449;
            }
            if (biomeTags.contains(BiomeDictionary.Type.JUNGLE)) {
                return 1810136;
            }
            if (biomeTags.contains(BiomeDictionary.Type.MUSHROOM)) {
                return 9079191;
            }
            if (biomeTags.contains(BiomeDictionary.Type.SWAMP)) {
                return 6388580;
            }
            if (biomeTags.contains(BiomeDictionary.Type.SANDY)) {
                return 3319192;
            }
            if (biomeTags.contains(BiomeDictionary.Type.SAVANNA)) {
                return 2919324;
            }
            if (biomeTags.contains(BiomeDictionary.Type.CONIFEROUS)) {
                return 1993602;
            }
            if (biomeTags.contains(BiomeDictionary.Type.WASTELAND)) {
                return 1332635;
            }
            if (biomeTags.contains(BiomeDictionary.Type.MOUNTAIN)) {
                return 943019;
            }
            if (biomeTags.contains(BiomeDictionary.Type.FOREST)) {
                return 4159204;
            }
            if (biomeTags.contains(BiomeDictionary.Type.PLAINS)) {
                return 4159204;
            }
            if (biomeTags.contains(BiomeDictionary.Type.SNOWY)) {
                return 1136295;
            }
            if (biomeTags.contains(BiomeDictionary.Type.BEACH)) {
                return 4159204;
            }
            if (biomeTags.contains(BiomeDictionary.Type.COLD)) {
                return 31735;
            }
            if (biomeTags.contains(BiomeDictionary.Type.HOT)) {
                return 0x1A7AA1;
            }
            return 4159204;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    static <K, V> V computeIfAbsentSafe(@Nonnull Map<K, V> map, @Nonnull K key, @Nonnull Function<? super K, ? extends V> mappingFunction) {
        colorLock.lock();
        try {
            V v = map.computeIfAbsent((K)key, mappingFunction);
            return v;
        }
        finally {
            colorLock.unlock();
        }
    }

    static int emulateLegacyColor(int originalColor) {
        if (originalColor == 0xFFFFFF) {
            return 4159204;
        }
        int modR = (originalColor & 0xFF0000) >> 16;
        int modG = (originalColor & 0xFF00) >> 8;
        int modB = originalColor & 0xFF;
        int legacyR = 43;
        int legacyG = 59;
        int legacyB = 244;
        int displayedR = modR * 43 / 255;
        int displayedG = modG * 59 / 255;
        int displayedB = modB * 244 / 255;
        return displayedR << 16 | displayedG << 8 | displayedB;
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public static Color getParticleColorAt(@Nonnull World worldIn, double x, double y, double z) {
        Pair<BlockPos, FluidState> here = SubaquaticWaterColorConfig.findClosestAround(FluidloggedUtils::getFluidState, fluidState -> !fluidState.isEmpty(), worldIn, x, y, z);
        if (here == null) {
            return new Color(BiomeColorHelper.func_180288_c((IBlockAccess)worldIn, (BlockPos)new BlockPos(x, y, z)));
        }
        BlockPos pos = (BlockPos)here.getLeft();
        FluidState fluidState2 = (FluidState)here.getRight();
        int blockColor = Minecraft.func_71410_x().func_184125_al().func_186724_a(fluidState2.getState(), (IBlockAccess)worldIn, pos, 0);
        if (blockColor != -1) {
            return new Color(blockColor);
        }
        int fluidColor = fluidState2.getFluid().getColor(worldIn, pos);
        return fluidColor != -1 ? new Color(fluidColor) : FLUID_PIXEL_BASE_COLORS.get(fluidState2.getFluid());
    }

    @Nullable
    public static <T> Pair<BlockPos, T> findClosestAround(@Nonnull BiFunction<World, BlockPos, T> getter, @Nonnull Predicate<T> checker, @Nonnull World world, double x, double y, double z) {
        BlockPos origin = new BlockPos(x, y, z);
        T instance = getter.apply(world, origin);
        if (checker.test(instance)) {
            return Pair.of((Object)origin, instance);
        }
        ArrayList<Pair> instances = new ArrayList<Pair>();
        for (BlockPos pos : BlockPos.func_177975_b((BlockPos)new BlockPos(x - 0.25, y - 0.25, z - 0.25), (BlockPos)new BlockPos(x + 0.25, y + 0.25, z + 0.25))) {
            if (pos.equals((Object)origin) || !checker.test(instance = getter.apply(world, pos))) continue;
            instances.add(Pair.of((Object)pos, instance));
        }
        double closestDist = -1.0;
        Pair closest = null;
        for (Pair entry : instances) {
            double distance = ((BlockPos)entry.getLeft()).func_177957_d(x, y, z);
            if (!(closestDist > distance)) continue;
            closestDist = distance;
            closest = entry;
        }
        return closest;
    }
}

