/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.subaquatic.mod.common.config.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.Loader;

public final class ConfigUtils {
    public static void parseFromMods(@Nonnull String fileName, @Nonnull Consumer<InputStreamReader> fileParser) {
        for (String modid : Loader.instance().getIndexedModList().keySet()) {
            InputStream stream = Loader.class.getResourceAsStream(String.format("/assets/%s/%s", modid, fileName));
            if (stream == null) continue;
            fileParser.accept(new InputStreamReader(stream));
        }
    }

    public static void readPerBiomeRarity(@Nonnull String[] perBiomeRarityConfig, @Nonnull Object2IntMap<Biome> perBiomeRarity) {
        perBiomeRarity.clear();
        Arrays.stream(perBiomeRarityConfig).map(cfg -> new JsonParser().parse(cfg).getAsJsonObject()).forEach(json -> {
            int rarity = JsonUtils.func_151203_m((JsonObject)json, (String)"Value");
            JsonUtils.func_151213_a((JsonObject)json, (String)"Biomes", (JsonArray)new JsonArray()).forEach(biomeName -> {
                Biome biome = (Biome)Biome.field_185377_q.func_82594_a((Object)new ResourceLocation(JsonUtils.func_151206_a((JsonElement)biomeName, (String)"Biome")));
                if (biome != null) {
                    perBiomeRarity.put((Object)biome, rarity);
                }
            });
            JsonUtils.func_151213_a((JsonObject)json, (String)"BiomeTags", (JsonArray)new JsonArray()).forEach(biomeTagName -> {
                BiomeDictionary.Type type = BiomeDictionary.Type.getType((String)JsonUtils.func_151206_a((JsonElement)biomeTagName, (String)"BiomeTag"), (BiomeDictionary.Type[])new BiomeDictionary.Type[0]);
                BiomeDictionary.getBiomes((BiomeDictionary.Type)type).forEach(biome -> perBiomeRarity.put(biome, rarity));
            });
        });
    }
}

