/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.subaquatic.mod.common.entity.ai;

import git.jbredwards.subaquatic.mod.common.entity.living.AbstractGroupFish;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.ai.EntityAIBase;

public class EntityAIFishSwimGroup
extends EntityAIBase {
    @Nonnull
    protected final AbstractGroupFish fish;
    protected int navigateTimer;
    protected int followDelay;

    public EntityAIFishSwimGroup(@Nonnull AbstractGroupFish fishIn) {
        this.fish = fishIn;
        this.followDelay = this.getInitialFollowDelay();
    }

    protected int getInitialFollowDelay() {
        return 200 + this.fish.func_70681_au().nextInt(200) % 20;
    }

    public boolean func_75250_a() {
        if (this.fish.isGroupLeader()) {
            return false;
        }
        if (this.fish.hasGroupLeader()) {
            return true;
        }
        if (this.followDelay > 0) {
            --this.followDelay;
            return false;
        }
        this.followDelay = this.getInitialFollowDelay();
        List nearbyFish = this.fish.field_70170_p.func_175647_a(this.fish.getClass(), this.fish.func_174813_aQ().func_186662_g(8.0), entity -> entity.canAddToGroup() || entity.hasNoGroup());
        AbstractGroupFish groupLeader = nearbyFish.stream().filter(AbstractGroupFish::canAddToGroup).findAny().orElse(this.fish);
        groupLeader.addFishToGroup(nearbyFish.stream().filter(AbstractGroupFish::hasNoGroup));
        return this.fish.hasGroupLeader();
    }

    public boolean func_75253_b() {
        return this.fish.hasGroupLeader() && this.fish.isWithinLeader();
    }

    public void func_75249_e() {
        this.navigateTimer = 0;
    }

    public void func_75251_c() {
        this.fish.separateFromGroupLeader();
    }

    public void func_75246_d() {
        if (--this.navigateTimer <= 0) {
            this.navigateTimer = -Math.floorDiv(10, 2);
            this.fish.followLeader();
        }
    }
}

