/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.subaquatic.mod.common.entity.item;

import git.jbredwards.subaquatic.mod.common.entity.item.part.MultiPartContainerPart;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IEntityMultiPart;
import net.minecraft.entity.MultiPartEntityPart;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IDataFixer;
import net.minecraft.util.datafix.IDataWalker;
import net.minecraft.util.datafix.IFixType;
import net.minecraft.util.datafix.walkers.Filtered;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ITeleporter;

public abstract class AbstractBoatContainer
extends EntityBoat
implements IEntityMultiPart {
    @Nonnull
    private static final DataParameter<ItemStack> CONTAINER_STACK = EntityDataManager.func_187226_a(AbstractBoatContainer.class, (DataSerializer)DataSerializers.field_187196_f);
    public final MultiPartContainerPart containerPart = this.createContainerPart();

    public AbstractBoatContainer(@Nonnull World worldIn) {
        super(worldIn);
    }

    public AbstractBoatContainer(@Nonnull World worldIn, double x, double y, double z) {
        super(worldIn, x, y, z);
    }

    public static void registerFixer(@Nonnull DataFixer fixer) {
        fixer.func_188258_a(FixTypes.ENTITY, (IDataWalker)new Filtered(AbstractBoatContainer.class){

            @Nonnull
            public NBTTagCompound func_188271_b(@Nonnull IDataFixer fixer, @Nonnull NBTTagCompound compound, int versionIn) {
                return fixer.func_188251_a((IFixType)FixTypes.ENTITY, compound.func_74775_l("ContainerNBT"), versionIn);
            }
        });
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(CONTAINER_STACK, (Object)ItemStack.field_190927_a);
    }

    @Nonnull
    protected abstract MultiPartContainerPart createContainerPart();

    protected boolean func_184219_q(@Nonnull Entity passenger) {
        return this.func_184188_bt().size() == 0;
    }

    public void func_184232_k(@Nonnull Entity passenger) {
        Vec3d offset = new Vec3d(0.2, 0.0, 0.0).func_178785_b(-this.field_70177_z * 0.0175f - 1.5707964f);
        passenger.func_70107_b(this.field_70165_t + offset.field_72450_a, this.field_70163_u + (this.field_70128_L ? 0.01 : this.func_70042_X() + passenger.func_70033_W()), this.field_70161_v + offset.field_72449_c);
        passenger.field_70177_z += this.field_184475_as;
        passenger.func_70034_d(passenger.func_70079_am() + this.field_184475_as);
        this.func_184454_a(passenger);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.containerPart.func_70071_h_();
        Vec3d offset = this.containerPart.getContainerOffset(true);
        this.containerPart.func_70012_b(this.field_70165_t + offset.field_72450_a, this.field_70163_u + offset.field_72448_b, this.field_70161_v + offset.field_72449_c, this.field_70177_z, this.field_70125_A);
    }

    @Nullable
    public Entity changeDimension(int dimensionIn, @Nonnull ITeleporter teleporter) {
        Entity newEntity = super.changeDimension(dimensionIn, teleporter);
        if (newEntity instanceof AbstractBoatContainer) {
            ((AbstractBoatContainer)newEntity).containerPart.onDimensionChanged();
            ((AbstractBoatContainer)newEntity).containerPart.field_71093_bK = newEntity.field_71093_bK;
            return newEntity;
        }
        return null;
    }

    @Nonnull
    public Entity[] func_70021_al() {
        return new Entity[]{this.containerPart};
    }

    @Nonnull
    public World func_82194_d() {
        return this.field_70170_p;
    }

    public void func_70108_f(@Nonnull Entity entityIn) {
        if (entityIn != this.containerPart) {
            super.func_70108_f(entityIn);
        }
    }

    public boolean func_70965_a(@Nonnull MultiPartEntityPart part, @Nonnull DamageSource source, float damage) {
        return this.func_70097_a(source, damage);
    }

    public boolean func_70097_a(@Nonnull DamageSource source, float amount) {
        boolean isCreative;
        if (this.field_70128_L || this.field_70170_p.field_72995_K || this.func_180431_b(source)) {
            return false;
        }
        if (this.func_184196_w(source.func_76346_g())) {
            return false;
        }
        float damageTaken = this.func_70271_g() + amount * 10.0f;
        this.func_70269_c(-this.func_70267_i());
        this.func_70266_a(damageTaken);
        this.func_70265_b(10);
        this.func_70018_K();
        boolean bl = isCreative = source.func_76346_g() instanceof EntityPlayer && ((EntityPlayer)source.func_76346_g()).func_184812_l_();
        if (isCreative || damageTaken > 40.0f) {
            if (!isCreative && this.field_70170_p.func_82736_K().func_82766_b("doEntityDrops")) {
                this.func_70099_a(this.getContainerStack(), 0.0f);
            }
            this.func_70106_y();
        }
        return true;
    }

    public void func_70106_y() {
        super.func_70106_y();
        this.containerPart.func_70106_y();
    }

    @Nonnull
    public ItemStack getPickedResult(@Nonnull RayTraceResult target) {
        return this.getContainerStack();
    }

    @Nonnull
    public ItemStack getContainerStack() {
        return (ItemStack)this.field_70180_af.func_187225_a(CONTAINER_STACK);
    }

    public void setContainerStack(@Nonnull ItemStack stack) {
        this.field_70180_af.func_187227_b(CONTAINER_STACK, (Object)stack);
    }

    protected void func_70014_b(@Nonnull NBTTagCompound compound) {
        NBTTagCompound containerNBT = new NBTTagCompound();
        containerNBT.func_74778_a("id", String.format("%s:multipart_%s", "subaquatic", this.containerPart.getFixType()));
        compound.func_74782_a("ContainerNBT", (NBTBase)this.containerPart.func_189511_e(containerNBT));
        compound.func_74782_a("ContainerStack", (NBTBase)this.getContainerStack().serializeNBT());
    }

    protected void func_70037_a(@Nonnull NBTTagCompound compound) {
        if (compound.func_150297_b("ContainerStack", 10)) {
            this.setContainerStack(new ItemStack(compound.func_74775_l("ContainerStack")));
        }
        if (compound.func_150297_b("ContainerNBT", 10)) {
            this.containerPart.deserializeNBT(compound.func_74775_l("ContainerNBT"));
        }
    }
}

