/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.subaquatic.mod.common.entity.item.part;

import git.jbredwards.subaquatic.mod.Subaquatic;
import git.jbredwards.subaquatic.mod.common.entity.item.part.MultiPartAbstractInventoryPart;
import git.jbredwards.subaquatic.mod.common.message.SMessageAbstractChestPart;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelChest;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IEntityMultiPart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class MultiPartAbstractChestPart
extends MultiPartAbstractInventoryPart {
    public float lidAngle;
    public float prevLidAngle;
    protected int numPlayersUsing;
    @SideOnly(value=Side.CLIENT)
    protected static ModelChest CHEST_MODEL;

    public MultiPartAbstractChestPart(@Nonnull IEntityMultiPart parent, @Nonnull String partName, float width, float height) {
        super(parent, partName, width, height);
    }

    public int getNumPlayersUsing() {
        return this.numPlayersUsing;
    }

    public void setNumPlayersUsing(int numPlayersUsingIn) {
        if (!this.field_70170_p.field_72995_K) {
            Subaquatic.WRAPPER.sendToAllTracking((IMessage)new SMessageAbstractChestPart(numPlayersUsingIn, this.parentBoat.func_145782_y()), (Entity)this.parentBoat);
        }
        this.numPlayersUsing = numPlayersUsingIn;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.prevLidAngle = this.lidAngle;
        if (this.numPlayersUsing > 0 && this.lidAngle == 0.0f) {
            this.playChestOpenSound();
        }
        if (this.numPlayersUsing == 0 && this.lidAngle > 0.0f || this.numPlayersUsing > 0 && this.lidAngle < 1.0f) {
            this.lidAngle = this.numPlayersUsing > 0 ? (float)((double)this.lidAngle + 0.1) : (float)((double)this.lidAngle - 0.1);
            if ((double)this.lidAngle < 0.5 && (double)this.prevLidAngle >= 0.5) {
                this.playChestCloseSound();
            }
            this.lidAngle = MathHelper.func_76131_a((float)this.lidAngle, (float)0.0f, (float)1.0f);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderContainer(double x, double y, double z, float entityYaw, float partialTicks, boolean isChristmas) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(this.getChestTexture(isChristmas));
        GlStateManager.func_179137_b((double)-0.0625, (double)0.15375, (double)-0.0625);
        GlStateManager.func_179139_a((double)0.875, (double)0.875, (double)0.875);
        float animatedLidAngle = 1.0f - (this.prevLidAngle + (this.lidAngle - this.prevLidAngle) * partialTicks);
        animatedLidAngle = 1.0f - animatedLidAngle * animatedLidAngle * animatedLidAngle;
        if (CHEST_MODEL == null) {
            CHEST_MODEL = new ModelChest();
        }
        MultiPartAbstractChestPart.CHEST_MODEL.field_78234_a.field_78795_f = -(animatedLidAngle * (float)Math.PI / 2.0f);
        CHEST_MODEL.func_78231_a();
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    protected abstract ResourceLocation getChestTexture(boolean var1);

    public void playChestCloseSound() {
        this.func_184185_a(SoundEvents.field_187651_T, 0.5f, this.field_70146_Z.nextFloat() * 0.1f + 0.9f);
    }

    public void playChestOpenSound() {
        this.func_184185_a(SoundEvents.field_187657_V, 0.5f, this.field_70146_Z.nextFloat() * 0.1f + 0.9f);
    }

    @Override
    public void func_174886_c(@Nonnull EntityPlayer player) {
        int numPlayersUsing = this.getNumPlayersUsing();
        if (numPlayersUsing > 0) {
            this.setNumPlayersUsing(numPlayersUsing - 1);
        }
    }

    @Override
    public void func_174889_b(@Nonnull EntityPlayer player) {
        this.setNumPlayersUsing(this.getNumPlayersUsing() + 1);
    }

    @Nonnull
    public String func_174875_k() {
        return "minecraft:chest";
    }
}

