/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.subaquatic.mod.common.entity.item.part;

import git.jbredwards.subaquatic.mod.common.entity.item.part.MultiPartAbstractChestPart;
import java.util.Collections;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.tileentity.TileEntityChestRenderer;
import net.minecraft.entity.IEntityMultiPart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.ILootContainer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MultiPartChestPart
extends MultiPartAbstractChestPart
implements ILootContainer {
    @Nonnull
    protected final NonNullList<ItemStack> items = NonNullList.func_191197_a((int)27, (Object)ItemStack.field_190927_a);
    protected ResourceLocation lootTable;
    protected long lootTableSeed;

    public MultiPartChestPart(@Nonnull IEntityMultiPart parent, @Nonnull String partName, float width, float height) {
        super(parent, partName, width, height);
    }

    @Nonnull
    public Container func_174876_a(@Nonnull InventoryPlayer playerInventory, @Nonnull EntityPlayer playerIn) {
        this.tryFillWithLoot(playerIn);
        return new ContainerChest((IInventory)playerInventory, (IInventory)this, playerIn);
    }

    @Override
    public void func_174889_b(@Nonnull EntityPlayer player) {
        super.func_174889_b(player);
        player.func_71029_a(StatList.field_188063_ac);
    }

    @Override
    @Nonnull
    @SideOnly(value=Side.CLIENT)
    protected ResourceLocation getChestTexture(boolean isChristmas) {
        return isChristmas ? TileEntityChestRenderer.field_147503_f : TileEntityChestRenderer.field_147504_g;
    }

    protected void func_70037_a(@Nonnull NBTTagCompound compound) {
        if (compound.func_150297_b("LootTable", 8)) {
            this.lootTable = new ResourceLocation(compound.func_74779_i("LootTable"));
            this.lootTableSeed = compound.func_74763_f("LootTableSeed");
        } else {
            ItemStackHelper.func_191283_b((NBTTagCompound)compound, this.items);
        }
    }

    protected void func_70014_b(@Nonnull NBTTagCompound compound) {
        if (this.lootTable != null) {
            compound.func_74778_a("LootTable", this.lootTable.toString());
            compound.func_74772_a("LootTableSeed", this.lootTableSeed);
        } else {
            ItemStackHelper.func_191282_a((NBTTagCompound)compound, this.items);
        }
    }

    public int func_70302_i_() {
        return this.items.size();
    }

    public boolean func_191420_l() {
        for (ItemStack stack : this.items) {
            if (stack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    @Nonnull
    public ItemStack func_70301_a(int index) {
        this.tryFillWithLoot(null);
        return (ItemStack)this.items.get(index);
    }

    @Nonnull
    public ItemStack func_70298_a(int index, int count) {
        this.tryFillWithLoot(null);
        return ItemStackHelper.func_188382_a(this.items, (int)index, (int)count);
    }

    @Nonnull
    public ItemStack func_70304_b(int index) {
        this.tryFillWithLoot(null);
        return ItemStackHelper.func_188383_a(this.items, (int)index);
    }

    public void func_70299_a(int index, @Nonnull ItemStack stack) {
        this.lootTable = null;
        this.items.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
    }

    public void func_174888_l() {
        this.lootTable = null;
        Collections.fill(this.items, ItemStack.field_190927_a);
    }

    @Nullable
    public ResourceLocation func_184276_b() {
        return this.lootTable;
    }

    protected void tryFillWithLoot(@Nullable EntityPlayer player) {
        if (this.lootTable != null) {
            LootTable table = this.field_70170_p.func_184146_ak().func_186521_a(this.lootTable);
            this.lootTable = null;
            Random seed = this.lootTableSeed != 0L ? new Random(this.lootTableSeed) : new Random();
            LootContext.Builder builder = new LootContext.Builder((WorldServer)this.field_70170_p);
            if (player != null) {
                builder.func_186469_a(player.func_184817_da()).func_186470_a(player);
            }
            table.func_186460_a((IInventory)this, seed, builder.func_186471_a());
        }
    }
}

