/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.subaquatic.mod.common.entity.item.part;

import git.jbredwards.subaquatic.mod.Subaquatic;
import git.jbredwards.subaquatic.mod.common.entity.item.EntityBoatFurnace;
import git.jbredwards.subaquatic.mod.common.entity.item.part.MultiPartAbstractInventoryPart;
import git.jbredwards.subaquatic.mod.common.message.SMessageFurnacePart;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFurnace;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IEntityMultiPart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerFurnace;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.SlotFurnaceFuel;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;

@Mod.EventBusSubscriber(modid="subaquatic")
public class MultiPartFurnacePart
extends MultiPartAbstractInventoryPart
implements ISidedInventory {
    @Nonnull
    protected final NonNullList<ItemStack> items = NonNullList.func_191197_a((int)3, (Object)ItemStack.field_190927_a);
    protected int burnTime;
    protected int totalFuelBurnTime;
    protected int cookTime;
    protected int totalCookTime;
    @Nullable
    @SideOnly(value=Side.CLIENT)
    protected IBlockState stateForRender;

    public MultiPartFurnacePart(@Nonnull IEntityMultiPart parent, @Nonnull String partName, float width, float height) {
        super(parent, partName, width, height);
    }

    public void func_70071_h_() {
        boolean prevIsBurning;
        super.func_70071_h_();
        boolean bl = prevIsBurning = this.burnTime > 0;
        if (prevIsBurning) {
            --this.burnTime;
        }
        if (!this.field_70170_p.field_72995_K) {
            ItemStack fuel = this.func_70301_a(1);
            if (this.burnTime > 0 || !fuel.func_190926_b() && !this.func_70301_a(0).func_190926_b()) {
                if (this.burnTime == 0 && this.canSmeltItem()) {
                    this.totalFuelBurnTime = this.burnTime = TileEntityFurnace.func_145952_a((ItemStack)fuel);
                    if (this.burnTime > 0 && !fuel.func_190926_b()) {
                        fuel.func_190918_g(1);
                        if (fuel.func_190926_b()) {
                            this.func_70299_a(1, fuel.func_77973_b().getContainerItem(fuel));
                        }
                    }
                    Subaquatic.WRAPPER.sendToAllTracking((IMessage)new SMessageFurnacePart((Entity)this.parentBoat, this.burnTime), (Entity)this.parentBoat);
                }
                if (this.burnTime > 0 && this.canSmeltItem()) {
                    if (++this.cookTime == this.totalCookTime) {
                        this.cookTime = 0;
                        this.totalCookTime = this.getTotalCookTime(this.func_70301_a(0));
                        this.smeltItem();
                    }
                } else {
                    this.cookTime = 0;
                }
            } else if (this.burnTime == 0 && this.cookTime > 0) {
                this.cookTime = MathHelper.func_76125_a((int)(this.cookTime - 2), (int)0, (int)this.totalCookTime);
            }
            if (this.burnTime > 0 != prevIsBurning) {
                Subaquatic.WRAPPER.sendToAllTracking((IMessage)new SMessageFurnacePart((Entity)this.parentBoat, this.burnTime), (Entity)this.parentBoat);
            }
        } else if (this.burnTime > 0 && (double)this.field_70146_Z.nextFloat() < 0.1) {
            this.spawnBurningParticles();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void spawnBurningParticles() {
        if ((double)this.field_70146_Z.nextFloat() < 0.1) {
            this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187652_bv, this.func_184176_by(), 1.0f, 1.0f, false);
        }
        if (this.field_70146_Z.nextInt(4) == 0) {
            this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_LARGE, this.field_70165_t, this.field_70163_u + 0.9, this.field_70161_v, 0.0, 0.0, 0.0, new int[0]);
        }
        this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t + (double)this.field_70146_Z.nextFloat() * 0.5 - 0.25, this.field_70163_u + 0.9, this.field_70161_v + (double)this.field_70146_Z.nextFloat() * 0.5 - 0.25, 0.0, 0.0, 0.0, new int[0]);
    }

    public boolean canSmeltItem() {
        ItemStack toSmelt = this.func_70301_a(0);
        if (toSmelt.func_190926_b()) {
            return false;
        }
        ItemStack result = this.getSmeltingResult(toSmelt);
        if (result.func_190926_b()) {
            return false;
        }
        ItemStack smelted = this.func_70301_a(2);
        return smelted.func_190926_b() || smelted.func_190916_E() + result.func_190916_E() <= this.func_70297_j_() && ItemHandlerHelper.canItemStacksStack((ItemStack)result, (ItemStack)smelted);
    }

    public void smeltItem() {
        ItemStack toSmelt = this.func_70301_a(0);
        ItemStack result = this.getSmeltingResult(toSmelt);
        ItemStack smelted = this.func_70301_a(2);
        if (smelted.func_190926_b()) {
            this.func_70299_a(2, result.func_77946_l());
        } else {
            smelted.func_190917_f(result.func_190916_E());
        }
        ItemStack fuel = this.func_70301_a(1);
        if (fuel.func_190916_E() == 1 && fuel.func_77973_b() == Items.field_151133_ar && toSmelt.func_77960_j() == 1 && toSmelt.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150360_v)) {
            this.func_70299_a(1, new ItemStack(Items.field_151131_as));
        }
        toSmelt.func_190918_g(1);
    }

    @Nonnull
    public ItemStack getSmeltingResult(@Nonnull ItemStack stack) {
        return FurnaceRecipes.func_77602_a().func_151395_a(stack);
    }

    public int getTotalCookTime(@Nonnull ItemStack stack) {
        return 200;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderContainer(double x, double y, double z, float entityYaw, float partialTicks, boolean isChristmas) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)-0.0625, (double)1.13, (double)-0.0625);
        GlStateManager.func_179139_a((double)0.875, (double)-0.875, (double)-0.875);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        int brightness = this.func_70070_b();
        float prevBrightnessX = OpenGlHelper.lastBrightnessX;
        float prevBrightnessY = OpenGlHelper.lastBrightnessY;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)(brightness % 65536), (float)((float)brightness / 65536.0f));
        Minecraft.func_71410_x().func_175602_ab().func_175016_a(this.getFurnaceToRender(isChristmas), (float)brightness / 65536.0f);
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)prevBrightnessX, (float)prevBrightnessY);
        GlStateManager.func_179121_F();
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    protected IBlockState getFurnaceToRender(boolean isChristmas) {
        Block blockForRender;
        Block block = blockForRender = this.burnTime > 0 ? Blocks.field_150470_am : Blocks.field_150460_al;
        if (this.stateForRender == null || this.stateForRender.func_177230_c() != blockForRender) {
            this.stateForRender = blockForRender.func_176223_P().func_177226_a((IProperty)BlockFurnace.field_176447_a, (Comparable)EnumFacing.WEST);
        }
        return this.stateForRender;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b() {
        return this.burnTime > 0 ? Math.max(0xF000F0, super.func_70070_b()) : super.func_70070_b();
    }

    protected void func_70037_a(@Nonnull NBTTagCompound compound) {
        ItemStackHelper.func_191283_b((NBTTagCompound)compound, this.items);
        this.burnTime = compound.func_74762_e("BurnTime");
        this.cookTime = compound.func_74762_e("CookTime");
        this.totalCookTime = compound.func_74762_e("CookTimeTotal");
        this.totalFuelBurnTime = TileEntityFurnace.func_145952_a((ItemStack)this.func_70301_a(1));
    }

    protected void func_70014_b(@Nonnull NBTTagCompound compound) {
        ItemStackHelper.func_191282_a((NBTTagCompound)compound, this.items);
        compound.func_74768_a("BurnTime", this.burnTime);
        compound.func_74768_a("CookTime", this.cookTime);
        compound.func_74768_a("CookTimeTotal", this.totalCookTime);
    }

    public int func_70302_i_() {
        return this.items.size();
    }

    public boolean func_191420_l() {
        for (ItemStack stack : this.items) {
            if (stack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    @Nonnull
    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.items.get(index);
    }

    @Nonnull
    public ItemStack func_70298_a(int index, int count) {
        return ItemStackHelper.func_188382_a(this.items, (int)index, (int)count);
    }

    @Nonnull
    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.items, (int)index);
    }

    public void func_70299_a(int index, @Nonnull ItemStack stack) {
        ItemStack oldStack = this.func_70301_a(index);
        this.items.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        if (!(index != 0 || !stack.func_190926_b() && stack.func_77969_a(oldStack) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)oldStack))) {
            this.totalCookTime = this.getTotalCookTime(stack);
            this.cookTime = 0;
        }
    }

    @Override
    public boolean func_94041_b(int index, @Nonnull ItemStack stack) {
        if (index == 2) {
            return false;
        }
        if (index == 0) {
            return true;
        }
        ItemStack fuel = (ItemStack)this.items.get(1);
        return TileEntityFurnace.func_145954_b((ItemStack)stack) || SlotFurnaceFuel.func_178173_c_((ItemStack)stack) && fuel.func_77973_b() != Items.field_151133_ar;
    }

    @Nonnull
    public int[] func_180463_a(@Nonnull EnumFacing side) {
        switch (side) {
            case UP: {
                return TileEntityFurnace.field_145962_k;
            }
            case DOWN: {
                return TileEntityFurnace.field_145959_l;
            }
        }
        return TileEntityFurnace.field_145960_m;
    }

    public boolean func_180462_a(int index, @Nonnull ItemStack itemStackIn, @Nonnull EnumFacing direction) {
        return this.func_94041_b(index, itemStackIn);
    }

    public boolean func_180461_b(int index, @Nonnull ItemStack stack, @Nonnull EnumFacing direction) {
        return direction != EnumFacing.DOWN || index != 1 || stack.func_77973_b() == Items.field_151131_as || stack.func_77973_b() == Items.field_151133_ar;
    }

    @Override
    public void func_174889_b(@Nonnull EntityPlayer player) {
        player.func_71029_a(StatList.field_188061_aa);
    }

    @Nonnull
    public Container func_174876_a(@Nonnull InventoryPlayer playerInventory, @Nonnull EntityPlayer playerIn) {
        return new ContainerFurnace(playerInventory, (IInventory)this);
    }

    @Nonnull
    public String func_174875_k() {
        return "minecraft:furnace";
    }

    @Override
    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.burnTime;
            }
            case 1: {
                return this.totalFuelBurnTime;
            }
            case 2: {
                return this.cookTime;
            }
            case 3: {
                return this.totalCookTime;
            }
        }
        return 0;
    }

    @Override
    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.burnTime = value;
                break;
            }
            case 1: {
                this.totalFuelBurnTime = value;
                break;
            }
            case 2: {
                this.cookTime = value;
                break;
            }
            case 3: {
                this.totalCookTime = value;
            }
        }
    }

    @Override
    public int func_174890_g() {
        return 4;
    }

    public void func_174888_l() {
        Collections.fill(this.items, ItemStack.field_190927_a);
    }

    @SubscribeEvent
    static void syncBurnTimeOnJoin(@Nonnull PlayerEvent.StartTracking event) {
        if (event.getTarget() instanceof EntityBoatFurnace) {
            Subaquatic.WRAPPER.sendTo((IMessage)new SMessageFurnacePart(event.getTarget(), ((MultiPartFurnacePart)((EntityBoatFurnace)event.getTarget()).containerPart).burnTime), (EntityPlayerMP)event.getEntityPlayer());
        }
    }
}

