/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.subaquatic.mod.common.entity.living;

import git.jbredwards.subaquatic.mod.common.entity.ai.EntityAIFishSwimGroup;
import git.jbredwards.subaquatic.mod.common.entity.living.AbstractFish;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;

public abstract class AbstractGroupFish
extends AbstractFish {
    protected AbstractGroupFish groupLeader;
    protected int groupSize = 1;

    public AbstractGroupFish(@Nonnull World worldIn) {
        super(worldIn);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIFishSwimGroup(this));
    }

    @Override
    public int func_70641_bl() {
        return this.getMaxGroupSize();
    }

    public int getMaxGroupSize() {
        return super.func_70641_bl();
    }

    @Override
    public boolean hasNoGroup() {
        return !this.hasGroupLeader();
    }

    public boolean hasGroupLeader() {
        return this.groupLeader != null && this.groupLeader.func_70089_S();
    }

    public void addToGroupLeader(@Nonnull AbstractGroupFish leader) {
        this.groupLeader = leader;
        ++leader.groupSize;
    }

    public void separateFromGroupLeader() {
        --this.groupLeader.groupSize;
        this.groupLeader = null;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.isGroupLeader() && !this.field_70170_p.field_72995_K && this.field_70146_Z.nextInt(200) == 1 && this.field_70170_p.func_72872_a(this.getClass(), this.func_174813_aQ().func_186662_g(8.0)).size() <= 1) {
            this.groupSize = 1;
        }
    }

    public boolean isGroupLeader() {
        return this.groupSize > 1;
    }

    public boolean canAddToGroup() {
        return this.isGroupLeader() && this.groupSize < this.getMaxGroupSize();
    }

    public boolean isWithinLeader() {
        return this.func_70068_e((Entity)this.groupLeader) <= 121.0;
    }

    public void followLeader() {
        if (this.hasGroupLeader()) {
            this.field_70699_by.func_75497_a((Entity)this.groupLeader, 1.0);
        }
    }

    public void addFishToGroup(@Nonnull Stream<AbstractGroupFish> stream) {
        stream.limit(this.getMaxGroupSize() - this.groupSize).filter(entity -> entity != this).forEach(entity -> entity.addToGroupLeader(this));
    }

    @Nullable
    public IEntityLivingData func_180482_a(@Nonnull DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        super.func_180482_a(difficulty, livingdata);
        if (!(livingdata instanceof GroupData)) {
            return new GroupData(this);
        }
        this.addToGroupLeader(((GroupData)livingdata).groupLeader);
        return livingdata;
    }

    public static class GroupData
    implements IEntityLivingData {
        @Nonnull
        public final AbstractGroupFish groupLeader;

        public GroupData(@Nonnull AbstractGroupFish fishIn) {
            this.groupLeader = fishIn;
        }
    }
}

