/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.subaquatic.mod.common.entity.living;

import git.jbredwards.subaquatic.mod.common.entity.ai.EntitySwimMoveHelper;
import git.jbredwards.subaquatic.mod.common.entity.util.FrogData;
import git.jbredwards.subaquatic.mod.common.init.SubaquaticDataSerializers;
import java.util.OptionalInt;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.ai.EntityLookHelper;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathFinder;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateSwimmer;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;

public class EntityFrog
extends EntityAnimal {
    @Nonnull
    private static final DataParameter<OptionalInt> TONGUE_TARGET_ID = EntityDataManager.func_187226_a(EntityFrog.class, SubaquaticDataSerializers.OPTIONAL_INT);
    @Nonnull
    private static final DataParameter<FrogData> FROG_DATA = EntityDataManager.func_187226_a(EntityFrog.class, SubaquaticDataSerializers.FROG_DATA);

    public EntityFrog(@Nonnull World worldIn) {
        super(worldIn);
        this.func_184644_a(PathNodeType.WATER, 4.0f);
        this.func_184644_a(PathNodeType.TRAPDOOR, -1.0f);
        this.field_70138_W = 1.0f;
        this.field_70765_h = new EntitySwimMoveHelper((EntityLiving)this, 85, 10, 0.02f, 0.1f, true);
        this.field_70749_g = new EntityLookHelper((EntityLiving)this){

            public void func_75649_a() {
                if (EntityFrog.this.getTongueTarget() == null) {
                    this.field_75659_a.field_70125_A = 0.0f;
                }
                if (this.field_75655_d) {
                    this.field_75655_d = false;
                    double distX = this.field_75656_e - this.field_75659_a.field_70165_t;
                    double distY = this.field_75653_f - (this.field_75659_a.field_70163_u + (double)this.field_75659_a.func_70047_e());
                    double distZ = this.field_75654_g - this.field_75659_a.field_70161_v;
                    float lookYaw = (float)(MathHelper.func_181159_b((double)distZ, (double)distX) * 180.0 / Math.PI) - 90.0f;
                    float lookPitch = (float)(-(MathHelper.func_181159_b((double)distY, (double)Math.sqrt(distX * distX + distZ * distZ)) * 180.0 / Math.PI));
                    this.field_75659_a.field_70759_as = this.func_75652_a(this.field_75659_a.field_70759_as, lookYaw, this.field_75657_b);
                    this.field_75659_a.field_70125_A = this.func_75652_a(this.field_75659_a.field_70125_A, lookPitch, this.field_75658_c);
                } else {
                    this.field_75659_a.field_70759_as = this.func_75652_a(this.field_75659_a.field_70759_as, this.field_75659_a.field_70761_aq, 10.0f);
                }
                float wrapped = MathHelper.func_76142_g((float)(this.field_75659_a.field_70759_as - this.field_75659_a.field_70761_aq));
                if (!this.field_75659_a.func_70661_as().func_75500_f()) {
                    if (wrapped < -75.0f) {
                        this.field_75659_a.field_70759_as = this.field_75659_a.field_70761_aq - 75.0f;
                    }
                    if (wrapped > 75.0f) {
                        this.field_75659_a.field_70759_as = this.field_75659_a.field_70761_aq + 75.0f;
                    }
                }
            }
        };
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(TONGUE_TARGET_ID, (Object)OptionalInt.empty());
        this.field_70180_af.func_187214_a(FROG_DATA, (Object)FrogData.VARIANTS.getFirst());
    }

    @Nonnull
    protected PathNavigate func_175447_b(@Nonnull World worldIn) {
        return new PathNavigateSwimmer((EntityLiving)this, worldIn){

            @Nonnull
            protected PathFinder func_179679_a() {
                return super.func_179679_a();
            }

            protected boolean func_75485_k() {
                return true;
            }

            protected boolean func_75493_a(@Nonnull Vec3d point1, @Nonnull Vec3d point2, int sizeX, int sizeY, int sizeZ) {
                return this.func_75506_l() && super.func_75493_a(point1, point2, sizeX, sizeY, sizeZ);
            }

            public boolean func_188555_b(@Nonnull BlockPos pos) {
                return this.field_75513_b.func_180495_p(pos.func_177977_b()).func_185913_b();
            }
        };
    }

    public int func_70646_bf() {
        return 35;
    }

    @Nullable
    public EntityAgeable func_90011_a(@Nonnull EntityAgeable ageable) {
        return null;
    }

    public boolean func_70631_g_() {
        return false;
    }

    public void func_70873_a(int age) {
    }

    @Nullable
    public IEntityLivingData func_180482_a(@Nonnull DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        return livingdata;
    }

    @Nullable
    public Entity getTongueTarget() {
        OptionalInt targetId = (OptionalInt)this.field_70180_af.func_187225_a(TONGUE_TARGET_ID);
        return targetId.isPresent() ? this.field_70170_p.func_73045_a(targetId.getAsInt()) : null;
    }

    public void setTongueTarget(@Nullable Entity target) {
        this.field_70180_af.func_187227_b(TONGUE_TARGET_ID, (Object)(target != null ? OptionalInt.of(target.func_145782_y()) : OptionalInt.empty()));
    }

    @Nonnull
    public FrogData getFrogData() {
        return (FrogData)this.field_70180_af.func_187225_a(FROG_DATA);
    }

    public void setFrogData(@Nonnull FrogData data) {
        this.field_70180_af.func_187227_b(FROG_DATA, (Object)data);
    }
}

