/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.subaquatic.mod.common.entity.living;

import git.jbredwards.subaquatic.mod.common.entity.ai.EntityAIPuff;
import git.jbredwards.subaquatic.mod.common.entity.living.AbstractFish;
import git.jbredwards.subaquatic.mod.common.entity.living.EntityWaterCreature;
import git.jbredwards.subaquatic.mod.common.entity.util.fish_bucket.AbstractEntityBucketHandler;
import git.jbredwards.subaquatic.mod.common.entity.util.fish_bucket.EntityBucketHandlerPufferfish;
import git.jbredwards.subaquatic.mod.common.init.SubaquaticSounds;
import javax.annotation.Nonnull;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.EntityGuardian;
import net.minecraft.entity.passive.EntityWaterMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.server.SPacketSoundEffect;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public class EntityPufferfish
extends AbstractFish {
    @Nonnull
    private static final DataParameter<Integer> PUFF_STATE = EntityDataManager.func_187226_a(EntityPufferfish.class, (DataSerializer)DataSerializers.field_187192_b);
    protected float originalWidth = -1.0f;
    protected float originalHeight;
    public int deflateTimer;
    public int puffTimer;

    public EntityPufferfish(@Nonnull World worldIn) {
        super(worldIn);
        this.func_70105_a(0.7f, 0.7f);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIPuff(this));
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(PUFF_STATE, (Object)0);
    }

    public int getPuffState() {
        return (Integer)this.field_70180_af.func_187225_a(PUFF_STATE);
    }

    public void setPuffState(int puffState) {
        this.field_70180_af.func_187227_b(PUFF_STATE, (Object)puffState);
        this.onPuffStateChanged(puffState);
    }

    protected void onPuffStateChanged(int puffState) {
        float size = 1.0f;
        if (puffState == 1) {
            size = 0.7f;
        } else if (puffState == 0) {
            size = 0.5f;
        }
        this.updateSize(size);
    }

    protected void func_70105_a(float width, float height) {
        boolean initialized = this.originalWidth > 0.0f;
        this.originalWidth = width;
        this.originalHeight = height;
        if (!initialized) {
            this.updateSize(1.0f);
        }
    }

    protected void updateSize(float size) {
        super.func_70105_a(this.originalWidth * size, this.originalHeight * size);
    }

    public boolean canAttackEntity(@Nonnull EntityLivingBase entity) {
        return (!(entity instanceof EntityWaterCreature) && !(entity instanceof EntityWaterMob) && !(entity instanceof EntityGuardian) || ((EntityLiving)entity).func_70638_az() == this) && EntitySelectors.field_188444_d.apply((Object)entity);
    }

    public void func_184206_a(@Nonnull DataParameter<?> key) {
        if (key == PUFF_STATE) {
            this.onPuffStateChanged(this.getPuffState());
        }
        super.func_184206_a(key);
    }

    @Override
    public void func_70014_b(@Nonnull NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("PuffState", this.getPuffState());
    }

    @Override
    public void func_70037_a(@Nonnull NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setPuffState(compound.func_74762_e("PuffState"));
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K && this.func_70089_S()) {
            int puffState = this.getPuffState();
            if (this.puffTimer > 0) {
                ++this.puffTimer;
                if (puffState == 0) {
                    this.func_184185_a(SubaquaticSounds.ENTITY_PUFFERFISH_INFLATE, this.func_70599_aP(), this.func_70647_i());
                    this.setPuffState(1);
                } else if (this.puffTimer > 40 && puffState == 1) {
                    this.func_184185_a(SubaquaticSounds.ENTITY_PUFFERFISH_INFLATE, this.func_70599_aP(), this.func_70647_i());
                    this.setPuffState(2);
                }
            } else if (puffState != 0) {
                ++this.deflateTimer;
                if (this.deflateTimer > 60 && puffState == 2) {
                    this.func_184185_a(SubaquaticSounds.ENTITY_PUFFERFISH_DEFLATE, this.func_70599_aP(), this.func_70647_i());
                    this.setPuffState(1);
                } else if (this.deflateTimer > 100 && puffState == 1) {
                    this.func_184185_a(SubaquaticSounds.ENTITY_PUFFERFISH_DEFLATE, this.func_70599_aP(), this.func_70647_i());
                    this.setPuffState(0);
                }
            }
        }
        super.func_70071_h_();
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        int puffState = this.getPuffState();
        if (puffState > 0) {
            for (EntityLivingBase entity : this.field_70170_p.func_175647_a(EntityLivingBase.class, this.func_174813_aQ().func_186662_g(0.3), this::canAttackEntity)) {
                if (!entity.func_70089_S()) continue;
                this.attack(entity, puffState);
            }
        }
    }

    protected void attack(@Nonnull EntityLivingBase entity, int puffState) {
        if (entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)(puffState + 1))) {
            entity.func_70690_d(new PotionEffect(MobEffects.field_76436_u, puffState * 60));
            this.func_184185_a(SubaquaticSounds.ENTITY_PUFFERFISH_STING, 1.0f, 1.0f);
            for (PotionEffect effect : this.func_70651_bq()) {
                entity.func_70690_d(new PotionEffect(effect.func_188419_a(), puffState * 60, effect.func_76458_c()));
            }
        }
    }

    public void func_70100_b_(@Nonnull EntityPlayer player) {
        int puffState;
        if (player instanceof EntityPlayerMP && this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL && (puffState = this.getPuffState()) > 0 && player.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)(puffState + 1))) {
            player.func_70690_d(new PotionEffect(MobEffects.field_76436_u, puffState * 60));
            ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new SPacketSoundEffect(SubaquaticSounds.ENTITY_PUFFERFISH_STING, SoundCategory.NEUTRAL, player.field_70165_t, player.field_70163_u, player.field_70161_v, 1.0f, 1.0f));
        }
    }

    @Nonnull
    protected ResourceLocation func_184647_J() {
        return new ResourceLocation("subaquatic", "entities/pufferfish");
    }

    @Nonnull
    protected SoundEvent func_184615_bR() {
        return SubaquaticSounds.ENTITY_PUFFERFISH_DEATH;
    }

    @Override
    @Nonnull
    protected SoundEvent getFlopSound() {
        return SubaquaticSounds.ENTITY_PUFFERFISH_FLOP;
    }

    @Nonnull
    protected SoundEvent func_184601_bQ(@Nonnull DamageSource source) {
        return SubaquaticSounds.ENTITY_PUFFERFISH_HURT;
    }

    @Override
    public boolean hasNoGroup() {
        return true;
    }

    @Override
    @Nonnull
    public AbstractEntityBucketHandler createFishBucketHandler() {
        if (this.getClass() != EntityPufferfish.class) {
            throw new IllegalStateException("No bucket handler defined for entity class: " + this.getClass());
        }
        return new EntityBucketHandlerPufferfish();
    }

    @Override
    public void postSetHandlerEntityNBT(@Nonnull AbstractEntityBucketHandler handler) {
        handler.entityNbt.func_74768_a("PuffState", 0);
    }
}

