/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.subaquatic.mod.common.entity.living;

import git.jbredwards.subaquatic.mod.common.config.SubaquaticTropicalFishConfig;
import git.jbredwards.subaquatic.mod.common.entity.living.AbstractGroupFish;
import git.jbredwards.subaquatic.mod.common.entity.util.TropicalFishData;
import git.jbredwards.subaquatic.mod.common.entity.util.fish_bucket.AbstractEntityBucketHandler;
import git.jbredwards.subaquatic.mod.common.entity.util.fish_bucket.EntityBucketHandlerTropicalFish;
import git.jbredwards.subaquatic.mod.common.init.SubaquaticDataSerializers;
import git.jbredwards.subaquatic.mod.common.init.SubaquaticSounds;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;

public class EntityTropicalFish
extends AbstractGroupFish {
    @Nonnull
    private static final DataParameter<TropicalFishData> VARIANT = EntityDataManager.func_187226_a(EntityTropicalFish.class, SubaquaticDataSerializers.TROPICAL_FISH_DATA);

    public EntityTropicalFish(@Nonnull World worldIn) {
        super(worldIn);
        this.func_70105_a(0.5f, 0.4f);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(VARIANT, (Object)TropicalFishData.DEFAULT);
    }

    @Nonnull
    public TropicalFishData getVariant() {
        return (TropicalFishData)this.field_70180_af.func_187225_a(VARIANT);
    }

    public void setVariant(@Nonnull TropicalFishData variant) {
        this.field_70180_af.func_187227_b(VARIANT, (Object)variant);
    }

    @Nonnull
    public TropicalFishData getRandomVariant() {
        if ((double)this.field_70146_Z.nextFloat() < 0.1) {
            return TropicalFishData.deserialize(this.field_70146_Z.nextInt(2) | this.field_70146_Z.nextInt(6) << 8 | this.field_70146_Z.nextInt(15) << 16 | this.field_70146_Z.nextInt(15) << 24);
        }
        return SubaquaticTropicalFishConfig.DEFAULT_TYPES.isEmpty() ? TropicalFishData.DEFAULT : SubaquaticTropicalFishConfig.DEFAULT_TYPES.get(this.field_70146_Z.nextInt(SubaquaticTropicalFishConfig.DEFAULT_TYPES.size()));
    }

    @Override
    public void func_70014_b(@Nonnull NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("Variant", this.getVariant().serialize());
    }

    @Override
    public void func_70037_a(@Nonnull NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_150297_b("VariantData", 10)) {
            NBTTagCompound variantData = compound.func_74775_l("VariantData");
            this.setVariant(new TropicalFishData(variantData.func_74762_e("PrimaryShape"), EnumDyeColor.func_176764_b((int)variantData.func_74762_e("PrimaryColor")), variantData.func_74762_e("SecondaryShape"), EnumDyeColor.func_176764_b((int)variantData.func_74762_e("SecondaryColor"))));
        } else {
            this.setVariant(TropicalFishData.deserialize(compound.func_74762_e("Variant")));
        }
    }

    @Override
    @Nonnull
    public AbstractEntityBucketHandler createFishBucketHandler() {
        if (this.getClass() != EntityTropicalFish.class) {
            throw new IllegalStateException("No bucket handler defined for entity class: " + this.getClass());
        }
        return new EntityBucketHandlerTropicalFish();
    }

    @Override
    public void postSetHandlerEntityNBT(@Nonnull AbstractEntityBucketHandler handler) {
        ((EntityBucketHandlerTropicalFish)handler).fishData = this.getVariant();
    }

    @Override
    public void onCreatedByBucket(@Nonnull ItemStack bucket, @Nonnull AbstractEntityBucketHandler handler) {
        TropicalFishData bucketData = ((EntityBucketHandlerTropicalFish)handler).fishData;
        this.setVariant(bucketData == null ? this.getRandomVariant() : bucketData);
    }

    @Nonnull
    protected ResourceLocation func_184647_J() {
        return new ResourceLocation("subaquatic", "entities/tropical_fish");
    }

    @Nonnull
    protected SoundEvent func_184615_bR() {
        return SubaquaticSounds.ENTITY_TROPICAL_FISH_DEATH;
    }

    @Override
    @Nonnull
    protected SoundEvent getFlopSound() {
        return SubaquaticSounds.ENTITY_TROPICAL_FISH_FLOP;
    }

    @Nonnull
    protected SoundEvent func_184601_bQ(@Nonnull DamageSource source) {
        return SubaquaticSounds.ENTITY_TROPICAL_FISH_HURT;
    }

    @Override
    @Nullable
    public IEntityLivingData func_180482_a(@Nonnull DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        TropicalFishData tropicalFishData;
        if ((livingdata = super.func_180482_a(difficulty, livingdata)) instanceof GroupData) {
            tropicalFishData = ((GroupData)livingdata).data;
        } else {
            tropicalFishData = this.getRandomVariant();
            livingdata = new GroupData(this, tropicalFishData);
        }
        this.setVariant(tropicalFishData);
        return livingdata;
    }

    public static class GroupData
    extends AbstractGroupFish.GroupData {
        @Nonnull
        public final TropicalFishData data;

        public GroupData(@Nonnull AbstractGroupFish fishIn, @Nonnull TropicalFishData dataIn) {
            super(fishIn);
            this.data = dataIn;
        }
    }
}

