/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.subaquatic.mod.common.entity.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;

@Immutable
public class FrogData
implements Comparable<FrogData> {
    @Nonnull
    public static final LinkedList<FrogData> VARIANTS = new LinkedList();
    @Nonnull
    public final String name;
    @Nonnull
    public final ResourceLocation texture;
    @Nonnull
    public final Set<Biome> validBiomes;

    public FrogData(@Nonnull String nameIn, @Nonnull ResourceLocation textureIn, @Nonnull Set<Biome> validBiomesIn) {
        this.name = nameIn;
        this.texture = textureIn;
        this.validBiomes = Collections.unmodifiableSet(validBiomesIn);
    }

    @Override
    public int compareTo(@Nonnull FrogData o) {
        return this.name.compareTo(o.name);
    }

    @Nonnull
    public static FrogData getFromName(@Nonnull String name) {
        for (FrogData data : VARIANTS) {
            if (!data.name.equals(name)) continue;
            return data;
        }
        return VARIANTS.getFirst();
    }

    @Nonnull
    public static FrogData getRandomForBiome(@Nonnull Biome biome, @Nonnull Random rand) {
        ArrayList<FrogData> shuffled = new ArrayList<FrogData>(VARIANTS);
        Collections.shuffle(shuffled, rand);
        for (FrogData data : shuffled) {
            if (!data.validBiomes.contains(biome)) continue;
            return data;
        }
        return VARIANTS.getFirst();
    }
}

