/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.subaquatic.mod.common.entity.util;

import java.util.function.BiFunction;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import net.minecraft.item.EnumDyeColor;

@Immutable
public final class TropicalFishData
implements Comparable<TropicalFishData> {
    @Nonnull
    public static final TropicalFishData DEFAULT = new TropicalFishData(0, EnumDyeColor.ORANGE, 0, EnumDyeColor.WHITE);
    @Nonnull
    public final EnumDyeColor primaryColor;
    @Nonnull
    public final EnumDyeColor secondaryColor;
    public final int primaryShape;
    public final int secondaryShape;

    public TropicalFishData(int primaryShapeIn, @Nonnull EnumDyeColor primaryColorIn, int secondaryShapeIn, @Nonnull EnumDyeColor secondaryColorIn) {
        this.primaryShape = primaryShapeIn;
        this.primaryColor = primaryColorIn;
        this.secondaryShape = secondaryShapeIn;
        this.secondaryColor = secondaryColorIn;
    }

    @Nonnull
    public static TropicalFishData deserialize(int serialized) {
        return new TropicalFishData(serialized & 0xFF, EnumDyeColor.func_176764_b((int)(serialized >>> 16 & 0xFF)), serialized >>> 8 & 0xFF, EnumDyeColor.func_176764_b((int)(serialized >>> 24 & 0xFF)));
    }

    public int serialize() {
        return this.primaryShape & 0xFF | (this.secondaryShape & 0xFF) << 8 | (this.primaryColor.func_176765_a() & 0xFF) << 16 | (this.secondaryColor.func_176765_a() & 0xFF) << 24;
    }

    public boolean hasTranslation(@Nonnull Predicate<String> translator) {
        return translator.test("tooltip.subaquatic.fish_bucket.tropical_fish.special_type." + this.serialize());
    }

    @Nonnull
    public String getTranslatedName(@Nonnull BiFunction<String, Object[], String> translator) {
        return translator.apply("tooltip.subaquatic.fish_bucket.tropical_fish.special_type." + this.serialize(), new Object[0]);
    }

    @Nonnull
    public String getTranslatedShape(@Nonnull BiFunction<String, Object[], String> translator) {
        return translator.apply("tooltip.subaquatic.fish_bucket.tropical_fish.type." + (this.primaryShape & 0xFF | (this.secondaryShape & 0xFF) << 8), new Object[0]);
    }

    @Nonnull
    public String getTranslatedColor(@Nonnull BiFunction<String, Object[], String> translator) {
        return translator.apply("tooltip.subaquatic.fish_bucket.tropical_fish.colors", new Object[]{translator.apply("color.subaquatic." + this.primaryColor.func_176762_d(), new Object[0]), translator.apply("color.subaquatic." + this.secondaryColor.func_176762_d(), new Object[0])});
    }

    public boolean equals(@Nullable Object o) {
        return o instanceof TropicalFishData && ((TropicalFishData)o).serialize() == this.serialize();
    }

    @Override
    public int compareTo(@Nonnull TropicalFishData o) {
        return Integer.compare(o.serialize(), this.serialize());
    }
}

