/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.subaquatic.mod.common.entity.util.fish_bucket;

import git.jbredwards.subaquatic.mod.client.item.model.BakedEntityBucketModel;
import git.jbredwards.subaquatic.mod.common.capability.IEntityBucket;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class AbstractEntityBucketHandler
implements INBTSerializable<NBTTagCompound> {
    @Nonnull
    public static final Map<String, Supplier<AbstractEntityBucketHandler>> BUCKET_HANDLERS = new HashMap<String, Supplier<AbstractEntityBucketHandler>>();
    public NBTTagCompound entityNbt;

    @Nonnull
    public abstract EntityEntry getEntityEntry();

    @Nullable
    public static AbstractEntityBucketHandler createFromNBT(@Nonnull NBTTagCompound nbt) {
        if (!nbt.func_150297_b("Entity", 8)) {
            return null;
        }
        AbstractEntityBucketHandler data = BUCKET_HANDLERS.get(nbt.func_74779_i("Entity")).get();
        data.deserializeNBT(nbt);
        return data;
    }

    @Nonnull
    public final NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("Entity", this.getEntityEntry().delegate.name().toString());
        nbt.func_74782_a("FishNBT", (NBTBase)this.entityNbt);
        this.writeToNBT(nbt);
        return nbt;
    }

    public final void deserializeNBT(@Nonnull NBTTagCompound nbt) {
        this.entityNbt = nbt.func_74775_l("FishNBT");
        this.readFromNBT(nbt);
    }

    protected void writeToNBT(@Nonnull NBTTagCompound nbt) {
    }

    protected void readFromNBT(@Nonnull NBTTagCompound nbt) {
    }

    @Nonnull
    public ItemStack createNewStack(@Nonnull ItemStack bucket) {
        return this.applyEntry(bucket, Objects.requireNonNull(IEntityBucket.get((ICapabilityProvider)bucket)));
    }

    public void getSubTypes(@Nonnull List<ItemStack> items, @Nonnull ItemStack parentBucket) {
        items.add(this.createNewStack(parentBucket.func_77946_l()));
    }

    @Nonnull
    protected final ItemStack applyEntry(@Nonnull ItemStack bucket, @Nonnull IEntityBucket cap) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("id", this.getEntityEntry().delegate.name().toString());
        this.entityNbt = nbt;
        cap.setHandler(this);
        return bucket;
    }

    @Nonnull
    protected ResourceLocation getSpriteForRender() {
        return new ResourceLocation("subaquatic", "items/fish_bucket_overlays/missing");
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public List<BakedQuad> getRenderQuads() {
        return Collections.unmodifiableList(BakedEntityBucketModel.getQuadsForSprite(this.getSpriteForRender(), 3));
    }

    @SideOnly(value=Side.CLIENT)
    public void registerSprites(@Nonnull TextureMap map) {
        map.func_174942_a(this.getSpriteForRender());
    }

    @SideOnly(value=Side.CLIENT)
    public void handleTooltip(@Nonnull List<String> tooltip, @Nonnull ItemStack bucket, @Nonnull ITooltipFlag flag) {
        tooltip.add(1, I18n.func_135052_a((String)"tooltip.subaquatic.fish_bucket", (Object[])new Object[]{I18n.func_135052_a((String)("entity." + this.getEntityEntry().getName() + ".name"), (Object[])new Object[0])}));
    }

    @SideOnly(value=Side.CLIENT)
    public int colorMultiplier(@Nonnull ItemStack bucket, int tintIndex) {
        return -1;
    }
}

