/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.subaquatic.mod.common.entity.util.fish_bucket;

import com.google.common.collect.ImmutableList;
import git.jbredwards.subaquatic.mod.client.item.model.BakedEntityBucketModel;
import git.jbredwards.subaquatic.mod.client.texture.MaskTextureAtlasSprite;
import git.jbredwards.subaquatic.mod.common.capability.IEntityBucket;
import git.jbredwards.subaquatic.mod.common.config.SubaquaticTropicalFishConfig;
import git.jbredwards.subaquatic.mod.common.entity.util.TropicalFishData;
import git.jbredwards.subaquatic.mod.common.entity.util.fish_bucket.AbstractEntityBucketHandler;
import git.jbredwards.subaquatic.mod.common.init.SubaquaticEntities;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityBucketHandlerTropicalFish
extends AbstractEntityBucketHandler {
    @Nullable
    public TropicalFishData fishData;

    @Override
    @Nonnull
    public EntityEntry getEntityEntry() {
        return SubaquaticEntities.TROPICAL_FISH;
    }

    @Override
    protected void writeToNBT(@Nonnull NBTTagCompound nbt) {
        if (this.fishData != null) {
            nbt.func_74768_a("Variant", this.fishData.serialize());
        }
    }

    @Override
    protected void readFromNBT(@Nonnull NBTTagCompound nbt) {
        if (nbt.func_150297_b("Variant", 3)) {
            this.fishData = TropicalFishData.deserialize(nbt.func_74762_e("Variant"));
        }
    }

    @Override
    public void getSubTypes(@Nonnull List<ItemStack> items, @Nonnull ItemStack parentBucket) {
        SubaquaticTropicalFishConfig.DEFAULT_TYPES.forEach(data -> {
            EntityBucketHandlerTropicalFish handler = new EntityBucketHandlerTropicalFish();
            handler.fishData = data;
            ItemStack bucket = parentBucket.func_77946_l();
            items.add(handler.applyEntry(bucket, Objects.requireNonNull(IEntityBucket.get((ICapabilityProvider)bucket))));
        });
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerSprites(@Nonnull TextureMap map) {
        IntOpenHashSet primaryShapes = new IntOpenHashSet();
        IntOpenHashSet secondaryShapes = new IntOpenHashSet();
        primaryShapes.addAll(Arrays.asList(0, 1));
        secondaryShapes.addAll(Arrays.asList(0, 1, 2, 3, 4, 5));
        SubaquaticTropicalFishConfig.DEFAULT_TYPES.forEach(arg_0 -> EntityBucketHandlerTropicalFish.lambda$registerSprites$1((IntSet)primaryShapes, (IntSet)secondaryShapes, arg_0));
        primaryShapes.forEach(arg_0 -> EntityBucketHandlerTropicalFish.lambda$registerSprites$3((IntSet)secondaryShapes, map, arg_0));
        super.registerSprites(map);
    }

    @Override
    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public List<BakedQuad> getRenderQuads() {
        if (this.fishData != null) {
            String texture = "items/fish_bucket_overlays/tropical_" + this.fishData.primaryShape + "_pattern_" + this.fishData.secondaryShape;
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.addAll(BakedEntityBucketModel.getQuadsForSprite(new ResourceLocation("subaquatic", texture + "_base"), 3));
            builder.addAll(BakedEntityBucketModel.getQuadsForSprite(new ResourceLocation("subaquatic", texture), 4));
            return builder.build();
        }
        return super.getRenderQuads();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleTooltip(@Nonnull List<String> tooltip, @Nonnull ItemStack bucket, @Nonnull ITooltipFlag flag) {
        if (this.fishData != null) {
            if (this.fishData.hasTranslation(I18n::func_188566_a)) {
                tooltip.add(1, this.fishData.getTranslatedName(I18n::func_135052_a));
            } else {
                LinkedList<String> fallback = new LinkedList<String>();
                fallback.add(this.fishData.getTranslatedShape(I18n::func_135052_a));
                fallback.add(this.fishData.getTranslatedColor(I18n::func_135052_a));
                tooltip.addAll(1, fallback);
            }
        } else {
            tooltip.add(1, I18n.func_135052_a((String)"tooltip.subaquatic.fish_bucket.tropical_fish.missing", (Object[])new Object[0]));
        }
        super.handleTooltip(tooltip, bucket, flag);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int colorMultiplier(@Nonnull ItemStack bucket, int tintIndex) {
        if (this.fishData == null) {
            return -1;
        }
        switch (tintIndex) {
            case 3: {
                return this.fishData.primaryColor.func_193350_e();
            }
            case 4: {
                return this.fishData.secondaryColor.func_193350_e();
            }
        }
        return -1;
    }

    @Override
    @Nonnull
    public ItemStack createNewStack(@Nonnull ItemStack bucket) {
        IEntityBucket cap = IEntityBucket.get((ICapabilityProvider)bucket);
        assert (cap != null);
        this.fishData = TropicalFishData.DEFAULT;
        return this.applyEntry(bucket, cap);
    }

    @Nonnull
    public ItemStack createNewStackRandom(@Nonnull ItemStack bucket, @Nonnull Random random) {
        IEntityBucket cap = IEntityBucket.get((ICapabilityProvider)bucket);
        assert (cap != null);
        this.fishData = !SubaquaticTropicalFishConfig.DEFAULT_TYPES.isEmpty() ? SubaquaticTropicalFishConfig.DEFAULT_TYPES.get(random.nextInt(SubaquaticTropicalFishConfig.DEFAULT_TYPES.size())) : TropicalFishData.DEFAULT;
        return this.applyEntry(bucket, cap);
    }

    @Nonnull
    public ItemStack createNewStackTrueRandom(@Nonnull ItemStack bucket, @Nonnull Random random) {
        IEntityBucket cap = IEntityBucket.get((ICapabilityProvider)bucket);
        assert (cap != null);
        this.fishData = TropicalFishData.deserialize(random.nextInt(2) | random.nextInt(6) << 8 | random.nextInt(15) << 16 | random.nextInt(15) << 24);
        return this.applyEntry(bucket, cap);
    }

    private static /* synthetic */ void lambda$registerSprites$3(IntSet secondaryShapes, TextureMap map, Integer primaryShape) {
        String base = "items/fish_bucket_overlays/tropical_" + primaryShape;
        ResourceLocation baseLocation = new ResourceLocation("subaquatic", base);
        secondaryShapes.forEach(secondaryShape -> {
            ResourceLocation maskLocation = new ResourceLocation("subaquatic", base + "_pattern_" + secondaryShape);
            map.setTextureEntry((TextureAtlasSprite)new MaskTextureAtlasSprite(baseLocation, maskLocation));
        });
    }

    private static /* synthetic */ void lambda$registerSprites$1(IntSet primaryShapes, IntSet secondaryShapes, TropicalFishData type) {
        primaryShapes.add(type.primaryShape);
        secondaryShapes.add(type.secondaryShape);
    }
}

