/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.subaquatic.mod.common.entity.util.fish_bucket;

import git.jbredwards.subaquatic.mod.common.capability.IEntityBucket;
import git.jbredwards.subaquatic.mod.common.entity.util.fish_bucket.AbstractEntityBucketHandler;
import git.jbredwards.subaquatic.mod.common.init.SubaquaticSounds;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemMonsterPlacer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.ItemHandlerHelper;

public interface IBucketableEntity {
    public boolean canBucket();

    public boolean isFromBucket();

    public void setFromBucket(boolean var1);

    @Nonnull
    public AbstractEntityBucketHandler createFishBucketHandler();

    default public void postSetHandlerEntityNBT(@Nonnull AbstractEntityBucketHandler handler) {
    }

    default public boolean tryCaptureEntity(@Nonnull EntityPlayer player, @Nonnull EnumHand hand) {
        ItemStack held = player.func_184586_b(hand);
        ItemStack fishBucket = this.tryCaptureToStack(held);
        if (!fishBucket.func_190926_b()) {
            if (!player.func_184812_l_() && held.func_190916_E() == 1) {
                player.func_184611_a(hand, fishBucket);
            } else {
                ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)fishBucket);
                if (!player.func_184812_l_()) {
                    held.func_190918_g(1);
                }
            }
            ((Entity)this).func_184185_a(this.getBucketFillSound(), 1.0f, 1.0f);
            ((Entity)this).func_70106_y();
            return true;
        }
        return false;
    }

    @Nonnull
    default public ItemStack tryCaptureToStack(@Nonnull ItemStack stack) {
        ItemStack fishBucket;
        IEntityBucket cap;
        Entity entity = (Entity)this;
        if (entity.func_70089_S() && IEntityBucket.canStackHoldEntity(stack) && this.canBucket() && (cap = IEntityBucket.get((ICapabilityProvider)(fishBucket = ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1)))) != null && cap.getHandler() == null) {
            if (entity.func_145818_k_()) {
                fishBucket.func_151001_c(entity.func_95999_t());
            }
            AbstractEntityBucketHandler handler = this.createFishBucketHandler();
            handler.entityNbt = entity.serializeNBT();
            this.postSetHandlerEntityNBT(handler);
            cap.setHandler(handler);
            return fishBucket;
        }
        return ItemStack.field_190927_a;
    }

    default public void onCreatedByBucket(@Nonnull ItemStack bucket, @Nonnull AbstractEntityBucketHandler handler) {
    }

    public static void placeCapturedEntity(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull ItemStack bucket, @Nullable AbstractEntityBucketHandler data) {
        Entity fishEntity;
        if (data != null && !world.field_72995_K && (fishEntity = EntityList.func_75615_a((NBTTagCompound)data.entityNbt, (World)world)) != null) {
            double yOffset = ((ItemMonsterPlacer)Items.field_151063_bx).func_190909_a(world, pos);
            fishEntity.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + yOffset, (double)pos.func_177952_p() + 0.5);
            fishEntity.func_184221_a(MathHelper.func_188210_a());
            if (bucket.func_82837_s()) {
                fishEntity.func_96094_a(bucket.func_82833_r());
            }
            if (fishEntity instanceof IBucketableEntity) {
                ((IBucketableEntity)fishEntity).setFromBucket(true);
                ((IBucketableEntity)fishEntity).onCreatedByBucket(bucket, data);
            }
            world.func_72838_d(fishEntity);
        }
    }

    @Nonnull
    default public SoundEvent getBucketFillSound() {
        return SubaquaticSounds.BUCKET_FILL_FISH;
    }
}

