/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.subaquatic.mod.common.init;

import git.jbredwards.subaquatic.mod.common.entity.datasync.DataSerializerGeneric;
import git.jbredwards.subaquatic.mod.common.entity.util.FrogData;
import git.jbredwards.subaquatic.mod.common.entity.util.TropicalFishData;
import java.util.LinkedList;
import java.util.List;
import java.util.OptionalInt;
import javax.annotation.Nonnull;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraftforge.registries.DataSerializerEntry;

public final class SubaquaticDataSerializers {
    @Nonnull
    public static final List<DataSerializerEntry> INIT = new LinkedList<DataSerializerEntry>();
    @Nonnull
    public static final DataSerializer<TropicalFishData> TROPICAL_FISH_DATA = SubaquaticDataSerializers.register("tropical_fish_data", new DataSerializerGeneric<TropicalFishData>((buf, value) -> buf.func_150787_b(value.serialize()), buf -> TropicalFishData.deserialize(buf.func_150792_a())));
    @Nonnull
    public static final DataSerializer<OptionalInt> OPTIONAL_INT = SubaquaticDataSerializers.register("optional_int", new DataSerializerGeneric<OptionalInt>((buf, value) -> {
        buf.writeBoolean(value.isPresent());
        if (value.isPresent()) {
            buf.func_150787_b(value.getAsInt());
        }
    }, buf -> buf.readBoolean() ? OptionalInt.of(buf.func_150792_a()) : OptionalInt.empty()));
    @Nonnull
    public static final DataSerializer<FrogData> FROG_DATA = SubaquaticDataSerializers.register("frog_data", new DataSerializerGeneric<FrogData>((buf, value) -> buf.func_180714_a(value.name), buf -> FrogData.getFromName(buf.func_150789_c(Short.MAX_VALUE))));

    @Nonnull
    public static <T extends DataSerializer<?>> T register(@Nonnull String name, @Nonnull T serializer) {
        INIT.add((DataSerializerEntry)new DataSerializerEntry(serializer).setRegistryName("subaquatic", name));
        return serializer;
    }
}

