/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.subaquatic.mod.common.init;

import git.jbredwards.subaquatic.mod.common.entity.item.EntityBoatChest;
import git.jbredwards.subaquatic.mod.common.entity.item.EntityBoatEnderChest;
import git.jbredwards.subaquatic.mod.common.entity.item.EntityBoatFurnace;
import git.jbredwards.subaquatic.mod.common.entity.item.EntityBoatWorkbench;
import git.jbredwards.subaquatic.mod.common.entity.item.EntityMinecartEnderChest;
import git.jbredwards.subaquatic.mod.common.entity.item.EntityMinecartWorkbench;
import git.jbredwards.subaquatic.mod.common.entity.living.EntityCod;
import git.jbredwards.subaquatic.mod.common.entity.living.EntityFish;
import git.jbredwards.subaquatic.mod.common.entity.living.EntityPufferfish;
import git.jbredwards.subaquatic.mod.common.entity.living.EntitySalmon;
import git.jbredwards.subaquatic.mod.common.entity.living.EntityTropicalFish;
import git.jbredwards.subaquatic.mod.common.entity.living.EntityWaterCreature;
import git.jbredwards.subaquatic.mod.common.entity.util.fish_bucket.AbstractEntityBucketHandler;
import git.jbredwards.subaquatic.mod.common.entity.util.fish_bucket.EntityBucketHandlerCod;
import git.jbredwards.subaquatic.mod.common.entity.util.fish_bucket.EntityBucketHandlerFish;
import git.jbredwards.subaquatic.mod.common.entity.util.fish_bucket.EntityBucketHandlerPufferfish;
import git.jbredwards.subaquatic.mod.common.entity.util.fish_bucket.EntityBucketHandlerSalmon;
import git.jbredwards.subaquatic.mod.common.entity.util.fish_bucket.EntityBucketHandlerTropicalFish;
import git.jbredwards.subaquatic.mod.common.init.SubaquaticBiomes;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.passive.EntityWaterMob;
import net.minecraft.init.Biomes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public final class SubaquaticEntities {
    @Nonnull
    public static final List<EntityEntry> INIT = new LinkedList<EntityEntry>();
    static int id = 0;
    @Nonnull
    public static final EntityEntry CHEST_BOAT = SubaquaticEntities.register("chest_boat", EntityEntryBuilder.create().tracker(80, 3, true).entity(EntityBoatChest.class).factory(EntityBoatChest::new));
    @Nonnull
    public static final EntityEntry ENDER_CHEST_BOAT = SubaquaticEntities.register("ender_chest_boat", EntityEntryBuilder.create().tracker(80, 3, true).entity(EntityBoatEnderChest.class).factory(EntityBoatEnderChest::new));
    @Nonnull
    public static final EntityEntry ENDER_CHEST_MINECART = SubaquaticEntities.register("ender_chest_minecart", EntityEntryBuilder.create().tracker(80, 3, true).entity(EntityMinecartEnderChest.class).factory(EntityMinecartEnderChest::new));
    @Nonnull
    public static final EntityEntry FURNACE_BOAT = SubaquaticEntities.register("furnace_boat", EntityEntryBuilder.create().tracker(80, 3, true).entity(EntityBoatFurnace.class).factory(EntityBoatFurnace::new));
    @Nonnull
    public static final EntityEntry CRAFTING_TABLE_BOAT = SubaquaticEntities.register("crafting_table_boat", EntityEntryBuilder.create().tracker(80, 3, true).entity(EntityBoatWorkbench.class).factory(EntityBoatWorkbench::new));
    @Nonnull
    public static final EntityEntry CRAFTING_TABLE_MINECART = SubaquaticEntities.register("crafting_table_minecart", EntityEntryBuilder.create().tracker(80, 3, true).entity(EntityMinecartWorkbench.class).factory(EntityMinecartWorkbench::new));
    @Nonnull
    public static final EntityEntry COD = SubaquaticEntities.register("cod", EntityEntryBuilder.create().tracker(80, 3, true).entity(EntityCod.class).factory(EntityCod::new).egg(12691306, 15058059).spawn(EnumCreatureType.WATER_CREATURE, 10, 3, 6, new Biome[]{Biomes.field_76771_b, Biomes.field_150575_M}).spawn(EnumCreatureType.WATER_CREATURE, 15, 3, 6, new Biome[]{SubaquaticBiomes.COLD_OCEAN, SubaquaticBiomes.DEEP_COLD_OCEAN, SubaquaticBiomes.LUKEWARM_OCEAN}).spawn(EnumCreatureType.WATER_CREATURE, 8, 3, 6, new Biome[]{SubaquaticBiomes.DEEP_LUKEWARM_OCEAN}));
    @Nonnull
    public static final EntityEntry SALMON = SubaquaticEntities.register("salmon", EntityEntryBuilder.create().tracker(80, 3, true).entity(EntitySalmon.class).factory(EntitySalmon::new).egg(10489616, 951412).spawn(EnumCreatureType.WATER_CREATURE, 5, 1, 5, new Biome[]{Biomes.field_76781_i, Biomes.field_76777_m}).spawn(EnumCreatureType.WATER_CREATURE, 15, 1, 5, new Biome[]{Biomes.field_76776_l, SubaquaticBiomes.DEEP_FROZEN_OCEAN, SubaquaticBiomes.COLD_OCEAN, SubaquaticBiomes.DEEP_COLD_OCEAN}));
    @Nonnull
    public static final EntityEntry TROPICAL_FISH = SubaquaticEntities.register("tropical_fish", EntityEntryBuilder.create().tracker(80, 3, true).entity(EntityTropicalFish.class).factory(EntityTropicalFish::new).egg(15690005, 0xFFF9EF).spawn(EnumCreatureType.WATER_CREATURE, 25, 8, 8, new Biome[]{SubaquaticBiomes.LUKEWARM_OCEAN, SubaquaticBiomes.DEEP_LUKEWARM_OCEAN, SubaquaticBiomes.WARM_OCEAN, SubaquaticBiomes.DEEP_WARM_OCEAN}));
    @Nonnull
    public static final EntityEntry PUFFERFISH = SubaquaticEntities.register("pufferfish", EntityEntryBuilder.create().tracker(80, 3, true).entity(EntityPufferfish.class).factory(EntityPufferfish::new).egg(16167425, 3654642).spawn(EnumCreatureType.WATER_CREATURE, 5, 1, 3, new Biome[]{SubaquaticBiomes.LUKEWARM_OCEAN, SubaquaticBiomes.DEEP_LUKEWARM_OCEAN}).spawn(EnumCreatureType.WATER_CREATURE, 15, 1, 3, new Biome[]{SubaquaticBiomes.WARM_OCEAN, SubaquaticBiomes.DEEP_WARM_OCEAN}));
    @Nonnull
    public static final EntityEntry FISH = SubaquaticEntities.register("fish", EntityEntryBuilder.create().tracker(80, 3, true).entity(EntityFish.class).factory(EntityFish::new).egg(7053203, 11386587));

    static void handleAdditionalEntityData() {
        INIT.forEach(entry -> {
            if (EntityWaterCreature.class.isAssignableFrom(entry.getEntityClass()) || EntityWaterMob.class.isAssignableFrom(entry.getEntityClass())) {
                EntitySpawnPlacementRegistry.setPlacementType((Class)entry.getEntityClass(), (EntityLiving.SpawnPlacementType)EntityLiving.SpawnPlacementType.IN_WATER);
            }
        });
        ForgeRegistries.BIOMES.forEach(biome -> biome.func_76747_a(EnumCreatureType.WATER_CREATURE).forEach(entry -> {
            if (entry.field_76300_b == EntitySquid.class) {
                entry.field_76301_c = 1;
                entry.field_76292_a = 2;
            }
        }));
        AbstractEntityBucketHandler.BUCKET_HANDLERS.put("subaquatic:fish", EntityBucketHandlerFish::new);
        AbstractEntityBucketHandler.BUCKET_HANDLERS.put("subaquatic:cod", EntityBucketHandlerCod::new);
        AbstractEntityBucketHandler.BUCKET_HANDLERS.put("subaquatic:salmon", EntityBucketHandlerSalmon::new);
        AbstractEntityBucketHandler.BUCKET_HANDLERS.put("subaquatic:pufferfish", EntityBucketHandlerPufferfish::new);
        AbstractEntityBucketHandler.BUCKET_HANDLERS.put("subaquatic:tropical_fish", EntityBucketHandlerTropicalFish::new);
    }

    @Nonnull
    static EntityEntry register(@Nonnull String name, @Nonnull EntityEntryBuilder<?> builder) {
        EntityEntry entry = builder.id(new ResourceLocation("subaquatic", name), id++).name("subaquatic." + name).build();
        INIT.add(entry);
        return entry;
    }
}

