/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.subaquatic.mod.common.init;

import git.jbredwards.subaquatic.mod.common.entity.util.villager.career.TradeForCoral;
import git.jbredwards.subaquatic.mod.common.entity.util.villager.career.TradeForEntityBucket;
import git.jbredwards.subaquatic.mod.common.entity.util.villager.career.TradeUtil;
import git.jbredwards.subaquatic.mod.common.entity.util.villager.career.VillagerCareerRandom;
import git.jbredwards.subaquatic.mod.common.entity.util.villager.profession.IProfessionSupplier;
import git.jbredwards.subaquatic.mod.common.entity.util.villager.profession.VillagerProfessionMarineBiologist;
import git.jbredwards.subaquatic.mod.common.init.SubaquaticItems;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraft.village.MerchantRecipe;
import net.minecraftforge.fml.common.registry.VillagerRegistry;

public final class SubaquaticProfessions {
    @Nonnull
    public static final List<VillagerRegistry.VillagerProfession> INIT = new LinkedList<VillagerRegistry.VillagerProfession>();
    @Nonnull
    public static final VillagerProfessionMarineBiologist MARINE_BIOLOGIST = SubaquaticProfessions.register("marine_biologist", VillagerProfessionMarineBiologist::new, career -> career.addTrade(1, new EntityVillager.ITradeList[]{TradeForEntityBucket.FISH_BUCKET, TradeUtil.newTrade(Items.field_151166_bC, 1, 1, (Item)SubaquaticItems.KELP, 1, 3), TradeUtil.newTrade(Items.field_151166_bC, 1, 1, (Item)SubaquaticItems.GLOW_LICHEN, 2, 3), TradeUtil.newTrade((Item)SubaquaticItems.DRIED_KELP_BLOCK, 3, 5, Items.field_151166_bC, 1, 1), TradeUtil.newTrade(Items.field_151166_bC, 1, 1, new ItemStack(Blocks.field_150392_bi), 1, 3), TradeUtil.newTrade(Items.field_151166_bC, 1, 1, (Item)SubaquaticItems.SEAGRASS, 3, 5)}).addTrade(2, new EntityVillager.ITradeList[]{TradeForCoral.CORAL_BLOCK, TradeForEntityBucket.FISH_BUCKET_SPAWNABLE, TradeUtil.newTrade(Items.field_151166_bC, 3, 3, Items.field_179562_cC, 5, 8), TradeUtil.newTrade(Items.field_151166_bC, 2, 2, (Item)SubaquaticItems.SEA_PICKLE, 1, 1), TradeUtil.newTrade(Items.field_151166_bC, 2, 2, Items.field_179562_cC, 5, 8), TradeUtil.or(TradeForCoral.CORAL_FAN, TradeForCoral.CORAL_FIN)}).addTrade(3, new EntityVillager.ITradeList[]{TradeForEntityBucket.TROPICAL_FISH_BUCKET, TradeUtil.newTrade(Items.field_151166_bC, 4, 5, Items.field_179563_cD, 5, 8), TradeUtil.newTrade((Item)SubaquaticItems.NAUTILUS_SHELL, 2, 4, Items.field_151166_bC, 1, 1), TradeUtil.newTrade(Items.field_151166_bC, 7, 10, (Item)SubaquaticItems.NAUTILUS_SHELL, 1, 1)}).addTrade(4, new EntityVillager.ITradeList[]{TradeForEntityBucket.TROPICAL_FISH_BUCKET_ANY, TradeUtil.newTrade(Items.field_151166_bC, 32, 40, new ItemStack(Blocks.field_150360_v), 1, 1), TradeUtil.of(random -> new MerchantRecipe(new ItemStack(Items.field_151166_bC, MathHelper.func_76136_a((Random)random, (int)20, (int)25)), new ItemStack(Items.field_151064_bs, 4), new ItemStack((Item)SubaquaticItems.FROGLIGHT, 1, random.nextInt(3))))}));

    static void handleAdditionalTrades() {
        VillagerRegistry.FARMER.getCareer(1).addTrade(2, new EntityVillager.ITradeList[]{TradeUtil.newTrade(Items.field_151100_aR, 12, 24, Items.field_151166_bC, 1, 1)});
    }

    @Nonnull
    static <T extends VillagerRegistry.VillagerProfession> T register(@Nonnull String name, @Nonnull IProfessionSupplier<T> supplier, @Nonnull Consumer<VillagerCareerRandom> consumer) {
        return (T)SubaquaticProfessions.registerMulti(name, supplier, profession -> consumer.accept(new VillagerCareerRandom((VillagerRegistry.VillagerProfession)profession, "subaquatic." + name, 2)));
    }

    @Nonnull
    static <T extends VillagerRegistry.VillagerProfession> T registerMulti(@Nonnull String name, @Nonnull IProfessionSupplier<T> supplier, @Nonnull Consumer<T> consumer) {
        T profession = supplier.get("subaquatic:" + name, "subaquatic:textures/entity/villager/" + name + ".png", "subaquatic:textures/entity/villager/" + name + "_zombie.png");
        INIT.add((VillagerRegistry.VillagerProfession)profession);
        consumer.accept(profession);
        return profession;
    }
}

