/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.subaquatic.mod.common.init;

import git.jbredwards.subaquatic.mod.common.config.SubaquaticBoatTypesConfig;
import git.jbredwards.subaquatic.mod.common.init.SubaquaticBlocks;
import git.jbredwards.subaquatic.mod.common.init.SubaquaticItems;
import git.jbredwards.subaquatic.mod.common.item.ItemBoatContainer;
import java.io.IOException;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.furnace.FurnaceFuelBurnTimeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreIngredient;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="subaquatic")
final class SubaquaticRecipes {
    SubaquaticRecipes() {
    }

    @SubscribeEvent
    static void registerRecipes(@Nonnull RegistryEvent.Register<IRecipe> event) throws IOException {
        SubaquaticRecipes.registerCrafting((IForgeRegistry<IRecipe>)event.getRegistry());
        SubaquaticRecipes.registerSmelting();
    }

    static void registerCrafting(@Nonnull IForgeRegistry<IRecipe> registry) throws IOException {
        SubaquaticRecipes.registerCrafting(registry, "blue_ice", (IRecipe)new ShapedOreRecipe(null, (Item)SubaquaticItems.BLUE_ICE, new Object[]{"###", "###", "###", Character.valueOf('#'), Blocks.field_150403_cj}));
        SubaquaticRecipes.registerCrafting(registry, "brown_mushroom_block", (IRecipe)new ShapedOreRecipe(null, Blocks.field_150420_aW, new Object[]{"##", "##", Character.valueOf('#'), Blocks.field_150338_P}));
        SubaquaticRecipes.registerCrafting(registry, "brown_mushroom_hyphae", (IRecipe)new ShapedOreRecipe(null, new ItemStack(Blocks.field_150420_aW, 3, 2), new Object[]{"##", "##", Character.valueOf('#'), new ItemStack(Blocks.field_150420_aW, 1, 1)}));
        SubaquaticRecipes.registerCrafting(registry, "brown_mushroom_stem", (IRecipe)new ShapedOreRecipe(null, new ItemStack(Blocks.field_150420_aW, 1, 1), new Object[]{"##", "##", "##", Character.valueOf('#'), Blocks.field_150338_P}));
        SubaquaticRecipes.registerCrafting(registry, "crafting_table_minecart", (IRecipe)new ShapedOreRecipe(null, (Item)SubaquaticItems.CRAFTING_TABLE_MINECART, new Object[]{"A", "B", Character.valueOf('A'), Blocks.field_150462_ai, Character.valueOf('B'), Items.field_151143_au}));
        SubaquaticRecipes.registerCrafting(registry, "dried_kelp", (IRecipe)new ShapelessOreRecipe(null, new ItemStack((Item)SubaquaticItems.DRIED_KELP, 9), new Object[]{SubaquaticBlocks.DRIED_KELP_BLOCK}));
        SubaquaticRecipes.registerCrafting(registry, "dried_kelp_block", (IRecipe)new ShapedOreRecipe(null, (Item)SubaquaticItems.DRIED_KELP_BLOCK, new Object[]{"###", "###", "###", Character.valueOf('#'), "foodDriedKelp"}));
        SubaquaticRecipes.registerCrafting(registry, "ender_chest_minecart", (IRecipe)new ShapedOreRecipe(null, (Item)SubaquaticItems.ENDER_CHEST_MINECART, new Object[]{"A", "B", Character.valueOf('A'), Blocks.field_150477_bB, Character.valueOf('B'), Items.field_151143_au}));
        SubaquaticRecipes.registerCrafting(registry, "packed_ice", (IRecipe)new ShapedOreRecipe(null, Blocks.field_150403_cj, new Object[]{"###", "###", "###", Character.valueOf('#'), Blocks.field_150432_aD}));
        SubaquaticRecipes.registerCrafting(registry, "packed_mud", (IRecipe)new ShapelessOreRecipe(null, (Item)SubaquaticItems.PACKED_MUD, new Object[]{"mud", "cropWheat"}));
        SubaquaticRecipes.registerCrafting(registry, "packed_mud_bricks", (IRecipe)new ShapedOreRecipe(null, new ItemStack((Item)SubaquaticItems.PACKED_MUD_BRICKS, 4), new Object[]{"##", "##", Character.valueOf('#'), SubaquaticItems.PACKED_MUD}));
        SubaquaticRecipes.registerCrafting(registry, "packed_mud_bricks_slab", (IRecipe)new ShapedOreRecipe(null, new ItemStack((Item)SubaquaticItems.PACKED_MUD_BRICKS_SLAB, 6), new Object[]{"###", Character.valueOf('#'), SubaquaticItems.PACKED_MUD_BRICKS}));
        SubaquaticRecipes.registerCrafting(registry, "packed_mud_bricks_stairs", (IRecipe)new ShapedOreRecipe(null, new ItemStack((Item)SubaquaticItems.PACKED_MUD_BRICKS_STAIRS, 4), new Object[]{"#  ", "## ", "###", Character.valueOf('#'), SubaquaticItems.PACKED_MUD_BRICKS}));
        SubaquaticRecipes.registerCrafting(registry, "packed_mud_bricks_wall", (IRecipe)new ShapedOreRecipe(null, new ItemStack((Item)SubaquaticItems.PACKED_MUD_BRICKS_WALL, 6), new Object[]{"###", "###", Character.valueOf('#'), SubaquaticItems.PACKED_MUD_BRICKS}));
        SubaquaticRecipes.registerCrafting(registry, "pumpkin_pie", (IRecipe)new ShapelessOreRecipe(null, Items.field_151158_bO, new Object[]{"cropPumpkin", Items.field_151102_aT, "egg"}));
        SubaquaticRecipes.registerCrafting(registry, "pumpkin_seeds", (IRecipe)new ShapelessOreRecipe(null, new ItemStack(Items.field_151080_bb, 4), new Object[]{"cropPumpkin"}));
        SubaquaticRecipes.registerCrafting(registry, "red_mushroom_block", (IRecipe)new ShapedOreRecipe(null, Blocks.field_150419_aX, new Object[]{"##", "##", Character.valueOf('#'), Blocks.field_150337_Q}));
        SubaquaticRecipes.registerCrafting(registry, "red_mushroom_hyphae", (IRecipe)new ShapedOreRecipe(null, new ItemStack(Blocks.field_150419_aX, 3, 2), new Object[]{"##", "##", Character.valueOf('#'), new ItemStack(Blocks.field_150419_aX, 1, 1)}));
        SubaquaticRecipes.registerCrafting(registry, "red_mushroom_stem", (IRecipe)new ShapedOreRecipe(null, new ItemStack(Blocks.field_150419_aX, 1, 1), new Object[]{"##", "##", "##", Character.valueOf('#'), Blocks.field_150337_Q}));
        SubaquaticRecipes.registerCrafting(registry, "rooted_dirt", (IRecipe)new ShapelessOreRecipe(null, (Item)SubaquaticItems.ROOTED_DIRT, new Object[]{"dirt", SubaquaticItems.HANGING_ROOTS}));
        SubaquaticRecipes.registerCrafting(registry, "smooth_lapis_block_slab", (IRecipe)new ShapedOreRecipe(null, new ItemStack((Item)SubaquaticItems.SMOOTH_LAPIS_BLOCK_SLAB, 6), new Object[]{"###", Character.valueOf('#'), SubaquaticItems.SMOOTH_LAPIS_BLOCK}));
        SubaquaticRecipes.registerCrafting(registry, "smooth_lapis_block_stairs", (IRecipe)new ShapedOreRecipe(null, new ItemStack((Item)SubaquaticItems.SMOOTH_LAPIS_BLOCK_STAIRS, 4), new Object[]{"#  ", "## ", "###", Character.valueOf('#'), SubaquaticItems.SMOOTH_LAPIS_BLOCK}));
        SubaquaticRecipes.registerCrafting(registry, "smooth_quartz_block_slab", (IRecipe)new ShapedOreRecipe(null, new ItemStack((Item)SubaquaticItems.SMOOTH_QUARTZ_BLOCK_SLAB, 6), new Object[]{"###", Character.valueOf('#'), SubaquaticItems.SMOOTH_QUARTZ_BLOCK}));
        SubaquaticRecipes.registerCrafting(registry, "smooth_quartz_block_stairs", (IRecipe)new ShapedOreRecipe(null, new ItemStack((Item)SubaquaticItems.SMOOTH_QUARTZ_BLOCK_STAIRS, 4), new Object[]{"#  ", "## ", "###", Character.valueOf('#'), SubaquaticItems.SMOOTH_QUARTZ_BLOCK}));
        SubaquaticRecipes.registerCrafting(registry, "smooth_red_sandstone_slab", (IRecipe)new ShapedOreRecipe(null, new ItemStack((Item)SubaquaticItems.SMOOTH_RED_SANDSTONE_SLAB, 6), new Object[]{"###", Character.valueOf('#'), SubaquaticItems.SMOOTH_RED_SANDSTONE}));
        SubaquaticRecipes.registerCrafting(registry, "smooth_red_sandstone_stairs", (IRecipe)new ShapedOreRecipe(null, new ItemStack((Item)SubaquaticItems.SMOOTH_RED_SANDSTONE_STAIRS, 4), new Object[]{"#  ", "## ", "###", Character.valueOf('#'), SubaquaticItems.SMOOTH_RED_SANDSTONE}));
        SubaquaticRecipes.registerCrafting(registry, "smooth_sandstone_slab", (IRecipe)new ShapedOreRecipe(null, new ItemStack((Item)SubaquaticItems.SMOOTH_SANDSTONE_SLAB, 6), new Object[]{"###", Character.valueOf('#'), SubaquaticItems.SMOOTH_SANDSTONE}));
        SubaquaticRecipes.registerCrafting(registry, "smooth_sandstone_stairs", (IRecipe)new ShapedOreRecipe(null, new ItemStack((Item)SubaquaticItems.SMOOTH_SANDSTONE_STAIRS, 4), new Object[]{"#  ", "## ", "###", Character.valueOf('#'), SubaquaticItems.SMOOTH_SANDSTONE}));
        SubaquaticRecipes.registerCrafting(registry, "smooth_stone_stairs", (IRecipe)new ShapedOreRecipe(null, new ItemStack((Item)SubaquaticItems.SMOOTH_STONE_STAIRS, 4), new Object[]{"#  ", "## ", "###", Character.valueOf('#'), "stoneSmooth"}));
        SubaquaticBoatTypesConfig.buildBoatTypes();
        SubaquaticBoatTypesConfig.BOAT_TYPES.forEach(type -> {
            ResourceLocation typeName = type.boat.delegate.name();
            String recipeId = '/' + typeName.func_110624_b() + '/' + typeName.func_110623_a() + '/' + type.boatMeta;
            SubaquaticRecipes.registerCrafting(registry, "chest_boat" + recipeId, (IRecipe)new ShapedOreRecipe(null, ItemBoatContainer.createStackWithType((Item)SubaquaticItems.CHEST_BOAT, type), new Object[]{"C", "B", Character.valueOf('C'), Blocks.field_150486_ae, Character.valueOf('B'), new ItemStack(type.boat, 1, type.boatMeta)}));
            SubaquaticRecipes.registerCrafting(registry, "ender_chest_boat" + recipeId, (IRecipe)new ShapedOreRecipe(null, ItemBoatContainer.createStackWithType((Item)SubaquaticItems.ENDER_CHEST_BOAT, type), new Object[]{"C", "B", Character.valueOf('C'), Blocks.field_150477_bB, Character.valueOf('B'), new ItemStack(type.boat, 1, type.boatMeta)}));
            SubaquaticRecipes.registerCrafting(registry, "crafting_table_boat" + recipeId, (IRecipe)new ShapedOreRecipe(null, ItemBoatContainer.createStackWithType((Item)SubaquaticItems.CRAFTING_TABLE_BOAT, type), new Object[]{"C", "B", Character.valueOf('C'), Blocks.field_150462_ai, Character.valueOf('B'), new ItemStack(type.boat, 1, type.boatMeta)}));
            SubaquaticRecipes.registerCrafting(registry, "furnace_boat" + recipeId, (IRecipe)new ShapedOreRecipe(null, ItemBoatContainer.createStackWithType((Item)SubaquaticItems.FURNACE_BOAT, type), new Object[]{"C", "B", Character.valueOf('C'), Blocks.field_150460_al, Character.valueOf('B'), new ItemStack(type.boat, 1, type.boatMeta)}));
        });
        for (IRecipe recipe : new IRecipe[]{(IRecipe)registry.getValue(new ResourceLocation("comparator")), (IRecipe)registry.getValue(new ResourceLocation("repeater")), (IRecipe)registry.getValue(new ResourceLocation("stone_slab"))}) {
            if (!(recipe instanceof ShapedRecipes)) continue;
            ((ShapedRecipes)recipe).field_77574_d.replaceAll(ingredient -> ingredient.apply(new ItemStack(Blocks.field_150348_b)) ? new OreIngredient("stoneSmooth") : ingredient);
        }
    }

    static void registerCrafting(@Nonnull IForgeRegistry<IRecipe> registry, @Nonnull String id, @Nonnull IRecipe recipe) {
        registry.register((IForgeRegistryEntry)recipe.setRegistryName(new ResourceLocation("subaquatic", id)));
    }

    @SubscribeEvent
    static void registerFuels(@Nonnull FurnaceFuelBurnTimeEvent event) {
        if (event.getItemStack().func_77973_b() == SubaquaticItems.DRIED_KELP_BLOCK) {
            event.setBurnTime(4000);
        }
    }

    static void registerSmelting() {
        GameRegistry.addSmelting((Item)SubaquaticItems.COD, (ItemStack)new ItemStack((Item)SubaquaticItems.COOKED_COD), (float)0.35f);
        GameRegistry.addSmelting((Item)SubaquaticItems.KELP, (ItemStack)new ItemStack((Item)SubaquaticItems.DRIED_KELP), (float)0.1f);
        GameRegistry.addSmelting((Item)SubaquaticItems.SEA_PICKLE, (ItemStack)new ItemStack(Items.field_151100_aR, 1, 10), (float)0.1f);
        GameRegistry.addSmelting((Block)Blocks.field_150368_y, (ItemStack)new ItemStack((Item)SubaquaticItems.SMOOTH_LAPIS_BLOCK, 1, 0), (float)0.1f);
        GameRegistry.addSmelting((Block)Blocks.field_150371_ca, (ItemStack)new ItemStack((Item)SubaquaticItems.SMOOTH_QUARTZ_BLOCK, 1, 0), (float)0.1f);
        GameRegistry.addSmelting((Block)Blocks.field_180395_cM, (ItemStack)new ItemStack((Item)SubaquaticItems.SMOOTH_RED_SANDSTONE, 1, 0), (float)0.1f);
        GameRegistry.addSmelting((Block)Blocks.field_150322_A, (ItemStack)new ItemStack((Item)SubaquaticItems.SMOOTH_SANDSTONE, 1, 0), (float)0.1f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(Blocks.field_150348_b, 1, 0), (ItemStack)new ItemStack((Item)SubaquaticItems.SMOOTH_STONE, 1, 0), (float)0.1f);
        GameRegistry.addSmelting((ItemStack)new ItemStack((Item)SubaquaticItems.BRAIN_CORAL_BLOCK, 1, 0), (ItemStack)new ItemStack((Item)SubaquaticItems.BRAIN_CORAL_BLOCK, 1, 1), (float)0.1f);
        GameRegistry.addSmelting((ItemStack)new ItemStack((Item)SubaquaticItems.BRAIN_CORAL_FAN, 1, 0), (ItemStack)new ItemStack((Item)SubaquaticItems.BRAIN_CORAL_FAN, 1, 1), (float)0.1f);
        GameRegistry.addSmelting((ItemStack)new ItemStack((Item)SubaquaticItems.BRAIN_CORAL_FIN, 1, 0), (ItemStack)new ItemStack((Item)SubaquaticItems.BRAIN_CORAL_FIN, 1, 1), (float)0.1f);
        GameRegistry.addSmelting((ItemStack)new ItemStack((Item)SubaquaticItems.BUBBLE_CORAL_BLOCK, 1, 0), (ItemStack)new ItemStack((Item)SubaquaticItems.BUBBLE_CORAL_BLOCK, 1, 1), (float)0.1f);
        GameRegistry.addSmelting((ItemStack)new ItemStack((Item)SubaquaticItems.BUBBLE_CORAL_FAN, 1, 0), (ItemStack)new ItemStack((Item)SubaquaticItems.BUBBLE_CORAL_FAN, 1, 1), (float)0.1f);
        GameRegistry.addSmelting((ItemStack)new ItemStack((Item)SubaquaticItems.BUBBLE_CORAL_FIN, 1, 0), (ItemStack)new ItemStack((Item)SubaquaticItems.BUBBLE_CORAL_FIN, 1, 1), (float)0.1f);
        GameRegistry.addSmelting((ItemStack)new ItemStack((Item)SubaquaticItems.FIRE_CORAL_BLOCK, 1, 0), (ItemStack)new ItemStack((Item)SubaquaticItems.FIRE_CORAL_BLOCK, 1, 1), (float)0.1f);
        GameRegistry.addSmelting((ItemStack)new ItemStack((Item)SubaquaticItems.FIRE_CORAL_FAN, 1, 0), (ItemStack)new ItemStack((Item)SubaquaticItems.FIRE_CORAL_FAN, 1, 1), (float)0.1f);
        GameRegistry.addSmelting((ItemStack)new ItemStack((Item)SubaquaticItems.FIRE_CORAL_FIN, 1, 0), (ItemStack)new ItemStack((Item)SubaquaticItems.FIRE_CORAL_FIN, 1, 1), (float)0.1f);
        GameRegistry.addSmelting((ItemStack)new ItemStack((Item)SubaquaticItems.HORN_CORAL_BLOCK, 1, 0), (ItemStack)new ItemStack((Item)SubaquaticItems.HORN_CORAL_BLOCK, 1, 1), (float)0.1f);
        GameRegistry.addSmelting((ItemStack)new ItemStack((Item)SubaquaticItems.HORN_CORAL_FAN, 1, 0), (ItemStack)new ItemStack((Item)SubaquaticItems.HORN_CORAL_FAN, 1, 1), (float)0.1f);
        GameRegistry.addSmelting((ItemStack)new ItemStack((Item)SubaquaticItems.HORN_CORAL_FIN, 1, 0), (ItemStack)new ItemStack((Item)SubaquaticItems.HORN_CORAL_FIN, 1, 1), (float)0.1f);
        GameRegistry.addSmelting((ItemStack)new ItemStack((Item)SubaquaticItems.TUBE_CORAL_BLOCK, 1, 0), (ItemStack)new ItemStack((Item)SubaquaticItems.TUBE_CORAL_BLOCK, 1, 1), (float)0.1f);
        GameRegistry.addSmelting((ItemStack)new ItemStack((Item)SubaquaticItems.TUBE_CORAL_FAN, 1, 0), (ItemStack)new ItemStack((Item)SubaquaticItems.TUBE_CORAL_FAN, 1, 1), (float)0.1f);
        GameRegistry.addSmelting((ItemStack)new ItemStack((Item)SubaquaticItems.TUBE_CORAL_FIN, 1, 0), (ItemStack)new ItemStack((Item)SubaquaticItems.TUBE_CORAL_FIN, 1, 1), (float)0.1f);
    }
}

