/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.subaquatic.mod.common.item;

import git.jbredwards.fluidlogged_api.api.util.FluidloggedUtils;
import git.jbredwards.subaquatic.mod.common.capability.IBoatType;
import git.jbredwards.subaquatic.mod.common.capability.util.BoatType;
import git.jbredwards.subaquatic.mod.common.config.SubaquaticBoatTypesConfig;
import git.jbredwards.subaquatic.mod.common.entity.item.AbstractBoatContainer;
import git.jbredwards.subaquatic.mod.common.entity.util.PositionedEntitySupplier;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.dispenser.BehaviorDefaultDispenseItem;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBoat;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.items.ItemHandlerHelper;

public class ItemBoatContainer
extends ItemBoat {
    @Nonnull
    public final PositionedEntitySupplier<AbstractBoatContainer> boatSupplier;

    public ItemBoatContainer(@Nonnull PositionedEntitySupplier<AbstractBoatContainer> boatSupplierIn) {
        super(EntityBoat.Type.OAK);
        this.boatSupplier = boatSupplierIn;
        this.registerDispenserBehavior();
    }

    @Nonnull
    public static ItemStack createStackWithType(@Nonnull Item boat, @Nonnull BoatType type) {
        ItemStack stack = new ItemStack(boat);
        IBoatType cap = IBoatType.get((ICapabilityProvider)stack);
        if (cap != null) {
            cap.setType(type);
        }
        return stack;
    }

    protected void registerDispenserBehavior() {
        BlockDispenser.field_149943_a.func_82595_a((Object)this, (Object)new BehaviorDefaultDispenseItem(){

            @Nonnull
            protected ItemStack func_82487_b(@Nonnull IBlockSource source, @Nonnull ItemStack stack) {
                EnumFacing dispenserFacing = (EnumFacing)source.func_189992_e().func_177229_b((IProperty)BlockDispenser.field_176441_a);
                double x = source.func_82615_a() + (double)dispenserFacing.func_82601_c() * 1.125;
                double y = source.func_82617_b() + (double)dispenserFacing.func_96559_d() * 1.125;
                double z = source.func_82616_c() + (double)dispenserFacing.func_82599_e() * 1.125;
                BlockPos boatPos = source.func_180699_d().func_177972_a(dispenserFacing);
                Material material = source.func_82618_k().func_180495_p(boatPos).func_185904_a();
                double yOffset = 0.0;
                if (material == Material.field_151586_h) {
                    yOffset = 1.0;
                } else if (material != Material.field_151579_a || FluidloggedUtils.getFluidOrReal((IBlockAccess)source.func_82618_k(), (BlockPos)boatPos.func_177977_b()).func_185904_a() != Material.field_151586_h) {
                    return super.func_82487_b(source, stack);
                }
                AbstractBoatContainer boat = ItemBoatContainer.this.boatSupplier.newInstance(source.func_82618_k(), x, y + yOffset, z);
                boat.setContainerStack(ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1));
                boat.field_70177_z = dispenserFacing.func_185119_l();
                IBoatType boatCap = IBoatType.get((ICapabilityProvider)boat);
                IBoatType stackCap = IBoatType.get((ICapabilityProvider)stack);
                if (boatCap != null && stackCap != null) {
                    boatCap.setType(stackCap.getType());
                }
                source.func_82618_k().func_72838_d((Entity)boat);
                stack.func_190918_g(1);
                return stack;
            }
        });
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull World worldIn, @Nonnull EntityPlayer playerIn, @Nonnull EnumHand handIn) {
        ItemStack held = playerIn.func_184586_b(handIn);
        Vec3d eyeVec = playerIn.func_174824_e(1.0f);
        double reach = playerIn.func_110148_a(EntityPlayer.REACH_DISTANCE).func_111126_e();
        RayTraceResult trace = worldIn.func_72901_a(eyeVec, eyeVec.func_178787_e(playerIn.func_70040_Z().func_186678_a(reach)), true);
        if (trace == null || trace.field_72313_a != RayTraceResult.Type.BLOCK) {
            return new ActionResult(EnumActionResult.PASS, (Object)held);
        }
        boolean isOverWater = FluidloggedUtils.getFluidOrReal((IBlockAccess)worldIn, (BlockPos)trace.func_178782_a()).func_185904_a() == Material.field_151586_h;
        AbstractBoatContainer boat = this.boatSupplier.newInstance(worldIn, trace.field_72307_f.field_72450_a, isOverWater ? trace.field_72307_f.field_72448_b - 0.12 : trace.field_72307_f.field_72448_b, trace.field_72307_f.field_72449_c);
        if (boat.func_70046_E() == null) {
            return new ActionResult(EnumActionResult.PASS, (Object)held);
        }
        AxisAlignedBB collisionBox = boat.func_70046_E().func_186664_h(0.1);
        if (!worldIn.func_184144_a((Entity)boat, collisionBox).isEmpty()) {
            return new ActionResult(EnumActionResult.PASS, (Object)held);
        }
        boat.setContainerStack(ItemHandlerHelper.copyStackWithSize((ItemStack)held, (int)1));
        boat.field_70177_z = playerIn.field_70177_z;
        IBoatType boatCap = IBoatType.get((ICapabilityProvider)boat);
        IBoatType heldCap = IBoatType.get((ICapabilityProvider)held);
        if (boatCap != null && heldCap != null) {
            boatCap.setType(heldCap.getType());
        }
        if (!worldIn.field_72995_K) {
            worldIn.func_72838_d((Entity)boat);
        }
        if (!playerIn.func_184812_l_()) {
            held.func_190918_g(1);
        }
        playerIn.func_71029_a(StatList.func_188057_b((Item)this));
        return new ActionResult(EnumActionResult.SUCCESS, (Object)held);
    }

    @Nonnull
    public String func_77653_i(@Nonnull ItemStack stack) {
        IBoatType cap = IBoatType.get((ICapabilityProvider)stack);
        if (cap != null) {
            ItemStack typeStack = new ItemStack(cap.getType().boat, 1, cap.getType().boatMeta);
            String specialCase = String.format("%s.type.%s.name", stack.func_77977_a(), typeStack.func_77977_a());
            if (I18n.func_94522_b((String)specialCase)) {
                return I18n.func_74838_a((String)specialCase);
            }
            return typeStack.func_77973_b().func_77653_i(typeStack).replaceFirst(I18n.func_74838_a((String)this.getRegexTarget(stack)), I18n.func_74838_a((String)this.getRegexReplacement(stack)));
        }
        return super.func_77653_i(stack);
    }

    public int getItemBurnTime(@Nonnull ItemStack itemStack) {
        IBoatType cap = IBoatType.get((ICapabilityProvider)itemStack);
        if (cap == null) {
            return -1;
        }
        BoatType type = cap.getType();
        return ForgeEventFactory.getItemBurnTime((ItemStack)new ItemStack(type.boat, 1, type.boatMeta));
    }

    public void func_150895_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            SubaquaticBoatTypesConfig.BOAT_TYPES.forEach(type -> items.add((Object)ItemBoatContainer.createStackWithType((Item)this, type)));
        }
    }

    @Nonnull
    public String getRegexTarget(@Nonnull ItemStack stack) {
        return String.format("regex.%s.%s.target", this.delegate.name().func_110624_b(), this.delegate.name().func_110623_a());
    }

    @Nonnull
    public String getRegexReplacement(@Nonnull ItemStack stack) {
        return String.format("regex.%s.%s.replacement", this.delegate.name().func_110624_b(), this.delegate.name().func_110623_a());
    }
}

