/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.subaquatic.mod.common.item;

import git.jbredwards.subaquatic.mod.common.entity.util.PositionedEntitySupplier;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.dispenser.BehaviorDefaultDispenseItem;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ItemMinecartTypeless
extends Item {
    @Nonnull
    protected final PositionedEntitySupplier<EntityMinecart> minecartSupplier;

    public ItemMinecartTypeless(@Nonnull PositionedEntitySupplier<EntityMinecart> minecartSupplierIn) {
        this.minecartSupplier = minecartSupplierIn;
        this.func_77625_d(1);
        this.registerDispenserBehavior();
    }

    protected void registerDispenserBehavior() {
        BlockDispenser.field_149943_a.func_82595_a((Object)this, (Object)new BehaviorDefaultDispenseItem(){

            @Nonnull
            protected ItemStack func_82487_b(@Nonnull IBlockSource source, @Nonnull ItemStack stack) {
                double yOffset;
                EnumFacing dispenserFacing = (EnumFacing)source.func_189992_e().func_177229_b((IProperty)BlockDispenser.field_176441_a);
                World world = source.func_82618_k();
                double x = source.func_82615_a() + (double)dispenserFacing.func_82601_c() * 1.125;
                double y = Math.floor(source.func_82617_b()) + (double)dispenserFacing.func_96559_d();
                double z = source.func_82616_c() + (double)dispenserFacing.func_82599_e() * 1.125;
                BlockPos pos = source.func_180699_d().func_177972_a(dispenserFacing);
                IBlockState state = world.func_180495_p(pos);
                if (BlockRailBase.func_176563_d((IBlockState)state)) {
                    yOffset = (state.func_177230_c() instanceof BlockRailBase ? ((BlockRailBase)state.func_177230_c()).getRailDirection((IBlockAccess)world, pos, state, null) : BlockRailBase.EnumRailDirection.NORTH_SOUTH).func_177018_c() ? 0.6 : 0.1;
                } else {
                    IBlockState downState = world.func_180495_p(pos.func_177977_b());
                    if (state.func_185904_a() != Material.field_151579_a || !BlockRailBase.func_176563_d((IBlockState)downState)) {
                        this.func_82485_a(source);
                        this.func_82489_a(source, dispenserFacing);
                        return super.func_82487_b(source, stack);
                    }
                    yOffset = dispenserFacing != EnumFacing.DOWN && (downState.func_177230_c() instanceof BlockRailBase ? ((BlockRailBase)downState.func_177230_c()).getRailDirection((IBlockAccess)world, pos.func_177977_b(), downState, null) : BlockRailBase.EnumRailDirection.NORTH_SOUTH).func_177018_c() ? -0.4 : -0.9;
                }
                EntityMinecart minecart = ItemMinecartTypeless.this.minecartSupplier.newInstance(world, x, y + yOffset, z);
                if (stack.func_82837_s()) {
                    minecart.func_96094_a(stack.func_82833_r());
                }
                world.func_72838_d((Entity)minecart);
                stack.func_190918_g(1);
                return stack;
            }
        });
    }

    @Nonnull
    public EnumActionResult func_180614_a(@Nonnull EntityPlayer player, @Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull EnumHand hand, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ) {
        IBlockState state = worldIn.func_180495_p(pos);
        if (!BlockRailBase.func_176563_d((IBlockState)state)) {
            return EnumActionResult.FAIL;
        }
        ItemStack held = player.func_184586_b(hand);
        if (!worldIn.field_72995_K) {
            double yOffset = (state.func_177230_c() instanceof BlockRailBase ? ((BlockRailBase)state.func_177230_c()).getRailDirection((IBlockAccess)worldIn, pos, state, null) : BlockRailBase.EnumRailDirection.NORTH_SOUTH).func_177018_c() ? 0.5 : 0.0;
            EntityMinecart minecart = this.minecartSupplier.newInstance(worldIn, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + yOffset + 0.0625, (double)pos.func_177952_p() + 0.5);
            if (held.func_82837_s()) {
                minecart.func_96094_a(held.func_82833_r());
            }
            worldIn.func_72838_d((Entity)minecart);
        }
        held.func_190918_g(1);
        return EnumActionResult.SUCCESS;
    }
}

