/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.subaquatic.mod.common.item.block;

import git.jbredwards.subaquatic.mod.common.item.util.IBlockCluster;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemBlockCluster
extends ItemBlock {
    @Nonnull
    protected final IBlockCluster clusterHandler;

    public <T extends Block> ItemBlockCluster(@Nonnull T blockIn) {
        super(blockIn);
        this.clusterHandler = (IBlockCluster)blockIn;
    }

    @Nonnull
    public EnumActionResult func_180614_a(@Nonnull EntityPlayer player, @Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull EnumHand hand, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack held = player.func_184586_b(hand);
        BlockPos placedPos = pos;
        IBlockState state = worldIn.func_180495_p(placedPos);
        boolean canClusterWith = false;
        if (this.canPlaceOnSide(worldIn, placedPos, state, facing, held, player, false)) {
            canClusterWith = true;
        } else if (Block.func_149680_a((Block)state.func_177230_c(), (Block)this.field_150939_a) || !state.func_177230_c().func_176200_f((IBlockAccess)worldIn, placedPos)) {
            placedPos = placedPos.func_177972_a(facing);
            state = worldIn.func_180495_p(placedPos);
        }
        if (!canClusterWith && !placedPos.equals((Object)pos) && this.canPlaceOnSide(worldIn, placedPos, state, facing, held, player, false)) {
            canClusterWith = true;
        }
        if (canClusterWith ? !this.clusterHandler.clusterWith(this, held, player, worldIn, placedPos, facing, hitX, hitY, hitZ, state) : state.func_177230_c() == this.field_150939_a || !this.canPlaceOnSide(worldIn, placedPos, state, facing, held, player, true) || !this.clusterHandler.createInitialCluster(this, held, player, worldIn, placedPos, facing, hitX, hitY, hitZ, state)) {
            return EnumActionResult.FAIL;
        }
        IBlockState placedState = worldIn.func_180495_p(placedPos);
        SoundType sound = placedState.func_177230_c().getSoundType(placedState, worldIn, placedPos, (Entity)player);
        worldIn.func_184133_a(player, placedPos, sound.func_185841_e(), SoundCategory.BLOCKS, (sound.func_185843_a() + 1.0f) / 2.0f, sound.func_185847_b() * 0.8f);
        if (!player.func_184812_l_()) {
            held.func_190918_g(1);
        }
        return EnumActionResult.SUCCESS;
    }

    public boolean canPlaceOnSide(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull EnumFacing side, @Nonnull ItemStack held, @Nonnull EntityPlayer player, boolean skipCluster) {
        return (skipCluster || Block.func_149680_a((Block)state.func_177230_c(), (Block)this.field_150939_a) && this.clusterHandler.canClusterWith(held, player, world, pos, side, state)) && this.field_150939_a.func_176198_a(world, pos, side) && player.func_175151_a(pos.func_177972_a(EnumFacing.UP), EnumFacing.UP, held);
    }

    @SideOnly(value=Side.CLIENT)
    public final boolean func_179222_a(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull EnumFacing side, @Nonnull EntityPlayer player, @Nonnull ItemStack stack) {
        return true;
    }
}

