/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.subaquatic.mod.common.item.tab;

import git.jbredwards.subaquatic.mod.common.capability.IEntityBucket;
import git.jbredwards.subaquatic.mod.common.entity.util.fish_bucket.AbstractEntityBucketHandler;
import git.jbredwards.subaquatic.mod.common.init.SubaquaticEnchantments;
import git.jbredwards.subaquatic.mod.common.init.SubaquaticEntities;
import git.jbredwards.subaquatic.mod.common.init.SubaquaticItems;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainerCreative;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.init.Items;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemMonsterPlacer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class SubaquaticCreativeTab
extends CreativeTabs {
    public static final SubaquaticCreativeTab INSTANCE = new SubaquaticCreativeTab();

    SubaquaticCreativeTab() {
        super("subaquatic.tab");
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public ItemStack func_78016_d() {
        return SubaquaticItems.NAUTILUS_SHELL.func_190903_i();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_78018_a(@Nonnull NonNullList<ItemStack> items) {
        super.func_78018_a(items);
        items.addAll(SubaquaticCreativeTab.generateEntityBuckets());
        SubaquaticEntities.INIT.forEach(entry -> {
            if (entry.getEgg() != null) {
                ItemStack spawnEgg = new ItemStack(Items.field_151063_bx);
                ItemMonsterPlacer.func_185078_a((ItemStack)spawnEgg, (ResourceLocation)entry.getEgg().field_75613_a);
                items.add((Object)spawnEgg);
            }
        });
        SubaquaticEnchantments.INIT.forEach(ench -> {
            for (int lvl = ench.func_77319_d(); lvl <= ench.func_77325_b(); ++lvl) {
                items.add((Object)ItemEnchantedBook.func_92111_a((EnchantmentData)new EnchantmentData(ench, lvl)));
            }
        });
    }

    @Nonnull
    public static List<ItemStack> generateEntityBuckets() {
        LinkedList<ItemStack> buckets = new LinkedList<ItemStack>();
        List validFluids = FluidRegistry.getBucketFluids().stream().filter(IEntityBucket::isFluidValid).collect(Collectors.toList());
        IEntityBucket.getValidBuckets().forEach(bucket -> {
            if (bucket == Items.field_151131_as) {
                AbstractEntityBucketHandler.BUCKET_HANDLERS.values().forEach(handler -> ((AbstractEntityBucketHandler)handler.get()).getSubTypes(buckets, new ItemStack(bucket)));
            } else if (FluidRegistry.isUniversalBucketEnabled() && bucket == ForgeModContainer.getInstance().universalBucket) {
                validFluids.forEach(fluid -> AbstractEntityBucketHandler.BUCKET_HANDLERS.values().forEach(handler -> {
                    FluidStack fluidStack;
                    ItemStack stack;
                    IFluidHandlerItem fluidHandler = FluidUtil.getFluidHandler((ItemStack)new ItemStack(bucket));
                    if (fluidHandler != null && IEntityBucket.get((ICapabilityProvider)(stack = FluidUtil.getFilledBucket((FluidStack)(fluidStack = new FluidStack(fluid, 1000))))) != null && fluidHandler.fill(fluidStack, false) >= 1000) {
                        ((AbstractEntityBucketHandler)handler.get()).getSubTypes(buckets, stack);
                    }
                }));
            } else {
                validFluids.add(0, FluidRegistry.WATER);
                validFluids.forEach(fluid -> AbstractEntityBucketHandler.BUCKET_HANDLERS.values().forEach(handler -> {
                    ItemStack stack = new ItemStack(bucket);
                    IFluidHandlerItem fluidHandler = FluidUtil.getFluidHandler((ItemStack)stack);
                    if (fluidHandler != null && fluidHandler.fill(new FluidStack(fluid, 1000), true) >= 1000) {
                        ((AbstractEntityBucketHandler)handler.get()).getSubTypes(buckets, stack);
                    }
                }));
            }
        });
        return buckets;
    }

    public boolean hasSearchBar() {
        return true;
    }

    public int getLabelColor() {
        return 7433554;
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public ResourceLocation getBackgroundImage() {
        return new ResourceLocation("subaquatic", "textures/gui/container/creative_inventory/items.png");
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_78017_i() {
        SubaquaticCreativeTab.applyTabsTexture();
        return super.func_78017_i();
    }

    @SideOnly(value=Side.CLIENT)
    public int func_78020_k() {
        SubaquaticCreativeTab.applyTabsTexture();
        return super.func_78020_k();
    }

    @SideOnly(value=Side.CLIENT)
    static void applyTabsTexture() {
        TextureManager manager = Minecraft.func_71410_x().func_110434_K();
        ITextureObject texture = manager.func_110581_b(GuiContainerCreative.field_147061_u);
        if (texture != null && texture.func_110552_b() == GlStateManager.field_179174_p[GlStateManager.field_179162_o].field_179059_b) {
            manager.func_110577_a(new ResourceLocation("subaquatic", "textures/gui/container/creative_inventory/tabs.png"));
        }
    }
}

