/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.subaquatic.mod.common.message;

import git.jbredwards.fluidlogged_api.api.network.IClientMessageHandler;
import git.jbredwards.fluidlogged_api.api.network.message.AbstractMessage;
import git.jbredwards.subaquatic.mod.common.capability.IBoatType;
import git.jbredwards.subaquatic.mod.common.capability.util.BoatType;
import git.jbredwards.subaquatic.mod.common.config.SubaquaticBoatTypesConfig;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class SMessageBoatType
extends AbstractMessage {
    public int boatTypeId;
    public int entityId;

    public SMessageBoatType() {
    }

    public SMessageBoatType(@Nonnull BoatType typeIn, @Nonnull Entity entityIn) {
        this.boatTypeId = SubaquaticBoatTypesConfig.getIndex(typeIn.boat, typeIn.boatMeta);
        this.entityId = entityIn.func_145782_y();
        this.isValid = true;
    }

    public void read(@Nonnull PacketBuffer buf) {
        this.boatTypeId = buf.func_150792_a();
        this.entityId = buf.func_150792_a();
    }

    public void write(@Nonnull PacketBuffer buf) {
        buf.func_150787_b(this.boatTypeId);
        buf.func_150787_b(this.entityId);
    }

    public static enum Handler implements IClientMessageHandler<SMessageBoatType>
    {
        INSTANCE;


        @SideOnly(value=Side.CLIENT)
        public void handleMessage(@Nonnull SMessageBoatType message) {
            IBoatType cap = IBoatType.get((ICapabilityProvider)Minecraft.func_71410_x().field_71441_e.func_73045_a(message.entityId));
            if (cap != null) {
                cap.setType((BoatType)SubaquaticBoatTypesConfig.BOAT_TYPES_LOOKUP.get(message.boatTypeId));
            }
        }
    }
}

