/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.subaquatic.mod.common.recipe;

import git.jbredwards.subaquatic.mod.Subaquatic;
import git.jbredwards.subaquatic.mod.common.message.SMessageBottleParticles;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.BlockMagma;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.dispenser.BehaviorDefaultDispenseItem;
import net.minecraft.dispenser.IBehaviorDispenseItem;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="subaquatic")
public class BlockSoakRecipe {
    @Nonnull
    public static final List<BlockSoakRecipe> RECIPES = new LinkedList<BlockSoakRecipe>();
    @Nonnull
    public final List<PotionType> potionTypes;
    @Nonnull
    public final List<Pair<IBlockState, ItemStack>> inputs;
    @Nonnull
    public final Pair<IBlockState, ItemStack> output;

    public BlockSoakRecipe(@Nonnull List<Pair<IBlockState, ItemStack>> inputsIn, @Nonnull Pair<IBlockState, ItemStack> outputIn) {
        this(Collections.singletonList(PotionTypes.field_185230_b), inputsIn, outputIn);
    }

    public BlockSoakRecipe(@Nonnull List<PotionType> potionTypesIn, @Nonnull List<Pair<IBlockState, ItemStack>> inputsIn, @Nonnull Pair<IBlockState, ItemStack> outputIn) {
        this.potionTypes = Collections.unmodifiableList(potionTypesIn);
        this.inputs = Collections.unmodifiableList(inputsIn);
        this.output = outputIn;
    }

    public boolean checkRecipe(@Nonnull IBlockState state, @Nonnull PotionType potion) {
        if (!this.potionTypes.contains(potion)) {
            return false;
        }
        for (Pair<IBlockState, ItemStack> validInput : this.inputs) {
            if (validInput.getLeft() != state) continue;
            return true;
        }
        return false;
    }

    @Nonnull
    public ItemStack apply(@Nonnull ItemStack stack, @Nonnull IBlockState oldState, @Nonnull World world, @Nonnull BlockPos pos, @Nullable EntityPlayer player) {
        if (!world.field_72995_K) {
            world.func_184133_a(null, pos, SoundEvents.field_187547_bF, SoundCategory.PLAYERS, 1.0f, 1.0f);
            this.playSoakEffects(stack, oldState, world, pos);
            world.func_175656_a(pos, (IBlockState)this.output.getLeft());
        }
        if (player == null || !player.func_184812_l_()) {
            return new ItemStack(Items.field_151069_bo);
        }
        return stack;
    }

    protected void playSoakEffects(@Nonnull ItemStack stack, @Nonnull IBlockState oldState, @Nonnull World world, @Nonnull BlockPos pos) {
        if (oldState.func_177230_c() instanceof BlockMagma || oldState.func_185904_a() == Material.field_151581_o || oldState.func_185904_a() == Material.field_151587_i || oldState.func_177230_c().isBurning((IBlockAccess)world, pos) || oldState.getLightValue((IBlockAccess)world, pos) != 0 && ((IBlockState)this.output.getLeft()).func_185906_d() == 0) {
            world.func_175718_b(1009, pos, 0);
            ((WorldServer)world).func_175739_a(EnumParticleTypes.SMOKE_LARGE, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 8, 0.3, 0.3, 0.3, 0.0, new int[0]);
        } else {
            Subaquatic.WRAPPER.sendToAllAround((IMessage)new SMessageBottleParticles(pos, PotionUtils.func_190932_c((ItemStack)stack)), new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 64.0));
        }
    }

    @Nonnull
    public static IBehaviorDispenseItem getDispenserHandler() {
        return new BehaviorDefaultDispenseItem(){

            @Nonnull
            protected ItemStack func_82487_b(@Nonnull IBlockSource source, @Nonnull ItemStack stack) {
                PotionType potion;
                EnumFacing facing = (EnumFacing)source.func_189992_e().func_177229_b((IProperty)BlockDispenser.field_176441_a);
                if (facing != EnumFacing.UP && (potion = PotionUtils.func_185191_c((ItemStack)stack)) != null) {
                    BlockPos pos = source.func_180699_d().func_177972_a(facing);
                    IBlockState state = source.func_82618_k().func_180495_p(pos);
                    for (BlockSoakRecipe recipe : RECIPES) {
                        if (!recipe.checkRecipe(state, potion)) continue;
                        ItemStack result = recipe.apply(stack, state, source.func_82618_k(), pos, null);
                        if (stack.func_190916_E() == 1) {
                            return result;
                        }
                        if (((TileEntityDispenser)source.func_150835_j()).func_146019_a(result) < 0) {
                            super.func_82487_b(source, result);
                        }
                        return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.func_190916_E() - 1));
                    }
                }
                return super.func_82487_b(source, stack);
            }
        };
    }

    @SubscribeEvent
    static void onBottleRightClick(@Nonnull PlayerInteractEvent.RightClickBlock event) {
        PotionType potion;
        ItemStack stack;
        if (event.getFace() != EnumFacing.DOWN && (stack = event.getItemStack()).func_77973_b() == Items.field_151068_bn && (potion = PotionUtils.func_185191_c((ItemStack)stack)) != null) {
            IBlockState state = event.getWorld().func_180495_p(event.getPos());
            for (BlockSoakRecipe recipe : RECIPES) {
                if (!recipe.checkRecipe(state, potion)) continue;
                EntityPlayer player = event.getEntityPlayer();
                ItemStack result = recipe.apply(stack, state, event.getWorld(), event.getPos(), player);
                if (result != stack) {
                    stack.func_190918_g(1);
                    if (stack.func_190926_b()) {
                        player.func_184611_a(event.getHand(), result);
                    } else {
                        ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)result);
                    }
                }
                event.setCancellationResult(EnumActionResult.SUCCESS);
                event.setCanceled(true);
                return;
            }
        }
    }
}

