/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.subaquatic.mod.common.world.biome;

import git.jbredwards.subaquatic.api.biome.BiomeSubaquaticOcean;
import git.jbredwards.subaquatic.mod.common.init.SubaquaticBiomes;
import git.jbredwards.subaquatic.mod.common.init.SubaquaticBlocks;
import git.jbredwards.subaquatic.mod.common.world.gen.feature.WorldGenBlueIce;
import git.jbredwards.subaquatic.mod.common.world.gen.feature.WorldGenIceberg;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.monster.EntityPolarBear;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityStray;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeDecorator;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.NoiseGeneratorPerlin;

public class BiomeFrozenOcean
extends BiomeSubaquaticOcean {
    @Nonnull
    protected static final NoiseGeneratorPerlin NOISE = new NoiseGeneratorPerlin(new Random(3456L), 3);
    protected NoiseGeneratorPerlin perlin1;
    protected NoiseGeneratorPerlin perlin2;
    protected long prevSeed;

    public BiomeFrozenOcean(@Nonnull Biome.BiomeProperties propertiesIn) {
        this(null, propertiesIn);
    }

    public BiomeFrozenOcean(@Nullable Biome deepOceanBiomeIn, @Nonnull Biome.BiomeProperties propertiesIn) {
        super(deepOceanBiomeIn, propertiesIn);
        this.field_76761_J.removeIf(entry -> entry.field_76300_b == EntitySkeleton.class);
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityStray.class, 100, 4, 4));
        this.field_76762_K.add(new Biome.SpawnListEntry(EntityPolarBear.class, 1, 1, 2));
    }

    @Override
    @Nonnull
    public Biome getMixOceanBiome() {
        return SubaquaticBiomes.COLD_OCEAN;
    }

    @Nonnull
    public BiomeDecorator func_76729_a() {
        return this.getModdedBiomeDecorator(new BiomeDecorator(){

            protected void func_150513_a(@Nonnull Biome biomeIn, @Nonnull World worldIn, @Nonnull Random rand) {
                BlockPos pos;
                int offsetZ;
                int offsetX;
                if ((double)rand.nextFloat() < 0.0625) {
                    offsetX = rand.nextInt(8) + 12;
                    offsetZ = rand.nextInt(8) + 12;
                    pos = worldIn.func_175645_m(this.field_180294_c.func_177982_a(offsetX, 0, offsetZ));
                    new WorldGenIceberg(Blocks.field_150403_cj.func_176223_P()).func_180709_b(worldIn, rand, pos);
                }
                if ((double)rand.nextFloat() < 0.005) {
                    offsetX = rand.nextInt(8) + 12;
                    offsetZ = rand.nextInt(8) + 12;
                    pos = worldIn.func_175645_m(this.field_180294_c.func_177982_a(offsetX, 0, offsetZ));
                    new WorldGenIceberg(SubaquaticBlocks.BLUE_ICE.func_176223_P()).func_180709_b(worldIn, rand, pos);
                }
                this.func_76795_a(worldIn, rand, 20, new WorldGenBlueIce(), 30, 64);
                super.func_150513_a(biomeIn, worldIn, rand);
            }
        });
    }

    public void func_180622_a(@Nonnull World worldIn, @Nonnull Random rand, @Nonnull ChunkPrimer chunkPrimerIn, int posX, int posZ, double noiseVal) {
        this.setSeed(worldIn.func_72905_C());
        this.buildSurface(worldIn, rand, chunkPrimerIn, posX, posZ, noiseVal);
    }

    protected void buildSurface(@Nonnull World world, @Nonnull Random rand, @Nonnull ChunkPrimer primer, int posX, int posZ, double noiseVal) {
        int seaLevel = world.func_181545_F();
        double maxHeight = 0.0;
        double minHeight = 0.0;
        int xNoiseIn = (posX & 0xFFFFFFF0) + (posZ & 0xF);
        int zNoiseIn = (posZ & 0xFFFFFFF0) + (posX & 0xF);
        double d2 = Math.min(Math.abs(noiseVal), this.perlin1.func_151601_a((double)xNoiseIn * 0.1, (double)zNoiseIn * 0.1));
        if (d2 > 1.8) {
            double noiseScale = 0.09765625;
            maxHeight = d2 * d2 * 1.2;
            double d4 = Math.abs(this.perlin2.func_151601_a((double)xNoiseIn * 0.09765625, (double)zNoiseIn * 0.09765625));
            double d5 = Math.ceil(d4 * 40.0) + 14.0;
            if (maxHeight > d5) {
                maxHeight = d5;
            }
            BlockPos blockPos = new BlockPos(xNoiseIn, 63, zNoiseIn);
            if ((double)this.func_180626_a(blockPos) > 0.1) {
                maxHeight -= 2.0;
            }
            if (maxHeight > 2.0) {
                minHeight = (double)seaLevel - maxHeight - 7.0;
                maxHeight += (double)seaLevel;
            } else {
                maxHeight = 0.0;
            }
        }
        int x = posZ & 0xF;
        int z = posX & 0xF;
        IBlockState filler = this.field_76753_B;
        IBlockState top = this.field_76752_A;
        int oceanSurfaceY = (int)(noiseVal / 3.0 + 3.0 + rand.nextDouble() * 0.25);
        int j = -1;
        int currentSnowLayer = 0;
        int maxSnowLayers = 2 + rand.nextInt(4);
        int snowMinY = seaLevel + 8 + rand.nextInt(10);
        for (int posY = 255; posY >= 0; --posY) {
            if (posY <= rand.nextInt(5)) {
                primer.func_177855_a(x, posY, z, field_185367_c);
                continue;
            }
            if (primer.func_177856_a(x, posY, z).func_177230_c() == Blocks.field_150350_a && posY < (int)maxHeight && rand.nextDouble() > 0.01) {
                primer.func_177855_a(x, posY, z, Blocks.field_150403_cj.func_176223_P());
            } else if (primer.func_177856_a(x, posY, z).func_185904_a() == Material.field_151586_h && posY > (int)minHeight && posY < seaLevel && minHeight != 0.0 && rand.nextDouble() > 0.15) {
                primer.func_177855_a(x, posY, z, Blocks.field_150403_cj.func_176223_P());
            }
            IBlockState here = primer.func_177856_a(x, posY, z);
            if (here.func_177230_c() == Blocks.field_150350_a) {
                j = -1;
                continue;
            }
            if (here.func_177230_c() != field_185365_a.func_177230_c()) {
                if (here.func_177230_c() != Blocks.field_150403_cj || currentSnowLayer > maxSnowLayers || posY <= snowMinY) continue;
                primer.func_177855_a(x, posY, z, Blocks.field_150433_aE.func_176223_P());
                ++currentSnowLayer;
                continue;
            }
            if (j == -1) {
                if (oceanSurfaceY <= 0) {
                    top = field_185366_b;
                    filler = field_185365_a;
                } else if (posY >= seaLevel - 4 && posY <= seaLevel + 1) {
                    top = this.field_76752_A;
                    filler = this.field_76753_B;
                }
                if (posY < seaLevel && top.func_177230_c() == Blocks.field_150350_a) {
                    top = (double)this.func_180626_a(new BlockPos(xNoiseIn, posY, zNoiseIn)) < 0.15 ? field_185371_g : field_185372_h;
                }
                j = oceanSurfaceY;
                if (posY >= seaLevel - 1) {
                    primer.func_177855_a(x, posY, z, top);
                    continue;
                }
                if (posY < seaLevel - 7 - oceanSurfaceY) {
                    top = field_185366_b;
                    filler = field_185365_a;
                    primer.func_177855_a(x, posY, z, field_185368_d);
                    continue;
                }
                primer.func_177855_a(x, posY, z, filler);
                continue;
            }
            if (j <= 0) continue;
            --j;
            primer.func_177855_a(x, posY, z, filler);
        }
    }

    protected void setSeed(long seed) {
        if (seed != this.prevSeed || this.perlin1 == null || this.perlin2 == null) {
            Random rand = new Random(seed);
            this.perlin1 = new NoiseGeneratorPerlin(rand, 4);
            this.perlin2 = new NoiseGeneratorPerlin(rand, 1);
            this.prevSeed = seed;
        }
    }

    public final float func_180626_a(@Nonnull BlockPos pos) {
        double otherTemp;
        float defaultTemp = this.func_185353_n();
        double noiseTemp = NOISE.func_151601_a((double)pos.func_177958_n() * 0.05, (double)pos.func_177952_p() * 0.05);
        if (noiseTemp + (otherTemp = field_180281_af.func_151601_a((double)pos.func_177958_n() * 0.2, (double)pos.func_177952_p() * 0.2)) < 0.3 && field_180281_af.func_151601_a((double)pos.func_177958_n() * 0.09, (double)pos.func_177952_p() * 0.09) < 0.8) {
            defaultTemp = 0.2f;
        }
        if (pos.func_177956_o() > 64) {
            float temp = (float)(field_150605_ac.func_151601_a((double)pos.func_177958_n() / 8.0, (double)pos.func_177952_p() / 8.0) * 4.0);
            return defaultTemp - (temp + (float)pos.func_177956_o() - 64.0f) * 0.05f / 30.0f;
        }
        return defaultTemp;
    }
}

