/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.subaquatic.mod.common.world.gen.feature;

import git.jbredwards.fluidlogged_api.api.util.FluidloggedUtils;
import git.jbredwards.subaquatic.mod.common.block.AbstractBlockCoral;
import git.jbredwards.subaquatic.mod.common.block.BlockCoralFan;
import git.jbredwards.subaquatic.mod.common.config.SubaquaticConfigHandler;
import git.jbredwards.subaquatic.mod.common.init.SubaquaticBlocks;
import git.jbredwards.subaquatic.mod.common.world.gen.IConfigurableWorldGenerator;
import git.jbredwards.subaquatic.mod.common.world.gen.feature.coral.CoralStructureClaw;
import git.jbredwards.subaquatic.mod.common.world.gen.feature.coral.CoralStructureMushroom;
import git.jbredwards.subaquatic.mod.common.world.gen.feature.coral.CoralStructureTree;
import git.jbredwards.subaquatic.mod.common.world.gen.feature.coral.ICoralBlockSupplier;
import git.jbredwards.subaquatic.mod.common.world.gen.feature.coral.ICoralStructure;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fluids.Fluid;

public enum GeneratorCoral implements IConfigurableWorldGenerator
{
    INSTANCE;

    @Nonnull
    public static final List<ICoralStructure> CORAL_GENERATORS;
    @Nonnull
    public static final List<ICoralBlockSupplier> CORAL_BLOCKS;
    @Nonnull
    public static final List<ICoralBlockSupplier> CORAL_FANS;
    @Nonnull
    public static final List<ICoralBlockSupplier> CORAL_FINS;

    public void generate(@Nonnull Random random, int chunkX, int chunkZ, @Nonnull World world, @Nonnull IChunkGenerator chunkGenerator, @Nonnull IChunkProvider chunkProvider) {
        if (SubaquaticConfigHandler.Server.World.Coral.enabled && this.isDimensionValid(world, SubaquaticConfigHandler.Server.World.Coral.dimensions)) {
            int originX = chunkX << 4 | 8;
            int originZ = chunkZ << 4 | 8;
            double noiseVal = Biome.field_180281_af.func_151601_a((double)originX / 400.0, (double)originZ / 400.0);
            int count = (int)Math.ceil(noiseVal * (double)this.getMaxForBiome(world, originX, originZ, SubaquaticConfigHandler.Server.World.Coral.PER_BIOME_RARITY, SubaquaticConfigHandler.Server.World.Coral.defaultAmount));
            for (int i = 0; i < count; ++i) {
                IBlockState down;
                BlockPos pos = world.func_175672_r(new BlockPos(originX + random.nextInt(16), 0, originZ + random.nextInt(16)));
                ICoralBlockSupplier coralBlock = CORAL_BLOCKS.get(random.nextInt(CORAL_BLOCKS.size()));
                if (!FluidloggedUtils.isCompatibleFluid((Fluid)coralBlock.getNeededFluid(), (Fluid)FluidloggedUtils.getFluidFromState((IBlockState)world.func_180495_p(pos))) || !(down = world.func_180495_p(pos.func_177977_b())).func_185896_q() || CORAL_BLOCKS.contains(down.func_177230_c())) continue;
                CORAL_GENERATORS.get(random.nextInt(CORAL_GENERATORS.size())).generate(world, random, pos, coralBlock);
            }
        }
    }

    public static void registerCoral(@Nonnull List<ICoralBlockSupplier> registeredCorals, @Nonnull AbstractBlockCoral coral) {
        GeneratorCoral.registerCoral(registeredCorals, coral, coral.neededFluid, coral instanceof BlockCoralFan ? side -> coral.func_176223_P().func_177226_a((IProperty)BlockCoralFan.SIDE, (Comparable)side) : side -> coral.func_176223_P());
    }

    public static void registerCoral(@Nonnull List<ICoralBlockSupplier> registeredCorals, @Nonnull Block coral, @Nonnull Fluid neededFluid) {
        IProperty facingProp = coral.func_176194_O().func_177623_d().stream().filter(prop -> prop.func_177699_b() == EnumFacing.class && (prop.func_177701_a().equals("facing") || prop.func_177701_a().equals("side") || prop.func_177701_a().equals("rotation"))).findFirst().orElse(null);
        GeneratorCoral.registerCoral(registeredCorals, coral, neededFluid, facingProp != null ? side -> coral.func_176223_P().func_177226_a(facingProp, (Comparable)side) : side -> coral.func_176223_P());
    }

    public static void registerCoral(@Nonnull List<ICoralBlockSupplier> registeredCorals, final @Nonnull Block coral, final @Nonnull Fluid neededFluid, final @Nonnull Function<EnumFacing, IBlockState> directionHandler) {
        registeredCorals.add(new ICoralBlockSupplier(){

            @Override
            @Nonnull
            public Block getBlock() {
                return coral;
            }

            @Override
            @Nonnull
            public Fluid getNeededFluid() {
                return neededFluid;
            }

            @Override
            @Nonnull
            public IBlockState withDirection(@Nonnull EnumFacing direction) {
                return (IBlockState)directionHandler.apply(direction);
            }
        });
    }

    public static void registerDefaults() {
        CORAL_GENERATORS.add(CoralStructureClaw.INSTANCE);
        CORAL_GENERATORS.add(CoralStructureMushroom.INSTANCE);
        CORAL_GENERATORS.add(CoralStructureTree.INSTANCE);
        GeneratorCoral.registerCoral(CORAL_BLOCKS, SubaquaticBlocks.BRAIN_CORAL_BLOCK);
        GeneratorCoral.registerCoral(CORAL_BLOCKS, SubaquaticBlocks.BUBBLE_CORAL_BLOCK);
        GeneratorCoral.registerCoral(CORAL_BLOCKS, SubaquaticBlocks.FIRE_CORAL_BLOCK);
        GeneratorCoral.registerCoral(CORAL_BLOCKS, SubaquaticBlocks.HORN_CORAL_BLOCK);
        GeneratorCoral.registerCoral(CORAL_BLOCKS, SubaquaticBlocks.TUBE_CORAL_BLOCK);
        GeneratorCoral.registerCoral(CORAL_FANS, SubaquaticBlocks.BRAIN_CORAL_FAN);
        GeneratorCoral.registerCoral(CORAL_FANS, SubaquaticBlocks.BUBBLE_CORAL_FAN);
        GeneratorCoral.registerCoral(CORAL_FANS, SubaquaticBlocks.FIRE_CORAL_FAN);
        GeneratorCoral.registerCoral(CORAL_FANS, SubaquaticBlocks.HORN_CORAL_FAN);
        GeneratorCoral.registerCoral(CORAL_FANS, SubaquaticBlocks.TUBE_CORAL_FAN);
        GeneratorCoral.registerCoral(CORAL_FINS, SubaquaticBlocks.BRAIN_CORAL_FIN);
        GeneratorCoral.registerCoral(CORAL_FINS, SubaquaticBlocks.BUBBLE_CORAL_FIN);
        GeneratorCoral.registerCoral(CORAL_FINS, SubaquaticBlocks.FIRE_CORAL_FIN);
        GeneratorCoral.registerCoral(CORAL_FINS, SubaquaticBlocks.HORN_CORAL_FIN);
        GeneratorCoral.registerCoral(CORAL_FINS, SubaquaticBlocks.TUBE_CORAL_FIN);
    }

    static {
        CORAL_GENERATORS = new ArrayList<ICoralStructure>();
        CORAL_BLOCKS = new ArrayList<ICoralBlockSupplier>();
        CORAL_FANS = new ArrayList<ICoralBlockSupplier>();
        CORAL_FINS = new ArrayList<ICoralBlockSupplier>();
    }
}

