/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.subaquatic.mod.common.world.gen.feature;

import git.jbredwards.subaquatic.mod.common.config.SubaquaticConfigHandler;
import git.jbredwards.subaquatic.mod.common.init.SubaquaticBlocks;
import git.jbredwards.subaquatic.mod.common.tileentity.TileEntityGlowLichen;
import git.jbredwards.subaquatic.mod.common.world.gen.IConfigurableWorldGenerator;
import java.util.Arrays;
import java.util.Collections;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;

public enum GeneratorGlowLichen implements IConfigurableWorldGenerator
{
    INSTANCE;


    public void generate(@Nonnull Random random, int chunkX, int chunkZ, @Nonnull World world, @Nonnull IChunkGenerator chunkGenerator, @Nonnull IChunkProvider chunkProvider) {
        if (SubaquaticConfigHandler.Server.World.GlowLichen.enabled && this.isDimensionValid(world, SubaquaticConfigHandler.Server.World.GlowLichen.dimensions)) {
            int originX = chunkX << 4 | 8;
            int originZ = chunkZ << 4 | 8;
            int amount = this.getMaxForBiome(world, originX, originZ, SubaquaticConfigHandler.Server.World.GlowLichen.PER_BIOME_RARITY, SubaquaticConfigHandler.Server.World.GlowLichen.defaultAmount);
            block0: for (int i = 0; i < amount; ++i) {
                BlockPos pos = new BlockPos(originX + random.nextInt(16), MathHelper.func_76136_a((Random)random, (int)SubaquaticConfigHandler.Server.World.GlowLichen.minHeight, (int)SubaquaticConfigHandler.Server.World.GlowLichen.maxHeight), originZ + random.nextInt(16));
                IBlockState here = world.func_180495_p(pos);
                if (here.func_185904_a() != Material.field_151586_h && !here.func_177230_c().isAir(here, (IBlockAccess)world, pos) || SubaquaticConfigHandler.Server.World.GlowLichen.maxLight != 15 && SubaquaticConfigHandler.Server.World.GlowLichen.maxLight < world.func_175699_k(pos)) continue;
                EnumFacing[] sides = (EnumFacing[])EnumFacing.field_176754_o.clone();
                Collections.shuffle(Arrays.asList(sides), random);
                for (EnumFacing side : sides) {
                    if (world.func_180495_p(pos.func_177972_a(side)).func_185904_a() != Material.field_151576_e) continue;
                    TileEntityGlowLichen tile = new TileEntityGlowLichen();
                    tile.attachedSideData = 0;
                    tile.setAttachedTo(side, true);
                    world.func_180501_a(pos, SubaquaticBlocks.GLOW_LICHEN.func_176223_P(), 0);
                    world.func_175690_a(pos, (TileEntity)tile);
                    continue block0;
                }
            }
        }
    }
}

