/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.subaquatic.mod.common.world.gen.feature;

import git.jbredwards.fluidlogged_api.api.util.FluidloggedUtils;
import git.jbredwards.subaquatic.mod.common.block.BlockKelp;
import git.jbredwards.subaquatic.mod.common.config.SubaquaticConfigHandler;
import git.jbredwards.subaquatic.mod.common.init.SubaquaticBlocks;
import git.jbredwards.subaquatic.mod.common.world.gen.IConfigurableWorldGenerator;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fluids.Fluid;

public enum GeneratorKelp implements IConfigurableWorldGenerator
{
    INSTANCE;


    public void generate(@Nonnull Random random, int chunkX, int chunkZ, @Nonnull World world, @Nonnull IChunkGenerator chunkGenerator, @Nonnull IChunkProvider chunkProvider) {
        if (SubaquaticConfigHandler.Server.World.Kelp.enabled && this.isDimensionValid(world, SubaquaticConfigHandler.Server.World.Kelp.dimensions)) {
            int originX = chunkX << 4 | 8;
            int originZ = chunkZ << 4 | 8;
            double noiseVal = Biome.field_180281_af.func_151601_a((double)originX / 80.0, (double)originZ / 80.0);
            int count = (int)Math.ceil(noiseVal * (double)this.getMaxForBiome(world, originX, originZ, SubaquaticConfigHandler.Server.World.Kelp.PER_BIOME_RARITY, SubaquaticConfigHandler.Server.World.Kelp.defaultAmount));
            for (int i = 0; i < count; ++i) {
                Fluid fluidHere;
                BlockPos pos = world.func_175672_r(new BlockPos(originX + random.nextInt(16), 0, originZ + random.nextInt(16)));
                if (!world.func_180495_p(pos.func_177977_b()).func_185896_q() || !SubaquaticBlocks.KELP.func_176196_c(world, pos)) continue;
                int height = MathHelper.func_76136_a((Random)random, (int)SubaquaticConfigHandler.Server.World.Kelp.minHeight, (int)SubaquaticConfigHandler.Server.World.Kelp.maxHeight);
                for (int y = 0; y < height && (fluidHere = FluidloggedUtils.getFluidFromState((IBlockState)world.func_180495_p(pos))) != null && SubaquaticBlocks.KELP.isFluidValid(SubaquaticBlocks.KELP.func_176223_P(), world, pos, fluidHere); ++y) {
                    world.func_180501_a(pos, SubaquaticBlocks.KELP.func_176223_P().func_177226_a((IProperty)BlockKelp.AGE, (Comparable)Integer.valueOf(random.nextInt(16))), 2);
                    pos = pos.func_177984_a();
                }
            }
        }
    }
}

